/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 26.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.AddressConsumer;
import travel.wink.sdk.inventory.model.ContactConsumer;
import travel.wink.sdk.inventory.model.DowPatternGroupConsumer;
import travel.wink.sdk.inventory.model.GeoJsonPointConsumer;
import travel.wink.sdk.inventory.model.SimpleDescriptionConsumer;
import travel.wink.sdk.inventory.model.SimpleMultimediaConsumer;
import travel.wink.sdk.inventory.model.SocialConsumer;
import travel.wink.sdk.inventory.model.TravelInventoryRecognitionConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Inventory data object
 */
@JsonPropertyOrder({
  MeetingRoomConsumer.JSON_PROPERTY_IDENTIFIER,
  MeetingRoomConsumer.JSON_PROPERTY_HOTEL_IDENTIFIER,
  MeetingRoomConsumer.JSON_PROPERTY_FEATURED_IND,
  MeetingRoomConsumer.JSON_PROPERTY_LIFESTYLE_TYPE,
  MeetingRoomConsumer.JSON_PROPERTY_LOCATION,
  MeetingRoomConsumer.JSON_PROPERTY_DESCRIPTIONS,
  MeetingRoomConsumer.JSON_PROPERTY_MULTIMEDIAS,
  MeetingRoomConsumer.JSON_PROPERTY_CONTACT,
  MeetingRoomConsumer.JSON_PROPERTY_ADDRESS,
  MeetingRoomConsumer.JSON_PROPERTY_COMMISSIONABLE,
  MeetingRoomConsumer.JSON_PROPERTY_NAME,
  MeetingRoomConsumer.JSON_PROPERTY_PROXIMITY_CODE,
  MeetingRoomConsumer.JSON_PROPERTY_SORT,
  MeetingRoomConsumer.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  MeetingRoomConsumer.JSON_PROPERTY_BOOKABLE,
  MeetingRoomConsumer.JSON_PROPERTY_ACTIVE,
  MeetingRoomConsumer.JSON_PROPERTY_DISABILITY_FEATURES,
  MeetingRoomConsumer.JSON_PROPERTY_SECURITY_FEATURES,
  MeetingRoomConsumer.JSON_PROPERTY_SOCIALS,
  MeetingRoomConsumer.JSON_PROPERTY_PRICE_POINT,
  MeetingRoomConsumer.JSON_PROPERTY_RECOGNITION_LIST,
  MeetingRoomConsumer.JSON_PROPERTY_APPLICABLE_START,
  MeetingRoomConsumer.JSON_PROPERTY_APPLICABLE_END,
  MeetingRoomConsumer.JSON_PROPERTY_RESERVATION_REQUIRED_IND,
  MeetingRoomConsumer.JSON_PROPERTY_OPENS,
  MeetingRoomConsumer.JSON_PROPERTY_CLOSES,
  MeetingRoomConsumer.JSON_PROPERTY_DAYS_OF_WEEK,
  MeetingRoomConsumer.JSON_PROPERTY_IRREGULAR,
  MeetingRoomConsumer.JSON_PROPERTY_MEETING_ROOM_CAPACITY,
  MeetingRoomConsumer.JSON_PROPERTY_ACCESS,
  MeetingRoomConsumer.JSON_PROPERTY_MEETING_ROOM_TYPE_CODE,
  MeetingRoomConsumer.JSON_PROPERTY_MEETING_ROOM_LEVEL,
  MeetingRoomConsumer.JSON_PROPERTY_DEDICATED_IND,
  MeetingRoomConsumer.JSON_PROPERTY_AREA,
  MeetingRoomConsumer.JSON_PROPERTY_HEIGHT,
  MeetingRoomConsumer.JSON_PROPERTY_WIDTH,
  MeetingRoomConsumer.JSON_PROPERTY_LENGTH,
  MeetingRoomConsumer.JSON_PROPERTY_AMENITIES
})
@JsonTypeName("MeetingRoom_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-10T15:17:48.788265091+07:00[Asia/Bangkok]")
public class MeetingRoomConsumer {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointConsumer location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionConsumer> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaConsumer> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactConsumer contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressConsumer address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures = new ArrayList<>();

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures = new ArrayList<>();

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialConsumer> socials = new ArrayList<>();

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognitionConsumer> recognitionList = new ArrayList<>();

  public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
  private LocalDate applicableStart;

  public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
  private LocalDate applicableEnd;

  public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
  private Boolean reservationRequiredInd;

  public static final String JSON_PROPERTY_OPENS = "opens";
  private String opens;

  public static final String JSON_PROPERTY_CLOSES = "closes";
  private String closes;

  public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
  private DowPatternGroupConsumer daysOfWeek;

  public static final String JSON_PROPERTY_IRREGULAR = "irregular";
  private Boolean irregular = false;

  public static final String JSON_PROPERTY_MEETING_ROOM_CAPACITY = "meetingRoomCapacity";
  private Integer meetingRoomCapacity = 0;

  public static final String JSON_PROPERTY_ACCESS = "access";
  private String access = "MEETING_ROOM_ACCESS_PRIVATE";

  public static final String JSON_PROPERTY_MEETING_ROOM_TYPE_CODE = "meetingRoomTypeCode";
  private String meetingRoomTypeCode;

  public static final String JSON_PROPERTY_MEETING_ROOM_LEVEL = "meetingRoomLevel";
  private String meetingRoomLevel;

  public static final String JSON_PROPERTY_DEDICATED_IND = "dedicatedInd";
  private Boolean dedicatedInd;

  public static final String JSON_PROPERTY_AREA = "area";
  private Float area;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Float height;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Float width;

  public static final String JSON_PROPERTY_LENGTH = "length";
  private Float length;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities = new ArrayList<>();

  public MeetingRoomConsumer() {
  }

  public MeetingRoomConsumer identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public MeetingRoomConsumer hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public MeetingRoomConsumer featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public MeetingRoomConsumer lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public MeetingRoomConsumer location(GeoJsonPointConsumer location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointConsumer getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointConsumer location) {
    this.location = location;
  }


  public MeetingRoomConsumer descriptions(List<SimpleDescriptionConsumer> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public MeetingRoomConsumer addDescriptionsItem(SimpleDescriptionConsumer descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionConsumer> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionConsumer> descriptions) {
    this.descriptions = descriptions;
  }


  public MeetingRoomConsumer multimedias(List<SimpleMultimediaConsumer> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public MeetingRoomConsumer addMultimediasItem(SimpleMultimediaConsumer multimediasItem) {
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimediaConsumer> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimediaConsumer> multimedias) {
    this.multimedias = multimedias;
  }


  public MeetingRoomConsumer contact(ContactConsumer contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactConsumer getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(ContactConsumer contact) {
    this.contact = contact;
  }


  public MeetingRoomConsumer address(AddressConsumer address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressConsumer getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressConsumer address) {
    this.address = address;
  }


  public MeetingRoomConsumer commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public MeetingRoomConsumer name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public MeetingRoomConsumer proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public MeetingRoomConsumer sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public MeetingRoomConsumer minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public MeetingRoomConsumer bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public MeetingRoomConsumer active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public MeetingRoomConsumer disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public MeetingRoomConsumer addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public MeetingRoomConsumer securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public MeetingRoomConsumer addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public MeetingRoomConsumer socials(List<SocialConsumer> socials) {
    
    this.socials = socials;
    return this;
  }

  public MeetingRoomConsumer addSocialsItem(SocialConsumer socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialConsumer> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialConsumer> socials) {
    this.socials = socials;
  }


  public MeetingRoomConsumer pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public MeetingRoomConsumer recognitionList(List<TravelInventoryRecognitionConsumer> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public MeetingRoomConsumer addRecognitionListItem(TravelInventoryRecognitionConsumer recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionConsumer> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognitionConsumer> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public MeetingRoomConsumer applicableStart(LocalDate applicableStart) {
    
    this.applicableStart = applicableStart;
    return this;
  }

   /**
   * Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.
   * @return applicableStart
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableStart() {
    return applicableStart;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableStart(LocalDate applicableStart) {
    this.applicableStart = applicableStart;
  }


  public MeetingRoomConsumer applicableEnd(LocalDate applicableEnd) {
    
    this.applicableEnd = applicableEnd;
    return this;
  }

   /**
   * End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.
   * @return applicableEnd
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableEnd() {
    return applicableEnd;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableEnd(LocalDate applicableEnd) {
    this.applicableEnd = applicableEnd;
  }


  public MeetingRoomConsumer reservationRequiredInd(Boolean reservationRequiredInd) {
    
    this.reservationRequiredInd = reservationRequiredInd;
    return this;
  }

   /**
   * Indicates whether a reservation is required to participate in this inventory.
   * @return reservationRequiredInd
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReservationRequiredInd() {
    return reservationRequiredInd;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationRequiredInd(Boolean reservationRequiredInd) {
    this.reservationRequiredInd = reservationRequiredInd;
  }


  public MeetingRoomConsumer opens(String opens) {
    
    this.opens = opens;
    return this;
  }

   /**
   * Opening time of inventory (if applicable). Leave empty if inventory is always available.
   * @return opens
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpens() {
    return opens;
  }


  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpens(String opens) {
    this.opens = opens;
  }


  public MeetingRoomConsumer closes(String closes) {
    
    this.closes = closes;
    return this;
  }

   /**
   * Closing time of inventory (if applicable). Leave empty if inventory is always available.
   * @return closes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCloses() {
    return closes;
  }


  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloses(String closes) {
    this.closes = closes;
  }


  public MeetingRoomConsumer daysOfWeek(DowPatternGroupConsumer daysOfWeek) {
    
    this.daysOfWeek = daysOfWeek;
    return this;
  }

   /**
   * Get daysOfWeek
   * @return daysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupConsumer getDaysOfWeek() {
    return daysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysOfWeek(DowPatternGroupConsumer daysOfWeek) {
    this.daysOfWeek = daysOfWeek;
  }


  public MeetingRoomConsumer irregular(Boolean irregular) {
    
    this.irregular = irregular;
    return this;
  }

   /**
   * Room has an irregular shape. If true, the room would be of a traditional square or rectangular shape.
   * @return irregular
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IRREGULAR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIrregular() {
    return irregular;
  }


  @JsonProperty(JSON_PROPERTY_IRREGULAR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIrregular(Boolean irregular) {
    this.irregular = irregular;
  }


  public MeetingRoomConsumer meetingRoomCapacity(Integer meetingRoomCapacity) {
    
    this.meetingRoomCapacity = meetingRoomCapacity;
    return this;
  }

   /**
   * The total number of people permitted in the meeting room.
   * minimum: 0
   * @return meetingRoomCapacity
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMeetingRoomCapacity() {
    return meetingRoomCapacity;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMeetingRoomCapacity(Integer meetingRoomCapacity) {
    this.meetingRoomCapacity = meetingRoomCapacity;
  }


  public MeetingRoomConsumer access(String access) {
    
    this.access = access;
    return this;
  }

   /**
   * The type of access to the meeting space.
   * @return access
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccess() {
    return access;
  }


  @JsonProperty(JSON_PROPERTY_ACCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccess(String access) {
    this.access = access;
  }


  public MeetingRoomConsumer meetingRoomTypeCode(String meetingRoomTypeCode) {
    
    this.meetingRoomTypeCode = meetingRoomTypeCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;MRF&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return meetingRoomTypeCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMeetingRoomTypeCode() {
    return meetingRoomTypeCode;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMeetingRoomTypeCode(String meetingRoomTypeCode) {
    this.meetingRoomTypeCode = meetingRoomTypeCode;
  }


  public MeetingRoomConsumer meetingRoomLevel(String meetingRoomLevel) {
    
    this.meetingRoomLevel = meetingRoomLevel;
    return this;
  }

   /**
   * Defines the level in the facility where the meeting room is located.
   * @return meetingRoomLevel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMeetingRoomLevel() {
    return meetingRoomLevel;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRoomLevel(String meetingRoomLevel) {
    this.meetingRoomLevel = meetingRoomLevel;
  }


  public MeetingRoomConsumer dedicatedInd(Boolean dedicatedInd) {
    
    this.dedicatedInd = dedicatedInd;
    return this;
  }

   /**
   * When true, the room is used for a single purpose as indicated by the MeetingRoomTypeCode attribute.
   * @return dedicatedInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DEDICATED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDedicatedInd() {
    return dedicatedInd;
  }


  @JsonProperty(JSON_PROPERTY_DEDICATED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDedicatedInd(Boolean dedicatedInd) {
    this.dedicatedInd = dedicatedInd;
  }


  public MeetingRoomConsumer area(Float area) {
    
    this.area = area;
    return this;
  }

   /**
   * Area (in square meters) of this meeting room.
   * minimum: 1.0
   * @return area
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")
  @JsonProperty(JSON_PROPERTY_AREA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getArea() {
    return area;
  }


  @JsonProperty(JSON_PROPERTY_AREA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setArea(Float area) {
    this.area = area;
  }


  public MeetingRoomConsumer height(Float height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height (in meters) of this meeting room.
   * minimum: 1.0
   * @return height
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHeight(Float height) {
    this.height = height;
  }


  public MeetingRoomConsumer width(Float width) {
    
    this.width = width;
    return this;
  }

   /**
   * Width (in meters) of this meeting room.
   * minimum: 1.0
   * @return width
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWidth(Float width) {
    this.width = width;
  }


  public MeetingRoomConsumer length(Float length) {
    
    this.length = length;
    return this;
  }

   /**
   * Length (in meters) of this meeting room.
   * minimum: 1.0
   * @return length
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")
  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getLength() {
    return length;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLength(Float length) {
    this.length = length;
  }


  public MeetingRoomConsumer amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public MeetingRoomConsumer addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;MRC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return amenities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MeetingRoomConsumer meetingRoomConsumer = (MeetingRoomConsumer) o;
    return Objects.equals(this.identifier, meetingRoomConsumer.identifier) &&
        Objects.equals(this.hotelIdentifier, meetingRoomConsumer.hotelIdentifier) &&
        Objects.equals(this.featuredInd, meetingRoomConsumer.featuredInd) &&
        Objects.equals(this.lifestyleType, meetingRoomConsumer.lifestyleType) &&
        Objects.equals(this.location, meetingRoomConsumer.location) &&
        Objects.equals(this.descriptions, meetingRoomConsumer.descriptions) &&
        Objects.equals(this.multimedias, meetingRoomConsumer.multimedias) &&
        Objects.equals(this.contact, meetingRoomConsumer.contact) &&
        Objects.equals(this.address, meetingRoomConsumer.address) &&
        Objects.equals(this.commissionable, meetingRoomConsumer.commissionable) &&
        Objects.equals(this.name, meetingRoomConsumer.name) &&
        Objects.equals(this.proximityCode, meetingRoomConsumer.proximityCode) &&
        Objects.equals(this.sort, meetingRoomConsumer.sort) &&
        Objects.equals(this.minAgeAppropriateCode, meetingRoomConsumer.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, meetingRoomConsumer.bookable) &&
        Objects.equals(this.active, meetingRoomConsumer.active) &&
        Objects.equals(this.disabilityFeatures, meetingRoomConsumer.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, meetingRoomConsumer.securityFeatures) &&
        Objects.equals(this.socials, meetingRoomConsumer.socials) &&
        Objects.equals(this.pricePoint, meetingRoomConsumer.pricePoint) &&
        Objects.equals(this.recognitionList, meetingRoomConsumer.recognitionList) &&
        Objects.equals(this.applicableStart, meetingRoomConsumer.applicableStart) &&
        Objects.equals(this.applicableEnd, meetingRoomConsumer.applicableEnd) &&
        Objects.equals(this.reservationRequiredInd, meetingRoomConsumer.reservationRequiredInd) &&
        Objects.equals(this.opens, meetingRoomConsumer.opens) &&
        Objects.equals(this.closes, meetingRoomConsumer.closes) &&
        Objects.equals(this.daysOfWeek, meetingRoomConsumer.daysOfWeek) &&
        Objects.equals(this.irregular, meetingRoomConsumer.irregular) &&
        Objects.equals(this.meetingRoomCapacity, meetingRoomConsumer.meetingRoomCapacity) &&
        Objects.equals(this.access, meetingRoomConsumer.access) &&
        Objects.equals(this.meetingRoomTypeCode, meetingRoomConsumer.meetingRoomTypeCode) &&
        Objects.equals(this.meetingRoomLevel, meetingRoomConsumer.meetingRoomLevel) &&
        Objects.equals(this.dedicatedInd, meetingRoomConsumer.dedicatedInd) &&
        Objects.equals(this.area, meetingRoomConsumer.area) &&
        Objects.equals(this.height, meetingRoomConsumer.height) &&
        Objects.equals(this.width, meetingRoomConsumer.width) &&
        Objects.equals(this.length, meetingRoomConsumer.length) &&
        Objects.equals(this.amenities, meetingRoomConsumer.amenities);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, applicableStart, applicableEnd, reservationRequiredInd, opens, closes, daysOfWeek, irregular, meetingRoomCapacity, access, meetingRoomTypeCode, meetingRoomLevel, dedicatedInd, area, height, width, length, amenities);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MeetingRoomConsumer {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    applicableStart: ").append(toIndentedString(applicableStart)).append("\n");
    sb.append("    applicableEnd: ").append(toIndentedString(applicableEnd)).append("\n");
    sb.append("    reservationRequiredInd: ").append(toIndentedString(reservationRequiredInd)).append("\n");
    sb.append("    opens: ").append(toIndentedString(opens)).append("\n");
    sb.append("    closes: ").append(toIndentedString(closes)).append("\n");
    sb.append("    daysOfWeek: ").append(toIndentedString(daysOfWeek)).append("\n");
    sb.append("    irregular: ").append(toIndentedString(irregular)).append("\n");
    sb.append("    meetingRoomCapacity: ").append(toIndentedString(meetingRoomCapacity)).append("\n");
    sb.append("    access: ").append(toIndentedString(access)).append("\n");
    sb.append("    meetingRoomTypeCode: ").append(toIndentedString(meetingRoomTypeCode)).append("\n");
    sb.append("    meetingRoomLevel: ").append(toIndentedString(meetingRoomLevel)).append("\n");
    sb.append("    dedicatedInd: ").append(toIndentedString(dedicatedInd)).append("\n");
    sb.append("    area: ").append(toIndentedString(area)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    length: ").append(toIndentedString(length)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

