/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.11.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.inventory.model.AggregateGreendexScoreByCategoryConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Detailed Green Index scores on hoe the property scores by category
 */
@JsonPropertyOrder({
  AggregateGreendexAnswersConsumer.JSON_PROPERTY_HIGH_SCORE,
  AggregateGreendexAnswersConsumer.JSON_PROPERTY_TOTAL_SCORE,
  AggregateGreendexAnswersConsumer.JSON_PROPERTY_AGGREGATE_SCORE,
  AggregateGreendexAnswersConsumer.JSON_PROPERTY_SCORES_BY_CATEGORY
})
@JsonTypeName("AggregateGreendexAnswers_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-06T10:50:31.079810181+07:00[Asia/Bangkok]")
public class AggregateGreendexAnswersConsumer {
  public static final String JSON_PROPERTY_HIGH_SCORE = "highScore";
  private Integer highScore;

  public static final String JSON_PROPERTY_TOTAL_SCORE = "totalScore";
  private Integer totalScore;

  public static final String JSON_PROPERTY_AGGREGATE_SCORE = "aggregateScore";
  private Float aggregateScore;

  public static final String JSON_PROPERTY_SCORES_BY_CATEGORY = "scoresByCategory";
  private List<AggregateGreendexScoreByCategoryConsumer> scoresByCategory;

  public AggregateGreendexAnswersConsumer() {
  }

  public AggregateGreendexAnswersConsumer highScore(Integer highScore) {
    
    this.highScore = highScore;
    return this;
  }

   /**
   * The highest possible score from all questions
   * @return highScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HIGH_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHighScore() {
    return highScore;
  }


  @JsonProperty(JSON_PROPERTY_HIGH_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHighScore(Integer highScore) {
    this.highScore = highScore;
  }


  public AggregateGreendexAnswersConsumer totalScore(Integer totalScore) {
    
    this.totalScore = totalScore;
    return this;
  }

   /**
   * The total score from all questions answered
   * @return totalScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalScore() {
    return totalScore;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalScore(Integer totalScore) {
    this.totalScore = totalScore;
  }


  public AggregateGreendexAnswersConsumer aggregateScore(Float aggregateScore) {
    
    this.aggregateScore = aggregateScore;
    return this;
  }

   /**
   * Total score divided by high score
   * minimum: 0
   * maximum: 1
   * @return aggregateScore
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0") @DecimalMax("1")
  @JsonProperty(JSON_PROPERTY_AGGREGATE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateScore() {
    return aggregateScore;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateScore(Float aggregateScore) {
    this.aggregateScore = aggregateScore;
  }


  public AggregateGreendexAnswersConsumer scoresByCategory(List<AggregateGreendexScoreByCategoryConsumer> scoresByCategory) {
    
    this.scoresByCategory = scoresByCategory;
    return this;
  }

  public AggregateGreendexAnswersConsumer addScoresByCategoryItem(AggregateGreendexScoreByCategoryConsumer scoresByCategoryItem) {
    if (this.scoresByCategory == null) {
      this.scoresByCategory = new ArrayList<>();
    }
    this.scoresByCategory.add(scoresByCategoryItem);
    return this;
  }

   /**
   * Aggregate scores by Green Index category
   * @return scoresByCategory
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SCORES_BY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AggregateGreendexScoreByCategoryConsumer> getScoresByCategory() {
    return scoresByCategory;
  }


  @JsonProperty(JSON_PROPERTY_SCORES_BY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScoresByCategory(List<AggregateGreendexScoreByCategoryConsumer> scoresByCategory) {
    this.scoresByCategory = scoresByCategory;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AggregateGreendexAnswersConsumer aggregateGreendexAnswersConsumer = (AggregateGreendexAnswersConsumer) o;
    return Objects.equals(this.highScore, aggregateGreendexAnswersConsumer.highScore) &&
        Objects.equals(this.totalScore, aggregateGreendexAnswersConsumer.totalScore) &&
        Objects.equals(this.aggregateScore, aggregateGreendexAnswersConsumer.aggregateScore) &&
        Objects.equals(this.scoresByCategory, aggregateGreendexAnswersConsumer.scoresByCategory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(highScore, totalScore, aggregateScore, scoresByCategory);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AggregateGreendexAnswersConsumer {\n");
    sb.append("    highScore: ").append(toIndentedString(highScore)).append("\n");
    sb.append("    totalScore: ").append(toIndentedString(totalScore)).append("\n");
    sb.append("    aggregateScore: ").append(toIndentedString(aggregateScore)).append("\n");
    sb.append("    scoresByCategory: ").append(toIndentedString(scoresByCategory)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

