/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.11.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.inventory.model.ActivityLocalizedInventoryWithHotelBestPriceConsumer;
import travel.wink.sdk.inventory.model.AddOnLocalizedInventoryWithHotelBestPriceConsumer;
import travel.wink.sdk.inventory.model.AttractionLocalizedInventoryWithHotelBestPriceConsumer;
import travel.wink.sdk.inventory.model.HotelWithBestPriceConsumer;
import travel.wink.sdk.inventory.model.MeetingRoomLocalizedInventoryWithHotelBestPriceConsumer;
import travel.wink.sdk.inventory.model.PlaceLocalizedInventoryWithHotelBestPriceConsumer;
import travel.wink.sdk.inventory.model.RestaurantLocalizedInventoryWithHotelBestPriceConsumer;
import travel.wink.sdk.inventory.model.SpaLocalizedInventoryWithHotelBestPriceConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * InventoryGridItemConsumer
 */
@JsonPropertyOrder({
  InventoryGridItemConsumer.JSON_PROPERTY_SORT,
  InventoryGridItemConsumer.JSON_PROPERTY_TYPE,
  InventoryGridItemConsumer.JSON_PROPERTY_IDENTIFIER,
  InventoryGridItemConsumer.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  InventoryGridItemConsumer.JSON_PROPERTY_ACTIVITY,
  InventoryGridItemConsumer.JSON_PROPERTY_ATTRACTION,
  InventoryGridItemConsumer.JSON_PROPERTY_PLACE,
  InventoryGridItemConsumer.JSON_PROPERTY_ROOM_TYPE,
  InventoryGridItemConsumer.JSON_PROPERTY_MEETING_ROOM,
  InventoryGridItemConsumer.JSON_PROPERTY_RESTAURANT,
  InventoryGridItemConsumer.JSON_PROPERTY_SPA,
  InventoryGridItemConsumer.JSON_PROPERTY_ADD_ON,
  InventoryGridItemConsumer.JSON_PROPERTY_AVAILABLE
})
@JsonTypeName("InventoryGridItem_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-06T10:50:31.079810181+07:00[Asia/Bangkok]")
public class InventoryGridItemConsumer {
  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  /**
   * The type of inventory this item represents.
   */
  public enum TypeEnum {
    HOTEL("HOTEL"),
    
    GUEST_ROOM("GUEST_ROOM"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ADD_ON("ADD_ON"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_ACTIVITY = "activity";
  private ActivityLocalizedInventoryWithHotelBestPriceConsumer activity;

  public static final String JSON_PROPERTY_ATTRACTION = "attraction";
  private AttractionLocalizedInventoryWithHotelBestPriceConsumer attraction;

  public static final String JSON_PROPERTY_PLACE = "place";
  private PlaceLocalizedInventoryWithHotelBestPriceConsumer place;

  public static final String JSON_PROPERTY_ROOM_TYPE = "roomType";
  private HotelWithBestPriceConsumer roomType;

  public static final String JSON_PROPERTY_MEETING_ROOM = "meetingRoom";
  private MeetingRoomLocalizedInventoryWithHotelBestPriceConsumer meetingRoom;

  public static final String JSON_PROPERTY_RESTAURANT = "restaurant";
  private RestaurantLocalizedInventoryWithHotelBestPriceConsumer restaurant;

  public static final String JSON_PROPERTY_SPA = "spa";
  private SpaLocalizedInventoryWithHotelBestPriceConsumer spa;

  public static final String JSON_PROPERTY_ADD_ON = "addOn";
  private AddOnLocalizedInventoryWithHotelBestPriceConsumer addOn;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public InventoryGridItemConsumer() {
  }

  public InventoryGridItemConsumer sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort property indicates how this grid item fits in with the rest of the items in the list.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public InventoryGridItemConsumer type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of inventory this item represents.
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public InventoryGridItemConsumer identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique inventory identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public InventoryGridItemConsumer supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier referencing inventory owner
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public InventoryGridItemConsumer activity(ActivityLocalizedInventoryWithHotelBestPriceConsumer activity) {
    
    this.activity = activity;
    return this;
  }

   /**
   * Get activity
   * @return activity
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ActivityLocalizedInventoryWithHotelBestPriceConsumer getActivity() {
    return activity;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivity(ActivityLocalizedInventoryWithHotelBestPriceConsumer activity) {
    this.activity = activity;
  }


  public InventoryGridItemConsumer attraction(AttractionLocalizedInventoryWithHotelBestPriceConsumer attraction) {
    
    this.attraction = attraction;
    return this;
  }

   /**
   * Get attraction
   * @return attraction
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ATTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AttractionLocalizedInventoryWithHotelBestPriceConsumer getAttraction() {
    return attraction;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttraction(AttractionLocalizedInventoryWithHotelBestPriceConsumer attraction) {
    this.attraction = attraction;
  }


  public InventoryGridItemConsumer place(PlaceLocalizedInventoryWithHotelBestPriceConsumer place) {
    
    this.place = place;
    return this;
  }

   /**
   * Get place
   * @return place
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PlaceLocalizedInventoryWithHotelBestPriceConsumer getPlace() {
    return place;
  }


  @JsonProperty(JSON_PROPERTY_PLACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlace(PlaceLocalizedInventoryWithHotelBestPriceConsumer place) {
    this.place = place;
  }


  public InventoryGridItemConsumer roomType(HotelWithBestPriceConsumer roomType) {
    
    this.roomType = roomType;
    return this;
  }

   /**
   * Get roomType
   * @return roomType
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelWithBestPriceConsumer getRoomType() {
    return roomType;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomType(HotelWithBestPriceConsumer roomType) {
    this.roomType = roomType;
  }


  public InventoryGridItemConsumer meetingRoom(MeetingRoomLocalizedInventoryWithHotelBestPriceConsumer meetingRoom) {
    
    this.meetingRoom = meetingRoom;
    return this;
  }

   /**
   * Get meetingRoom
   * @return meetingRoom
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEETING_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MeetingRoomLocalizedInventoryWithHotelBestPriceConsumer getMeetingRoom() {
    return meetingRoom;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRoom(MeetingRoomLocalizedInventoryWithHotelBestPriceConsumer meetingRoom) {
    this.meetingRoom = meetingRoom;
  }


  public InventoryGridItemConsumer restaurant(RestaurantLocalizedInventoryWithHotelBestPriceConsumer restaurant) {
    
    this.restaurant = restaurant;
    return this;
  }

   /**
   * Get restaurant
   * @return restaurant
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESTAURANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RestaurantLocalizedInventoryWithHotelBestPriceConsumer getRestaurant() {
    return restaurant;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurant(RestaurantLocalizedInventoryWithHotelBestPriceConsumer restaurant) {
    this.restaurant = restaurant;
  }


  public InventoryGridItemConsumer spa(SpaLocalizedInventoryWithHotelBestPriceConsumer spa) {
    
    this.spa = spa;
    return this;
  }

   /**
   * Get spa
   * @return spa
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SPA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SpaLocalizedInventoryWithHotelBestPriceConsumer getSpa() {
    return spa;
  }


  @JsonProperty(JSON_PROPERTY_SPA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpa(SpaLocalizedInventoryWithHotelBestPriceConsumer spa) {
    this.spa = spa;
  }


  public InventoryGridItemConsumer addOn(AddOnLocalizedInventoryWithHotelBestPriceConsumer addOn) {
    
    this.addOn = addOn;
    return this;
  }

   /**
   * Get addOn
   * @return addOn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADD_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddOnLocalizedInventoryWithHotelBestPriceConsumer getAddOn() {
    return addOn;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOn(AddOnLocalizedInventoryWithHotelBestPriceConsumer addOn) {
    this.addOn = addOn;
  }


  public InventoryGridItemConsumer available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Whether this inventory is available
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InventoryGridItemConsumer inventoryGridItemConsumer = (InventoryGridItemConsumer) o;
    return Objects.equals(this.sort, inventoryGridItemConsumer.sort) &&
        Objects.equals(this.type, inventoryGridItemConsumer.type) &&
        Objects.equals(this.identifier, inventoryGridItemConsumer.identifier) &&
        Objects.equals(this.supplierIdentifier, inventoryGridItemConsumer.supplierIdentifier) &&
        Objects.equals(this.activity, inventoryGridItemConsumer.activity) &&
        Objects.equals(this.attraction, inventoryGridItemConsumer.attraction) &&
        Objects.equals(this.place, inventoryGridItemConsumer.place) &&
        Objects.equals(this.roomType, inventoryGridItemConsumer.roomType) &&
        Objects.equals(this.meetingRoom, inventoryGridItemConsumer.meetingRoom) &&
        Objects.equals(this.restaurant, inventoryGridItemConsumer.restaurant) &&
        Objects.equals(this.spa, inventoryGridItemConsumer.spa) &&
        Objects.equals(this.addOn, inventoryGridItemConsumer.addOn) &&
        Objects.equals(this.available, inventoryGridItemConsumer.available);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sort, type, identifier, supplierIdentifier, activity, attraction, place, roomType, meetingRoom, restaurant, spa, addOn, available);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InventoryGridItemConsumer {\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    activity: ").append(toIndentedString(activity)).append("\n");
    sb.append("    attraction: ").append(toIndentedString(attraction)).append("\n");
    sb.append("    place: ").append(toIndentedString(place)).append("\n");
    sb.append("    roomType: ").append(toIndentedString(roomType)).append("\n");
    sb.append("    meetingRoom: ").append(toIndentedString(meetingRoom)).append("\n");
    sb.append("    restaurant: ").append(toIndentedString(restaurant)).append("\n");
    sb.append("    spa: ").append(toIndentedString(spa)).append("\n");
    sb.append("    addOn: ").append(toIndentedString(addOn)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

