/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.GeoJsonPointConsumer;
import travel.wink.sdk.inventory.model.GeoJsonPolygonConsumer;
import travel.wink.sdk.inventory.model.IPLocationConsumer;
import travel.wink.sdk.inventory.model.ItineraryConsumer;
import travel.wink.sdk.inventory.model.RoomConfigurationConsumer;
import travel.wink.sdk.inventory.model.SearchFiltersConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * User session information containing itinerary and other user related data.
 */
@JsonPropertyOrder({
  UserSessionConsumer.JSON_PROPERTY_LOCATION,
  UserSessionConsumer.JSON_PROPERTY_IP_LOCATION,
  UserSessionConsumer.JSON_PROPERTY_IP_NUMBER,
  UserSessionConsumer.JSON_PROPERTY_BOUNDS,
  UserSessionConsumer.JSON_PROPERTY_ITINERARY,
  UserSessionConsumer.JSON_PROPERTY_SEARCH_FILTERS,
  UserSessionConsumer.JSON_PROPERTY_LANGUAGE,
  UserSessionConsumer.JSON_PROPERTY_CURRENCY,
  UserSessionConsumer.JSON_PROPERTY_REDIRECT_URL,
  UserSessionConsumer.JSON_PROPERTY_USER_IDENTIFIER,
  UserSessionConsumer.JSON_PROPERTY_PROMOTIONAL_CODES,
  UserSessionConsumer.JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION
})
@JsonTypeName("UserSession_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:19:06.454618511+07:00[Asia/Bangkok]")
public class UserSessionConsumer {
  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointConsumer location;

  public static final String JSON_PROPERTY_IP_LOCATION = "ipLocation";
  private IPLocationConsumer ipLocation;

  public static final String JSON_PROPERTY_IP_NUMBER = "ipNumber";
  private String ipNumber;

  public static final String JSON_PROPERTY_BOUNDS = "bounds";
  private GeoJsonPolygonConsumer bounds;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private ItineraryConsumer itinerary;

  public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
  private SearchFiltersConsumer searchFilters;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
  private String redirectUrl;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes;

  public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION = "selectedRoomConfiguration";
  private RoomConfigurationConsumer selectedRoomConfiguration;

  public UserSessionConsumer() {
  }

  public UserSessionConsumer location(GeoJsonPointConsumer location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointConsumer getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointConsumer location) {
    this.location = location;
  }


  public UserSessionConsumer ipLocation(IPLocationConsumer ipLocation) {
    
    this.ipLocation = ipLocation;
    return this;
  }

   /**
   * Get ipLocation
   * @return ipLocation
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IP_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IPLocationConsumer getIpLocation() {
    return ipLocation;
  }


  @JsonProperty(JSON_PROPERTY_IP_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpLocation(IPLocationConsumer ipLocation) {
    this.ipLocation = ipLocation;
  }


  public UserSessionConsumer ipNumber(String ipNumber) {
    
    this.ipNumber = ipNumber;
    return this;
  }

   /**
   * User&#39;s incoming IP number
   * @return ipNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIpNumber() {
    return ipNumber;
  }


  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpNumber(String ipNumber) {
    this.ipNumber = ipNumber;
  }


  public UserSessionConsumer bounds(GeoJsonPolygonConsumer bounds) {
    
    this.bounds = bounds;
    return this;
  }

   /**
   * Get bounds
   * @return bounds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPolygonConsumer getBounds() {
    return bounds;
  }


  @JsonProperty(JSON_PROPERTY_BOUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBounds(GeoJsonPolygonConsumer bounds) {
    this.bounds = bounds;
  }


  public UserSessionConsumer itinerary(ItineraryConsumer itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ItineraryConsumer getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(ItineraryConsumer itinerary) {
    this.itinerary = itinerary;
  }


  public UserSessionConsumer searchFilters(SearchFiltersConsumer searchFilters) {
    
    this.searchFilters = searchFilters;
    return this;
  }

   /**
   * Get searchFilters
   * @return searchFilters
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SEARCH_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SearchFiltersConsumer getSearchFilters() {
    return searchFilters;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchFilters(SearchFiltersConsumer searchFilters) {
    this.searchFilters = searchFilters;
  }


  public UserSessionConsumer language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * User&#39;s language preference
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public UserSessionConsumer currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * User&#39;s currency preference
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public UserSessionConsumer redirectUrl(String redirectUrl) {
    
    this.redirectUrl = redirectUrl;
    return this;
  }

   /**
   * Get redirectUrl
   * @return redirectUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRedirectUrl() {
    return redirectUrl;
  }


  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectUrl(String redirectUrl) {
    this.redirectUrl = redirectUrl;
  }


  public UserSessionConsumer userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * Pass along the user identifier if user is known.
   * @return userIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public UserSessionConsumer promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public UserSessionConsumer addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Get promotionalCodes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public UserSessionConsumer selectedRoomConfiguration(RoomConfigurationConsumer selectedRoomConfiguration) {
    
    this.selectedRoomConfiguration = selectedRoomConfiguration;
    return this;
  }

   /**
   * Get selectedRoomConfiguration
   * @return selectedRoomConfiguration
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomConfigurationConsumer getSelectedRoomConfiguration() {
    return selectedRoomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectedRoomConfiguration(RoomConfigurationConsumer selectedRoomConfiguration) {
    this.selectedRoomConfiguration = selectedRoomConfiguration;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserSessionConsumer userSessionConsumer = (UserSessionConsumer) o;
    return Objects.equals(this.location, userSessionConsumer.location) &&
        Objects.equals(this.ipLocation, userSessionConsumer.ipLocation) &&
        Objects.equals(this.ipNumber, userSessionConsumer.ipNumber) &&
        Objects.equals(this.bounds, userSessionConsumer.bounds) &&
        Objects.equals(this.itinerary, userSessionConsumer.itinerary) &&
        Objects.equals(this.searchFilters, userSessionConsumer.searchFilters) &&
        Objects.equals(this.language, userSessionConsumer.language) &&
        Objects.equals(this.currency, userSessionConsumer.currency) &&
        Objects.equals(this.redirectUrl, userSessionConsumer.redirectUrl) &&
        Objects.equals(this.userIdentifier, userSessionConsumer.userIdentifier) &&
        Objects.equals(this.promotionalCodes, userSessionConsumer.promotionalCodes) &&
        Objects.equals(this.selectedRoomConfiguration, userSessionConsumer.selectedRoomConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(location, ipLocation, ipNumber, bounds, itinerary, searchFilters, language, currency, redirectUrl, userIdentifier, promotionalCodes, selectedRoomConfiguration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserSessionConsumer {\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    ipLocation: ").append(toIndentedString(ipLocation)).append("\n");
    sb.append("    ipNumber: ").append(toIndentedString(ipNumber)).append("\n");
    sb.append("    bounds: ").append(toIndentedString(bounds)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    searchFilters: ").append(toIndentedString(searchFilters)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    redirectUrl: ").append(toIndentedString(redirectUrl)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    selectedRoomConfiguration: ").append(toIndentedString(selectedRoomConfiguration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

