/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.30.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.LocalizedTransactionalTravelInventoryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RestaurantNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of property restaurants on and off the premises.
 */
@JsonPropertyOrder({
  RestaurantLocalizedInventoryNonAuthenticatedEntity.JSON_PROPERTY_RESTAURANT,
  RestaurantLocalizedInventoryNonAuthenticatedEntity.JSON_PROPERTY_LIST,
  RestaurantLocalizedInventoryNonAuthenticatedEntity.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  RestaurantLocalizedInventoryNonAuthenticatedEntity.JSON_PROPERTY_COMMISSIONABLE,
  RestaurantLocalizedInventoryNonAuthenticatedEntity.JSON_PROPERTY_COMMISSION,
  RestaurantLocalizedInventoryNonAuthenticatedEntity.JSON_PROPERTY_PRICE_LIST
})
@JsonTypeName("RestaurantLocalizedInventory_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-12-27T18:02:18.418151128+07:00[Asia/Bangkok]")
public class RestaurantLocalizedInventoryNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_RESTAURANT = "restaurant";
  private RestaurantNonAuthenticatedEntity restaurant;

  public static final String JSON_PROPERTY_LIST = "list";
  private List<LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> _list;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private UUID channelInventoryIdentifier;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
  private List<LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> priceList;

  public RestaurantLocalizedInventoryNonAuthenticatedEntity() {
  }

  public RestaurantLocalizedInventoryNonAuthenticatedEntity restaurant(RestaurantNonAuthenticatedEntity restaurant) {
    
    this.restaurant = restaurant;
    return this;
  }

   /**
   * Get restaurant
   * @return restaurant
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESTAURANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RestaurantNonAuthenticatedEntity getRestaurant() {
    return restaurant;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurant(RestaurantNonAuthenticatedEntity restaurant) {
    this.restaurant = restaurant;
  }


  public RestaurantLocalizedInventoryNonAuthenticatedEntity _list(List<LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> _list) {
    
    this._list = _list;
    return this;
  }

  public RestaurantLocalizedInventoryNonAuthenticatedEntity addListItem(LocalizedTransactionalTravelInventoryNonAuthenticatedEntity _listItem) {
    if (this._list == null) {
      this._list = new ArrayList<>();
    }
    this._list.add(_listItem);
    return this;
  }

   /**
   * Get _list
   * @return _list
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> getList() {
    return _list;
  }


  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setList(List<LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> _list) {
    this._list = _list;
  }


  public RestaurantLocalizedInventoryNonAuthenticatedEntity channelInventoryIdentifier(UUID channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Channel inventory identifier referencing this record.
   * @return channelInventoryIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public RestaurantLocalizedInventoryNonAuthenticatedEntity commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Whether this package is commissionable based on the incoming sales channel.
   * @return commissionable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public RestaurantLocalizedInventoryNonAuthenticatedEntity commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * The commission percentage.
   * @return commission
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  public RestaurantLocalizedInventoryNonAuthenticatedEntity priceList(List<LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> priceList) {
    
    this.priceList = priceList;
    return this;
  }

  public RestaurantLocalizedInventoryNonAuthenticatedEntity addPriceListItem(LocalizedTransactionalTravelInventoryNonAuthenticatedEntity priceListItem) {
    if (this.priceList == null) {
      this.priceList = new ArrayList<>();
    }
    this.priceList.add(priceListItem);
    return this;
  }

   /**
   * Get priceList
   * @return priceList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> getPriceList() {
    return priceList;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceList(List<LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> priceList) {
    this.priceList = priceList;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RestaurantLocalizedInventoryNonAuthenticatedEntity restaurantLocalizedInventoryNonAuthenticatedEntity = (RestaurantLocalizedInventoryNonAuthenticatedEntity) o;
    return Objects.equals(this.restaurant, restaurantLocalizedInventoryNonAuthenticatedEntity.restaurant) &&
        Objects.equals(this._list, restaurantLocalizedInventoryNonAuthenticatedEntity._list) &&
        Objects.equals(this.channelInventoryIdentifier, restaurantLocalizedInventoryNonAuthenticatedEntity.channelInventoryIdentifier) &&
        Objects.equals(this.commissionable, restaurantLocalizedInventoryNonAuthenticatedEntity.commissionable) &&
        Objects.equals(this.commission, restaurantLocalizedInventoryNonAuthenticatedEntity.commission) &&
        Objects.equals(this.priceList, restaurantLocalizedInventoryNonAuthenticatedEntity.priceList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(restaurant, _list, channelInventoryIdentifier, commissionable, commission, priceList);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RestaurantLocalizedInventoryNonAuthenticatedEntity {\n");
    sb.append("    restaurant: ").append(toIndentedString(restaurant)).append("\n");
    sb.append("    _list: ").append(toIndentedString(_list)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    priceList: ").append(toIndentedString(priceList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

