/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.58.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.AbstractSimpleMultimediaNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.ActivityLocalizedInventoryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateGreendexAnswersNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AnnouncementNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AttractionLocalizedInventoryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelOnMapNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.MeetingRoomLocalizedInventoryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.MetaDataNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.PlaceLocalizedInventoryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RecognitionNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RestaurantLocalizedInventoryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RoomTypeWithPriceConfigurationNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RoomTypeWithPriceConfigurationsNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SalesChannelInfoNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SpaLocalizedInventoryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.UserReviewNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * HotelInventoryResponseNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_URL_NAME,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_HOTEL,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_GREEN_INDEX_SCORES,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_ROOM_TYPES,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_MEETING_ROOMS,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_RESTAURANTS,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_SPAS,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_ACTIVITIES,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_ATTRACTIONS,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_PLACES,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_METADATA,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_IMAGES,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_VIDEOS,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_RECOGNITIONS,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_ANNOUNCEMENTS,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_REVIEWS,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_SALES_CHANNEL,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_CHEAPEST_ROOM_TYPES,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_AVAILABLE,
  HotelInventoryResponseNonAuthenticatedEntity.JSON_PROPERTY_BEST_PRICE
})
@JsonTypeName("HotelInventoryResponse_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-28T20:19:06.406920+07:00[Asia/Bangkok]")
public class HotelInventoryResponseNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapNonAuthenticatedEntity hotel;

  public static final String JSON_PROPERTY_GREEN_INDEX_SCORES = "greenIndexScores";
  private AggregateGreendexAnswersNonAuthenticatedEntity greenIndexScores;

  public static final String JSON_PROPERTY_ROOM_TYPES = "roomTypes";
  private List<RoomTypeWithPriceConfigurationsNonAuthenticatedEntity> roomTypes;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private List<MeetingRoomLocalizedInventoryNonAuthenticatedEntity> meetingRooms;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private List<RestaurantLocalizedInventoryNonAuthenticatedEntity> restaurants;

  public static final String JSON_PROPERTY_SPAS = "spas";
  private List<SpaLocalizedInventoryNonAuthenticatedEntity> spas;

  public static final String JSON_PROPERTY_ACTIVITIES = "activities";
  private List<ActivityLocalizedInventoryNonAuthenticatedEntity> activities;

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private List<AttractionLocalizedInventoryNonAuthenticatedEntity> attractions;

  public static final String JSON_PROPERTY_PLACES = "places";
  private List<PlaceLocalizedInventoryNonAuthenticatedEntity> places;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private List<MetaDataNonAuthenticatedEntity> metadata;

  public static final String JSON_PROPERTY_IMAGES = "images";
  private List<AbstractSimpleMultimediaNonAuthenticatedEntity> images;

  public static final String JSON_PROPERTY_VIDEOS = "videos";
  private List<AbstractSimpleMultimediaNonAuthenticatedEntity> videos;

  public static final String JSON_PROPERTY_RECOGNITIONS = "recognitions";
  private List<RecognitionNonAuthenticatedEntity> recognitions;

  public static final String JSON_PROPERTY_ANNOUNCEMENTS = "announcements";
  private List<AnnouncementNonAuthenticatedEntity> announcements;

  public static final String JSON_PROPERTY_REVIEWS = "reviews";
  private List<UserReviewNonAuthenticatedEntity> reviews;

  public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
  private SalesChannelInfoNonAuthenticatedEntity salesChannel;

  public static final String JSON_PROPERTY_CHEAPEST_ROOM_TYPES = "cheapestRoomTypes";
  private List<RoomTypeWithPriceConfigurationNonAuthenticatedEntity> cheapestRoomTypes;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_BEST_PRICE = "bestPrice";
  private RoomTypeWithPriceConfigurationNonAuthenticatedEntity bestPrice;

  public HotelInventoryResponseNonAuthenticatedEntity() {
  }

  public HotelInventoryResponseNonAuthenticatedEntity hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique property identifier to retrieve inventory for.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelInventoryResponseNonAuthenticatedEntity urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique url-friendly record identifier of property.
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelInventoryResponseNonAuthenticatedEntity hotel(HotelOnMapNonAuthenticatedEntity hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMapNonAuthenticatedEntity getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotel(HotelOnMapNonAuthenticatedEntity hotel) {
    this.hotel = hotel;
  }


  public HotelInventoryResponseNonAuthenticatedEntity greenIndexScores(AggregateGreendexAnswersNonAuthenticatedEntity greenIndexScores) {
    
    this.greenIndexScores = greenIndexScores;
    return this;
  }

   /**
   * Get greenIndexScores
   * @return greenIndexScores
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AggregateGreendexAnswersNonAuthenticatedEntity getGreenIndexScores() {
    return greenIndexScores;
  }


  @JsonProperty(JSON_PROPERTY_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGreenIndexScores(AggregateGreendexAnswersNonAuthenticatedEntity greenIndexScores) {
    this.greenIndexScores = greenIndexScores;
  }


  public HotelInventoryResponseNonAuthenticatedEntity roomTypes(List<RoomTypeWithPriceConfigurationsNonAuthenticatedEntity> roomTypes) {
    
    this.roomTypes = roomTypes;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addRoomTypesItem(RoomTypeWithPriceConfigurationsNonAuthenticatedEntity roomTypesItem) {
    if (this.roomTypes == null) {
      this.roomTypes = new ArrayList<>();
    }
    this.roomTypes.add(roomTypesItem);
    return this;
  }

   /**
   * List of room types with price configurations based on the itinerary that was passed on the user session.
   * @return roomTypes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomTypeWithPriceConfigurationsNonAuthenticatedEntity> getRoomTypes() {
    return roomTypes;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypes(List<RoomTypeWithPriceConfigurationsNonAuthenticatedEntity> roomTypes) {
    this.roomTypes = roomTypes;
  }


  public HotelInventoryResponseNonAuthenticatedEntity meetingRooms(List<MeetingRoomLocalizedInventoryNonAuthenticatedEntity> meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addMeetingRoomsItem(MeetingRoomLocalizedInventoryNonAuthenticatedEntity meetingRoomsItem) {
    if (this.meetingRooms == null) {
      this.meetingRooms = new ArrayList<>();
    }
    this.meetingRooms.add(meetingRoomsItem);
    return this;
  }

   /**
   * List of property meeting rooms on and off the premises.
   * @return meetingRooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MeetingRoomLocalizedInventoryNonAuthenticatedEntity> getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(List<MeetingRoomLocalizedInventoryNonAuthenticatedEntity> meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public HotelInventoryResponseNonAuthenticatedEntity restaurants(List<RestaurantLocalizedInventoryNonAuthenticatedEntity> restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addRestaurantsItem(RestaurantLocalizedInventoryNonAuthenticatedEntity restaurantsItem) {
    if (this.restaurants == null) {
      this.restaurants = new ArrayList<>();
    }
    this.restaurants.add(restaurantsItem);
    return this;
  }

   /**
   * List of property restaurants on and off the premises.
   * @return restaurants
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RestaurantLocalizedInventoryNonAuthenticatedEntity> getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(List<RestaurantLocalizedInventoryNonAuthenticatedEntity> restaurants) {
    this.restaurants = restaurants;
  }


  public HotelInventoryResponseNonAuthenticatedEntity spas(List<SpaLocalizedInventoryNonAuthenticatedEntity> spas) {
    
    this.spas = spas;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addSpasItem(SpaLocalizedInventoryNonAuthenticatedEntity spasItem) {
    if (this.spas == null) {
      this.spas = new ArrayList<>();
    }
    this.spas.add(spasItem);
    return this;
  }

   /**
   * List of property spas on and off the premises.
   * @return spas
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SpaLocalizedInventoryNonAuthenticatedEntity> getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(List<SpaLocalizedInventoryNonAuthenticatedEntity> spas) {
    this.spas = spas;
  }


  public HotelInventoryResponseNonAuthenticatedEntity activities(List<ActivityLocalizedInventoryNonAuthenticatedEntity> activities) {
    
    this.activities = activities;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addActivitiesItem(ActivityLocalizedInventoryNonAuthenticatedEntity activitiesItem) {
    if (this.activities == null) {
      this.activities = new ArrayList<>();
    }
    this.activities.add(activitiesItem);
    return this;
  }

   /**
   * List of property activities on and off the premises.
   * @return activities
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ActivityLocalizedInventoryNonAuthenticatedEntity> getActivities() {
    return activities;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivities(List<ActivityLocalizedInventoryNonAuthenticatedEntity> activities) {
    this.activities = activities;
  }


  public HotelInventoryResponseNonAuthenticatedEntity attractions(List<AttractionLocalizedInventoryNonAuthenticatedEntity> attractions) {
    
    this.attractions = attractions;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addAttractionsItem(AttractionLocalizedInventoryNonAuthenticatedEntity attractionsItem) {
    if (this.attractions == null) {
      this.attractions = new ArrayList<>();
    }
    this.attractions.add(attractionsItem);
    return this;
  }

   /**
   * List of property attractions on and off the premises.
   * @return attractions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AttractionLocalizedInventoryNonAuthenticatedEntity> getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(List<AttractionLocalizedInventoryNonAuthenticatedEntity> attractions) {
    this.attractions = attractions;
  }


  public HotelInventoryResponseNonAuthenticatedEntity places(List<PlaceLocalizedInventoryNonAuthenticatedEntity> places) {
    
    this.places = places;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addPlacesItem(PlaceLocalizedInventoryNonAuthenticatedEntity placesItem) {
    if (this.places == null) {
      this.places = new ArrayList<>();
    }
    this.places.add(placesItem);
    return this;
  }

   /**
   * List of property places on and off the premises.
   * @return places
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PlaceLocalizedInventoryNonAuthenticatedEntity> getPlaces() {
    return places;
  }


  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlaces(List<PlaceLocalizedInventoryNonAuthenticatedEntity> places) {
    this.places = places;
  }


  public HotelInventoryResponseNonAuthenticatedEntity metadata(List<MetaDataNonAuthenticatedEntity> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addMetadataItem(MetaDataNonAuthenticatedEntity metadataItem) {
    if (this.metadata == null) {
      this.metadata = new ArrayList<>();
    }
    this.metadata.add(metadataItem);
    return this;
  }

   /**
   * List of property meta data.
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MetaDataNonAuthenticatedEntity> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(List<MetaDataNonAuthenticatedEntity> metadata) {
    this.metadata = metadata;
  }


  public HotelInventoryResponseNonAuthenticatedEntity images(List<AbstractSimpleMultimediaNonAuthenticatedEntity> images) {
    
    this.images = images;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addImagesItem(AbstractSimpleMultimediaNonAuthenticatedEntity imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

   /**
   * List of property images
   * @return images
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AbstractSimpleMultimediaNonAuthenticatedEntity> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(List<AbstractSimpleMultimediaNonAuthenticatedEntity> images) {
    this.images = images;
  }


  public HotelInventoryResponseNonAuthenticatedEntity videos(List<AbstractSimpleMultimediaNonAuthenticatedEntity> videos) {
    
    this.videos = videos;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addVideosItem(AbstractSimpleMultimediaNonAuthenticatedEntity videosItem) {
    if (this.videos == null) {
      this.videos = new ArrayList<>();
    }
    this.videos.add(videosItem);
    return this;
  }

   /**
   * List of property videos
   * @return videos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AbstractSimpleMultimediaNonAuthenticatedEntity> getVideos() {
    return videos;
  }


  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideos(List<AbstractSimpleMultimediaNonAuthenticatedEntity> videos) {
    this.videos = videos;
  }


  public HotelInventoryResponseNonAuthenticatedEntity recognitions(List<RecognitionNonAuthenticatedEntity> recognitions) {
    
    this.recognitions = recognitions;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addRecognitionsItem(RecognitionNonAuthenticatedEntity recognitionsItem) {
    if (this.recognitions == null) {
      this.recognitions = new ArrayList<>();
    }
    this.recognitions.add(recognitionsItem);
    return this;
  }

   /**
   * List of property recognitions
   * @return recognitions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RecognitionNonAuthenticatedEntity> getRecognitions() {
    return recognitions;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitions(List<RecognitionNonAuthenticatedEntity> recognitions) {
    this.recognitions = recognitions;
  }


  public HotelInventoryResponseNonAuthenticatedEntity announcements(List<AnnouncementNonAuthenticatedEntity> announcements) {
    
    this.announcements = announcements;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addAnnouncementsItem(AnnouncementNonAuthenticatedEntity announcementsItem) {
    if (this.announcements == null) {
      this.announcements = new ArrayList<>();
    }
    this.announcements.add(announcementsItem);
    return this;
  }

   /**
   * List of property announcements
   * @return announcements
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANNOUNCEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AnnouncementNonAuthenticatedEntity> getAnnouncements() {
    return announcements;
  }


  @JsonProperty(JSON_PROPERTY_ANNOUNCEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnouncements(List<AnnouncementNonAuthenticatedEntity> announcements) {
    this.announcements = announcements;
  }


  public HotelInventoryResponseNonAuthenticatedEntity reviews(List<UserReviewNonAuthenticatedEntity> reviews) {
    
    this.reviews = reviews;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addReviewsItem(UserReviewNonAuthenticatedEntity reviewsItem) {
    if (this.reviews == null) {
      this.reviews = new ArrayList<>();
    }
    this.reviews.add(reviewsItem);
    return this;
  }

   /**
   * List of property reviews
   * @return reviews
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UserReviewNonAuthenticatedEntity> getReviews() {
    return reviews;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviews(List<UserReviewNonAuthenticatedEntity> reviews) {
    this.reviews = reviews;
  }


  public HotelInventoryResponseNonAuthenticatedEntity salesChannel(SalesChannelInfoNonAuthenticatedEntity salesChannel) {
    
    this.salesChannel = salesChannel;
    return this;
  }

   /**
   * Get salesChannel
   * @return salesChannel
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelInfoNonAuthenticatedEntity getSalesChannel() {
    return salesChannel;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSalesChannel(SalesChannelInfoNonAuthenticatedEntity salesChannel) {
    this.salesChannel = salesChannel;
  }


  public HotelInventoryResponseNonAuthenticatedEntity cheapestRoomTypes(List<RoomTypeWithPriceConfigurationNonAuthenticatedEntity> cheapestRoomTypes) {
    
    this.cheapestRoomTypes = cheapestRoomTypes;
    return this;
  }

  public HotelInventoryResponseNonAuthenticatedEntity addCheapestRoomTypesItem(RoomTypeWithPriceConfigurationNonAuthenticatedEntity cheapestRoomTypesItem) {
    if (this.cheapestRoomTypes == null) {
      this.cheapestRoomTypes = new ArrayList<>();
    }
    this.cheapestRoomTypes.add(cheapestRoomTypesItem);
    return this;
  }

   /**
   * Get cheapestRoomTypes
   * @return cheapestRoomTypes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHEAPEST_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomTypeWithPriceConfigurationNonAuthenticatedEntity> getCheapestRoomTypes() {
    return cheapestRoomTypes;
  }


  @JsonProperty(JSON_PROPERTY_CHEAPEST_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheapestRoomTypes(List<RoomTypeWithPriceConfigurationNonAuthenticatedEntity> cheapestRoomTypes) {
    this.cheapestRoomTypes = cheapestRoomTypes;
  }


  public HotelInventoryResponseNonAuthenticatedEntity available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Get available
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public HotelInventoryResponseNonAuthenticatedEntity bestPrice(RoomTypeWithPriceConfigurationNonAuthenticatedEntity bestPrice) {
    
    this.bestPrice = bestPrice;
    return this;
  }

   /**
   * Get bestPrice
   * @return bestPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomTypeWithPriceConfigurationNonAuthenticatedEntity getBestPrice() {
    return bestPrice;
  }


  @JsonProperty(JSON_PROPERTY_BEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBestPrice(RoomTypeWithPriceConfigurationNonAuthenticatedEntity bestPrice) {
    this.bestPrice = bestPrice;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelInventoryResponseNonAuthenticatedEntity hotelInventoryResponseNonAuthenticatedEntity = (HotelInventoryResponseNonAuthenticatedEntity) o;
    return Objects.equals(this.hotelIdentifier, hotelInventoryResponseNonAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.urlName, hotelInventoryResponseNonAuthenticatedEntity.urlName) &&
        Objects.equals(this.hotel, hotelInventoryResponseNonAuthenticatedEntity.hotel) &&
        Objects.equals(this.greenIndexScores, hotelInventoryResponseNonAuthenticatedEntity.greenIndexScores) &&
        Objects.equals(this.roomTypes, hotelInventoryResponseNonAuthenticatedEntity.roomTypes) &&
        Objects.equals(this.meetingRooms, hotelInventoryResponseNonAuthenticatedEntity.meetingRooms) &&
        Objects.equals(this.restaurants, hotelInventoryResponseNonAuthenticatedEntity.restaurants) &&
        Objects.equals(this.spas, hotelInventoryResponseNonAuthenticatedEntity.spas) &&
        Objects.equals(this.activities, hotelInventoryResponseNonAuthenticatedEntity.activities) &&
        Objects.equals(this.attractions, hotelInventoryResponseNonAuthenticatedEntity.attractions) &&
        Objects.equals(this.places, hotelInventoryResponseNonAuthenticatedEntity.places) &&
        Objects.equals(this.metadata, hotelInventoryResponseNonAuthenticatedEntity.metadata) &&
        Objects.equals(this.images, hotelInventoryResponseNonAuthenticatedEntity.images) &&
        Objects.equals(this.videos, hotelInventoryResponseNonAuthenticatedEntity.videos) &&
        Objects.equals(this.recognitions, hotelInventoryResponseNonAuthenticatedEntity.recognitions) &&
        Objects.equals(this.announcements, hotelInventoryResponseNonAuthenticatedEntity.announcements) &&
        Objects.equals(this.reviews, hotelInventoryResponseNonAuthenticatedEntity.reviews) &&
        Objects.equals(this.salesChannel, hotelInventoryResponseNonAuthenticatedEntity.salesChannel) &&
        Objects.equals(this.cheapestRoomTypes, hotelInventoryResponseNonAuthenticatedEntity.cheapestRoomTypes) &&
        Objects.equals(this.available, hotelInventoryResponseNonAuthenticatedEntity.available) &&
        Objects.equals(this.bestPrice, hotelInventoryResponseNonAuthenticatedEntity.bestPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, urlName, hotel, greenIndexScores, roomTypes, meetingRooms, restaurants, spas, activities, attractions, places, metadata, images, videos, recognitions, announcements, reviews, salesChannel, cheapestRoomTypes, available, bestPrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelInventoryResponseNonAuthenticatedEntity {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    greenIndexScores: ").append(toIndentedString(greenIndexScores)).append("\n");
    sb.append("    roomTypes: ").append(toIndentedString(roomTypes)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    activities: ").append(toIndentedString(activities)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    places: ").append(toIndentedString(places)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    videos: ").append(toIndentedString(videos)).append("\n");
    sb.append("    recognitions: ").append(toIndentedString(recognitions)).append("\n");
    sb.append("    announcements: ").append(toIndentedString(announcements)).append("\n");
    sb.append("    reviews: ").append(toIndentedString(reviews)).append("\n");
    sb.append("    salesChannel: ").append(toIndentedString(salesChannel)).append("\n");
    sb.append("    cheapestRoomTypes: ").append(toIndentedString(cheapestRoomTypes)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    bestPrice: ").append(toIndentedString(bestPrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

