package travel.wink.sdk.inventory.api;

import travel.wink.sdk.inventory.invoker.ApiClient;

import travel.wink.sdk.inventory.model.AggregateActivityRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateAddOnRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateAttractionRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateGuestRoomRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateHotelRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateInventoryGridItemRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateMeetingRoomRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregatePlaceRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateRestaurantRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateSellerInventoryListRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateSpaRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GenericErrorMessage;
import travel.wink.sdk.inventory.model.HotelInventoryListRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelInventoryListResponseNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelInventoryRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelInventoryResponseNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.InventoryGridItemNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.Oauth2ShowPropertyInventory400Response;
import travel.wink.sdk.inventory.model.SellerInventoryActivityNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryAddOnNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryAttractionNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryGuestRoomNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryHotelNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryListResponseNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryMeetingRoomNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryPlaceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryRankedListResponseNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryRestaurantNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventorySpaNonAuthenticatedEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T22:29:53.971911916+07:00[Asia/Bangkok]")
public class InventoryApi {
    private ApiClient apiClient;

    public InventoryApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestNonAuthenticatedEntity The aggregateInventoryGridItemRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryGridItemNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowInventoryGridItemRequestCreation(AggregateInventoryGridItemRequestNonAuthenticatedEntity aggregateInventoryGridItemRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateInventoryGridItemRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateInventoryGridItemRequestNonAuthenticatedEntity' is set
        if (aggregateInventoryGridItemRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateInventoryGridItemRequestNonAuthenticatedEntity' when calling oauth2ShowInventoryGridItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/grid/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestNonAuthenticatedEntity The aggregateInventoryGridItemRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryGridItemNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryGridItemNonAuthenticatedEntity> oauth2ShowInventoryGridItem(AggregateInventoryGridItemRequestNonAuthenticatedEntity aggregateInventoryGridItemRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity>() {};
        return oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestNonAuthenticatedEntity The aggregateInventoryGridItemRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryGridItemNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryGridItemNonAuthenticatedEntity>> oauth2ShowInventoryGridItemWithHttpInfo(AggregateInventoryGridItemRequestNonAuthenticatedEntity aggregateInventoryGridItemRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity>() {};
        return oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestNonAuthenticatedEntity The aggregateInventoryGridItemRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowInventoryGridItemWithResponseSpec(AggregateInventoryGridItemRequestNonAuthenticatedEntity aggregateInventoryGridItemRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestNonAuthenticatedEntity The aggregateAddOnRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryAddOnNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAddOnRequestCreation(AggregateAddOnRequestNonAuthenticatedEntity aggregateAddOnRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateAddOnRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateAddOnRequestNonAuthenticatedEntity' is set
        if (aggregateAddOnRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAddOnRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/upgrade", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestNonAuthenticatedEntity The aggregateAddOnRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryAddOnNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryAddOnNonAuthenticatedEntity> oauth2ShowPropertyAddOn(AggregateAddOnRequestNonAuthenticatedEntity aggregateAddOnRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestNonAuthenticatedEntity The aggregateAddOnRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryAddOnNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryAddOnNonAuthenticatedEntity>> oauth2ShowPropertyAddOnWithHttpInfo(AggregateAddOnRequestNonAuthenticatedEntity aggregateAddOnRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestNonAuthenticatedEntity The aggregateAddOnRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyAddOnWithResponseSpec(AggregateAddOnRequestNonAuthenticatedEntity aggregateAddOnRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestNonAuthenticatedEntity The aggregateHotelRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryHotelNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAggregateRequestCreation(AggregateHotelRequestNonAuthenticatedEntity aggregateHotelRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateHotelRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateHotelRequestNonAuthenticatedEntity' is set
        if (aggregateHotelRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateHotelRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyAggregate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/property", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestNonAuthenticatedEntity The aggregateHotelRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryHotelNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryHotelNonAuthenticatedEntity> oauth2ShowPropertyAggregate(AggregateHotelRequestNonAuthenticatedEntity aggregateHotelRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestNonAuthenticatedEntity The aggregateHotelRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryHotelNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryHotelNonAuthenticatedEntity>> oauth2ShowPropertyAggregateWithHttpInfo(AggregateHotelRequestNonAuthenticatedEntity aggregateHotelRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestNonAuthenticatedEntity The aggregateHotelRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyAggregateWithResponseSpec(AggregateHotelRequestNonAuthenticatedEntity aggregateHotelRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestNonAuthenticatedEntity The aggregateAttractionRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryAttractionNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAttractionRequestCreation(AggregateAttractionRequestNonAuthenticatedEntity aggregateAttractionRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateAttractionRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateAttractionRequestNonAuthenticatedEntity' is set
        if (aggregateAttractionRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAttractionRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/attraction", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestNonAuthenticatedEntity The aggregateAttractionRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryAttractionNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryAttractionNonAuthenticatedEntity> oauth2ShowPropertyAttraction(AggregateAttractionRequestNonAuthenticatedEntity aggregateAttractionRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestNonAuthenticatedEntity The aggregateAttractionRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryAttractionNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryAttractionNonAuthenticatedEntity>> oauth2ShowPropertyAttractionWithHttpInfo(AggregateAttractionRequestNonAuthenticatedEntity aggregateAttractionRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestNonAuthenticatedEntity The aggregateAttractionRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyAttractionWithResponseSpec(AggregateAttractionRequestNonAuthenticatedEntity aggregateAttractionRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestNonAuthenticatedEntity The hotelInventoryRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyInventoryRequestCreation(HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = hotelInventoryRequestNonAuthenticatedEntity;
        // verify the required parameter 'hotelInventoryRequestNonAuthenticatedEntity' is set
        if (hotelInventoryRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestNonAuthenticatedEntity The hotelInventoryRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelInventoryResponseNonAuthenticatedEntity> oauth2ShowPropertyInventory(HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestNonAuthenticatedEntity The hotelInventoryRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelInventoryResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelInventoryResponseNonAuthenticatedEntity>> oauth2ShowPropertyInventoryWithHttpInfo(HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestNonAuthenticatedEntity The hotelInventoryRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyInventoryWithResponseSpec(HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestNonAuthenticatedEntity The hotelInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyListRequestCreation(HotelInventoryListRequestNonAuthenticatedEntity hotelInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = hotelInventoryListRequestNonAuthenticatedEntity;
        // verify the required parameter 'hotelInventoryListRequestNonAuthenticatedEntity' is set
        if (hotelInventoryListRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryListRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestNonAuthenticatedEntity The hotelInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelInventoryListResponseNonAuthenticatedEntity> oauth2ShowPropertyList(HotelInventoryListRequestNonAuthenticatedEntity hotelInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyListRequestCreation(hotelInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestNonAuthenticatedEntity The hotelInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelInventoryListResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelInventoryListResponseNonAuthenticatedEntity>> oauth2ShowPropertyListWithHttpInfo(HotelInventoryListRequestNonAuthenticatedEntity hotelInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyListRequestCreation(hotelInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestNonAuthenticatedEntity The hotelInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyListWithResponseSpec(HotelInventoryListRequestNonAuthenticatedEntity hotelInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyListRequestCreation(hotelInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestNonAuthenticatedEntity The aggregateMeetingRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryMeetingRoomNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyMeetingRoomRequestCreation(AggregateMeetingRoomRequestNonAuthenticatedEntity aggregateMeetingRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateMeetingRoomRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateMeetingRoomRequestNonAuthenticatedEntity' is set
        if (aggregateMeetingRoomRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateMeetingRoomRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/meetingroom", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestNonAuthenticatedEntity The aggregateMeetingRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryMeetingRoomNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryMeetingRoomNonAuthenticatedEntity> oauth2ShowPropertyMeetingRoom(AggregateMeetingRoomRequestNonAuthenticatedEntity aggregateMeetingRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestNonAuthenticatedEntity The aggregateMeetingRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryMeetingRoomNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryMeetingRoomNonAuthenticatedEntity>> oauth2ShowPropertyMeetingRoomWithHttpInfo(AggregateMeetingRoomRequestNonAuthenticatedEntity aggregateMeetingRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestNonAuthenticatedEntity The aggregateMeetingRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyMeetingRoomWithResponseSpec(AggregateMeetingRoomRequestNonAuthenticatedEntity aggregateMeetingRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestNonAuthenticatedEntity The aggregatePlaceRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryPlaceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyPlaceRequestCreation(AggregatePlaceRequestNonAuthenticatedEntity aggregatePlaceRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregatePlaceRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregatePlaceRequestNonAuthenticatedEntity' is set
        if (aggregatePlaceRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregatePlaceRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/place", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestNonAuthenticatedEntity The aggregatePlaceRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryPlaceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryPlaceNonAuthenticatedEntity> oauth2ShowPropertyPlace(AggregatePlaceRequestNonAuthenticatedEntity aggregatePlaceRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestNonAuthenticatedEntity The aggregatePlaceRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryPlaceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryPlaceNonAuthenticatedEntity>> oauth2ShowPropertyPlaceWithHttpInfo(AggregatePlaceRequestNonAuthenticatedEntity aggregatePlaceRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestNonAuthenticatedEntity The aggregatePlaceRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyPlaceWithResponseSpec(AggregatePlaceRequestNonAuthenticatedEntity aggregatePlaceRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestNonAuthenticatedEntity The aggregateActivityRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryActivityNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRecreationRequestCreation(AggregateActivityRequestNonAuthenticatedEntity aggregateActivityRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateActivityRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateActivityRequestNonAuthenticatedEntity' is set
        if (aggregateActivityRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateActivityRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyRecreation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/activity", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestNonAuthenticatedEntity The aggregateActivityRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryActivityNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryActivityNonAuthenticatedEntity> oauth2ShowPropertyRecreation(AggregateActivityRequestNonAuthenticatedEntity aggregateActivityRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestNonAuthenticatedEntity The aggregateActivityRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryActivityNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryActivityNonAuthenticatedEntity>> oauth2ShowPropertyRecreationWithHttpInfo(AggregateActivityRequestNonAuthenticatedEntity aggregateActivityRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestNonAuthenticatedEntity The aggregateActivityRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyRecreationWithResponseSpec(AggregateActivityRequestNonAuthenticatedEntity aggregateActivityRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestNonAuthenticatedEntity The aggregateRestaurantRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRestaurantNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRestaurantRequestCreation(AggregateRestaurantRequestNonAuthenticatedEntity aggregateRestaurantRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateRestaurantRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateRestaurantRequestNonAuthenticatedEntity' is set
        if (aggregateRestaurantRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateRestaurantRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/restaurant", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestNonAuthenticatedEntity The aggregateRestaurantRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRestaurantNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRestaurantNonAuthenticatedEntity> oauth2ShowPropertyRestaurant(AggregateRestaurantRequestNonAuthenticatedEntity aggregateRestaurantRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestNonAuthenticatedEntity The aggregateRestaurantRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryRestaurantNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryRestaurantNonAuthenticatedEntity>> oauth2ShowPropertyRestaurantWithHttpInfo(AggregateRestaurantRequestNonAuthenticatedEntity aggregateRestaurantRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestNonAuthenticatedEntity The aggregateRestaurantRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyRestaurantWithResponseSpec(AggregateRestaurantRequestNonAuthenticatedEntity aggregateRestaurantRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestNonAuthenticatedEntity The aggregateGuestRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryGuestRoomNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRoomTypeRequestCreation(AggregateGuestRoomRequestNonAuthenticatedEntity aggregateGuestRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateGuestRoomRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateGuestRoomRequestNonAuthenticatedEntity' is set
        if (aggregateGuestRoomRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateGuestRoomRequestNonAuthenticatedEntity' when calling oauth2ShowPropertyRoomType", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/guestroom", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestNonAuthenticatedEntity The aggregateGuestRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryGuestRoomNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryGuestRoomNonAuthenticatedEntity> oauth2ShowPropertyRoomType(AggregateGuestRoomRequestNonAuthenticatedEntity aggregateGuestRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestNonAuthenticatedEntity The aggregateGuestRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryGuestRoomNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryGuestRoomNonAuthenticatedEntity>> oauth2ShowPropertyRoomTypeWithHttpInfo(AggregateGuestRoomRequestNonAuthenticatedEntity aggregateGuestRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity>() {};
        return oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestNonAuthenticatedEntity The aggregateGuestRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyRoomTypeWithResponseSpec(AggregateGuestRoomRequestNonAuthenticatedEntity aggregateGuestRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestNonAuthenticatedEntity The aggregateSpaRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventorySpaNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertySpaRequestCreation(AggregateSpaRequestNonAuthenticatedEntity aggregateSpaRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateSpaRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateSpaRequestNonAuthenticatedEntity' is set
        if (aggregateSpaRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSpaRequestNonAuthenticatedEntity' when calling oauth2ShowPropertySpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/spa", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestNonAuthenticatedEntity The aggregateSpaRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventorySpaNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventorySpaNonAuthenticatedEntity> oauth2ShowPropertySpa(AggregateSpaRequestNonAuthenticatedEntity aggregateSpaRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity>() {};
        return oauth2ShowPropertySpaRequestCreation(aggregateSpaRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestNonAuthenticatedEntity The aggregateSpaRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventorySpaNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventorySpaNonAuthenticatedEntity>> oauth2ShowPropertySpaWithHttpInfo(AggregateSpaRequestNonAuthenticatedEntity aggregateSpaRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity>() {};
        return oauth2ShowPropertySpaRequestCreation(aggregateSpaRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestNonAuthenticatedEntity The aggregateSpaRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertySpaWithResponseSpec(AggregateSpaRequestNonAuthenticatedEntity aggregateSpaRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertySpaRequestCreation(aggregateSpaRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowSellerInventoryListRequestCreation(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateSellerInventoryListRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateSellerInventoryListRequestNonAuthenticatedEntity' is set
        if (aggregateSellerInventoryListRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequestNonAuthenticatedEntity' when calling oauth2ShowSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListResponseNonAuthenticatedEntity> oauth2ShowSellerInventoryList(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity>() {};
        return oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryListResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryListResponseNonAuthenticatedEntity>> oauth2ShowSellerInventoryListWithHttpInfo(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity>() {};
        return oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowSellerInventoryListWithResponseSpec(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowSellerInventoryRankedListRequestCreation(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateSellerInventoryListRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateSellerInventoryListRequestNonAuthenticatedEntity' is set
        if (aggregateSellerInventoryListRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequestNonAuthenticatedEntity' when calling oauth2ShowSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/ranked/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListResponseNonAuthenticatedEntity> oauth2ShowSellerInventoryRankedList(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity>() {};
        return oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryRankedListResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryRankedListResponseNonAuthenticatedEntity>> oauth2ShowSellerInventoryRankedListWithHttpInfo(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity>() {};
        return oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowSellerInventoryRankedListWithResponseSpec(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
}
