/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.61.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.UUID;
import travel.wink.sdk.inventory.model.CancellationPolicyNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CancellationPolicyExceptionNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  CancellationPolicyExceptionNonAuthenticatedEntity.JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER,
  CancellationPolicyExceptionNonAuthenticatedEntity.JSON_PROPERTY_CANCELLATION_POLICY,
  CancellationPolicyExceptionNonAuthenticatedEntity.JSON_PROPERTY_START_DATE,
  CancellationPolicyExceptionNonAuthenticatedEntity.JSON_PROPERTY_END_DATE
})
@JsonTypeName("CancellationPolicyException_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T22:29:53.971911916+07:00[Asia/Bangkok]")
public class CancellationPolicyExceptionNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER = "cancellationPolicyIdentifier";
  private UUID cancellationPolicyIdentifier;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY = "cancellationPolicy";
  private CancellationPolicyNonAuthenticatedEntity cancellationPolicy;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public CancellationPolicyExceptionNonAuthenticatedEntity() {
  }

  public CancellationPolicyExceptionNonAuthenticatedEntity cancellationPolicyIdentifier(UUID cancellationPolicyIdentifier) {
    
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
    return this;
  }

   /**
   * Cancellation policy
   * @return cancellationPolicyIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getCancellationPolicyIdentifier() {
    return cancellationPolicyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancellationPolicyIdentifier(UUID cancellationPolicyIdentifier) {
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
  }


  public CancellationPolicyExceptionNonAuthenticatedEntity cancellationPolicy(CancellationPolicyNonAuthenticatedEntity cancellationPolicy) {
    
    this.cancellationPolicy = cancellationPolicy;
    return this;
  }

   /**
   * Get cancellationPolicy
   * @return cancellationPolicy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellationPolicyNonAuthenticatedEntity getCancellationPolicy() {
    return cancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancellationPolicy(CancellationPolicyNonAuthenticatedEntity cancellationPolicy) {
    this.cancellationPolicy = cancellationPolicy;
  }


  public CancellationPolicyExceptionNonAuthenticatedEntity startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Start date for when this cancellation policy should start to override the default cancellation policy.
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public CancellationPolicyExceptionNonAuthenticatedEntity endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * End date for when this cancellation policy should end overriding the default cancellation policy.
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CancellationPolicyExceptionNonAuthenticatedEntity cancellationPolicyExceptionNonAuthenticatedEntity = (CancellationPolicyExceptionNonAuthenticatedEntity) o;
    return Objects.equals(this.cancellationPolicyIdentifier, cancellationPolicyExceptionNonAuthenticatedEntity.cancellationPolicyIdentifier) &&
        Objects.equals(this.cancellationPolicy, cancellationPolicyExceptionNonAuthenticatedEntity.cancellationPolicy) &&
        Objects.equals(this.startDate, cancellationPolicyExceptionNonAuthenticatedEntity.startDate) &&
        Objects.equals(this.endDate, cancellationPolicyExceptionNonAuthenticatedEntity.endDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cancellationPolicyIdentifier, cancellationPolicy, startDate, endDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CancellationPolicyExceptionNonAuthenticatedEntity {\n");
    sb.append("    cancellationPolicyIdentifier: ").append(toIndentedString(cancellationPolicyIdentifier)).append("\n");
    sb.append("    cancellationPolicy: ").append(toIndentedString(cancellationPolicy)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

