/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.62.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.inventory.model.UserReviewAnswerNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of property reviews
 */
@JsonPropertyOrder({
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_REVIEW_BY,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_REVIEWED_ON,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_AVERAGE_SCORE,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_ANSWERS,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_RESPONSE_FROM_HOTEL,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_IMAGE_IDENTIFIER,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_REVIEW,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_LIKES
})
@JsonTypeName("UserReview_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-12T17:01:34.203312439+07:00[Asia/Bangkok]")
public class UserReviewNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_REVIEW_BY = "reviewBy";
  private String reviewBy;

  public static final String JSON_PROPERTY_REVIEWED_ON = "reviewedOn";
  private java.time.LocalDateTime reviewedOn;

  public static final String JSON_PROPERTY_AVERAGE_SCORE = "averageScore";
  private java.math.BigDecimal averageScore;

  public static final String JSON_PROPERTY_ANSWERS = "answers";
  private List<UserReviewAnswerNonAuthenticatedEntity> answers;

  public static final String JSON_PROPERTY_RESPONSE_FROM_HOTEL = "responseFromHotel";
  private String responseFromHotel;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_REVIEW = "review";
  private String review;

  public static final String JSON_PROPERTY_LIKES = "likes";
  private List<Integer> likes;

  public UserReviewNonAuthenticatedEntity() {
  }

  public UserReviewNonAuthenticatedEntity reviewBy(String reviewBy) {
    
    this.reviewBy = reviewBy;
    return this;
  }

   /**
   * User details of creator of booking.
   * @return reviewBy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REVIEW_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReviewBy() {
    return reviewBy;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewBy(String reviewBy) {
    this.reviewBy = reviewBy;
  }


  public UserReviewNonAuthenticatedEntity reviewedOn(java.time.LocalDateTime reviewedOn) {
    
    this.reviewedOn = reviewedOn;
    return this;
  }

   /**
   * Date of review.
   * @return reviewedOn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEWED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getReviewedOn() {
    return reviewedOn;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewedOn(java.time.LocalDateTime reviewedOn) {
    this.reviewedOn = reviewedOn;
  }


  public UserReviewNonAuthenticatedEntity averageScore(java.math.BigDecimal averageScore) {
    
    this.averageScore = averageScore;
    return this;
  }

   /**
   * Total points divided by number of questions.
   * @return averageScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getAverageScore() {
    return averageScore;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageScore(java.math.BigDecimal averageScore) {
    this.averageScore = averageScore;
  }


  public UserReviewNonAuthenticatedEntity answers(List<UserReviewAnswerNonAuthenticatedEntity> answers) {
    
    this.answers = answers;
    return this;
  }

  public UserReviewNonAuthenticatedEntity addAnswersItem(UserReviewAnswerNonAuthenticatedEntity answersItem) {
    if (this.answers == null) {
      this.answers = new ArrayList<>();
    }
    this.answers.add(answersItem);
    return this;
  }

   /**
   * List of reviewBy review answers.
   * @return answers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UserReviewAnswerNonAuthenticatedEntity> getAnswers() {
    return answers;
  }


  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnswers(List<UserReviewAnswerNonAuthenticatedEntity> answers) {
    this.answers = answers;
  }


  public UserReviewNonAuthenticatedEntity responseFromHotel(String responseFromHotel) {
    
    this.responseFromHotel = responseFromHotel;
    return this;
  }

   /**
   * Property can response to traveler review. Response goes on public review profile and can be seen by others.
   * @return responseFromHotel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResponseFromHotel() {
    return responseFromHotel;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponseFromHotel(String responseFromHotel) {
    this.responseFromHotel = responseFromHotel;
  }


  public UserReviewNonAuthenticatedEntity imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Reviewer can upload her best picture from the property. Cloudinary image identifier.
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public UserReviewNonAuthenticatedEntity review(String review) {
    
    this.review = review;
    return this;
  }

   /**
   * Free text record created by traveler
   * @return review
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReview() {
    return review;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReview(String review) {
    this.review = review;
  }


  public UserReviewNonAuthenticatedEntity likes(List<Integer> likes) {
    
    this.likes = likes;
    return this;
  }

  public UserReviewNonAuthenticatedEntity addLikesItem(Integer likesItem) {
    if (this.likes == null) {
      this.likes = new ArrayList<>();
    }
    this.likes.add(likesItem);
    return this;
  }

   /**
   * List of member identifiers who liked the reviewual review
   * @return likes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integer> getLikes() {
    return likes;
  }


  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLikes(List<Integer> likes) {
    this.likes = likes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserReviewNonAuthenticatedEntity userReviewNonAuthenticatedEntity = (UserReviewNonAuthenticatedEntity) o;
    return Objects.equals(this.reviewBy, userReviewNonAuthenticatedEntity.reviewBy) &&
        Objects.equals(this.reviewedOn, userReviewNonAuthenticatedEntity.reviewedOn) &&
        Objects.equals(this.averageScore, userReviewNonAuthenticatedEntity.averageScore) &&
        Objects.equals(this.answers, userReviewNonAuthenticatedEntity.answers) &&
        Objects.equals(this.responseFromHotel, userReviewNonAuthenticatedEntity.responseFromHotel) &&
        Objects.equals(this.imageIdentifier, userReviewNonAuthenticatedEntity.imageIdentifier) &&
        Objects.equals(this.review, userReviewNonAuthenticatedEntity.review) &&
        Objects.equals(this.likes, userReviewNonAuthenticatedEntity.likes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reviewBy, reviewedOn, averageScore, answers, responseFromHotel, imageIdentifier, review, likes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserReviewNonAuthenticatedEntity {\n");
    sb.append("    reviewBy: ").append(toIndentedString(reviewBy)).append("\n");
    sb.append("    reviewedOn: ").append(toIndentedString(reviewedOn)).append("\n");
    sb.append("    averageScore: ").append(toIndentedString(averageScore)).append("\n");
    sb.append("    answers: ").append(toIndentedString(answers)).append("\n");
    sb.append("    responseFromHotel: ").append(toIndentedString(responseFromHotel)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    review: ").append(toIndentedString(review)).append("\n");
    sb.append("    likes: ").append(toIndentedString(likes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

