/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.65.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.inventory.model.GuestRoomNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelOnMapNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.QuoteNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RoomTypeBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RoomTypeWithBestPriceNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Property details along with the best room type price this property has to offer.
 */
@JsonPropertyOrder({
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_HOTEL,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_PRICE,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_ROOM_TYPE_LIST,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_PRICE_LIST,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_DISTANCE,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_AVAILABLE
})
@JsonTypeName("HotelWithBestPrice_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-23T16:39:09.255618197+07:00[Asia/Bangkok]")
public class HotelWithBestPriceNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapNonAuthenticatedEntity hotel;

  public static final String JSON_PROPERTY_PRICE = "price";
  private RoomTypeWithBestPriceNonAuthenticatedEntity price;

  public static final String JSON_PROPERTY_ROOM_TYPE_LIST = "roomTypeList";
  private List<GuestRoomNonAuthenticatedEntity> roomTypeList = new ArrayList<>();

  public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
  private List<RoomTypeBestPriceNonAuthenticatedEntity> priceList = new ArrayList<>();

  public static final String JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT = "potentialChannelDiscountPercent";
  private Float potentialChannelDiscountPercent;

  public static final String JSON_PROPERTY_DISTANCE = "distance";
  private java.math.BigDecimal distance;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private QuoteNonAuthenticatedEntity sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private QuoteNonAuthenticatedEntity sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public HotelWithBestPriceNonAuthenticatedEntity() {
  }

  public HotelWithBestPriceNonAuthenticatedEntity hotel(HotelOnMapNonAuthenticatedEntity hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public HotelOnMapNonAuthenticatedEntity getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotel(HotelOnMapNonAuthenticatedEntity hotel) {
    this.hotel = hotel;
  }


  public HotelWithBestPriceNonAuthenticatedEntity price(RoomTypeWithBestPriceNonAuthenticatedEntity price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomTypeWithBestPriceNonAuthenticatedEntity getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(RoomTypeWithBestPriceNonAuthenticatedEntity price) {
    this.price = price;
  }


  public HotelWithBestPriceNonAuthenticatedEntity roomTypeList(List<GuestRoomNonAuthenticatedEntity> roomTypeList) {
    
    this.roomTypeList = roomTypeList;
    return this;
  }

  public HotelWithBestPriceNonAuthenticatedEntity addRoomTypeListItem(GuestRoomNonAuthenticatedEntity roomTypeListItem) {
    if (this.roomTypeList == null) {
      this.roomTypeList = new ArrayList<>();
    }
    this.roomTypeList.add(roomTypeListItem);
    return this;
  }

   /**
   * Unique property room types
   * @return roomTypeList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<GuestRoomNonAuthenticatedEntity> getRoomTypeList() {
    return roomTypeList;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomTypeList(List<GuestRoomNonAuthenticatedEntity> roomTypeList) {
    this.roomTypeList = roomTypeList;
  }


  public HotelWithBestPriceNonAuthenticatedEntity priceList(List<RoomTypeBestPriceNonAuthenticatedEntity> priceList) {
    
    this.priceList = priceList;
    return this;
  }

  public HotelWithBestPriceNonAuthenticatedEntity addPriceListItem(RoomTypeBestPriceNonAuthenticatedEntity priceListItem) {
    if (this.priceList == null) {
      this.priceList = new ArrayList<>();
    }
    this.priceList.add(priceListItem);
    return this;
  }

   /**
   * Best-priced room types
   * @return priceList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RoomTypeBestPriceNonAuthenticatedEntity> getPriceList() {
    return priceList;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPriceList(List<RoomTypeBestPriceNonAuthenticatedEntity> priceList) {
    this.priceList = priceList;
  }


  public HotelWithBestPriceNonAuthenticatedEntity potentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
    
    this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
    return this;
  }

   /**
   * The potential discount the user is entitled to if user is a member / authenticated.
   * @return potentialChannelDiscountPercent
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getPotentialChannelDiscountPercent() {
    return potentialChannelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPotentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
    this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
  }


  public HotelWithBestPriceNonAuthenticatedEntity distance(java.math.BigDecimal distance) {
    
    this.distance = distance;
    return this;
  }

   /**
   * If property is within certain geo data result set, distance will be included here to signify the distance the property is from a specific geo-location.
   * @return distance
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getDistance() {
    return distance;
  }


  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDistance(java.math.BigDecimal distance) {
    this.distance = distance;
  }


  public HotelWithBestPriceNonAuthenticatedEntity sourceToUserCurrencyQuote(QuoteNonAuthenticatedEntity sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteNonAuthenticatedEntity getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToUserCurrencyQuote(QuoteNonAuthenticatedEntity sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public HotelWithBestPriceNonAuthenticatedEntity sourceToInternalCurrencyQuote(QuoteNonAuthenticatedEntity sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteNonAuthenticatedEntity getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToInternalCurrencyQuote(QuoteNonAuthenticatedEntity sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public HotelWithBestPriceNonAuthenticatedEntity available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Flag to indicate whether this inventory is available or not. This data point is identifier to the available flag on the &#x60;price&#x60; child data point.
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelWithBestPriceNonAuthenticatedEntity hotelWithBestPriceNonAuthenticatedEntity = (HotelWithBestPriceNonAuthenticatedEntity) o;
    return Objects.equals(this.hotel, hotelWithBestPriceNonAuthenticatedEntity.hotel) &&
        Objects.equals(this.price, hotelWithBestPriceNonAuthenticatedEntity.price) &&
        Objects.equals(this.roomTypeList, hotelWithBestPriceNonAuthenticatedEntity.roomTypeList) &&
        Objects.equals(this.priceList, hotelWithBestPriceNonAuthenticatedEntity.priceList) &&
        Objects.equals(this.potentialChannelDiscountPercent, hotelWithBestPriceNonAuthenticatedEntity.potentialChannelDiscountPercent) &&
        Objects.equals(this.distance, hotelWithBestPriceNonAuthenticatedEntity.distance) &&
        Objects.equals(this.sourceToUserCurrencyQuote, hotelWithBestPriceNonAuthenticatedEntity.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, hotelWithBestPriceNonAuthenticatedEntity.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.available, hotelWithBestPriceNonAuthenticatedEntity.available);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotel, price, roomTypeList, priceList, potentialChannelDiscountPercent, distance, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, available);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelWithBestPriceNonAuthenticatedEntity {\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    roomTypeList: ").append(toIndentedString(roomTypeList)).append("\n");
    sb.append("    priceList: ").append(toIndentedString(priceList)).append("\n");
    sb.append("    potentialChannelDiscountPercent: ").append(toIndentedString(potentialChannelDiscountPercent)).append("\n");
    sb.append("    distance: ").append(toIndentedString(distance)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

