/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.7.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.AbstractSimpleMultimediaConsumer;
import travel.wink.sdk.inventory.model.ActivityLocalizedInventoryConsumer;
import travel.wink.sdk.inventory.model.AggregateGreendexAnswersConsumer;
import travel.wink.sdk.inventory.model.AnnouncementConsumer;
import travel.wink.sdk.inventory.model.AttractionLocalizedInventoryConsumer;
import travel.wink.sdk.inventory.model.HotelOnMapConsumer;
import travel.wink.sdk.inventory.model.MeetingRoomLocalizedInventoryConsumer;
import travel.wink.sdk.inventory.model.MetaDataConsumer;
import travel.wink.sdk.inventory.model.PlaceLocalizedInventoryConsumer;
import travel.wink.sdk.inventory.model.RecognitionConsumer;
import travel.wink.sdk.inventory.model.RestaurantLocalizedInventoryConsumer;
import travel.wink.sdk.inventory.model.ReviewConsumer;
import travel.wink.sdk.inventory.model.RoomTypeWithPriceConfigurationConsumer;
import travel.wink.sdk.inventory.model.RoomTypeWithPriceConfigurationsConsumer;
import travel.wink.sdk.inventory.model.SalesChannelInfoConsumer;
import travel.wink.sdk.inventory.model.SpaLocalizedInventoryConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * HotelInventoryResponseConsumer
 */
@JsonPropertyOrder({
  HotelInventoryResponseConsumer.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelInventoryResponseConsumer.JSON_PROPERTY_URL_NAME,
  HotelInventoryResponseConsumer.JSON_PROPERTY_HOTEL,
  HotelInventoryResponseConsumer.JSON_PROPERTY_GREEN_INDEX_SCORES,
  HotelInventoryResponseConsumer.JSON_PROPERTY_ROOM_TYPES,
  HotelInventoryResponseConsumer.JSON_PROPERTY_MEETING_ROOMS,
  HotelInventoryResponseConsumer.JSON_PROPERTY_RESTAURANTS,
  HotelInventoryResponseConsumer.JSON_PROPERTY_SPAS,
  HotelInventoryResponseConsumer.JSON_PROPERTY_ACTIVITIES,
  HotelInventoryResponseConsumer.JSON_PROPERTY_ATTRACTIONS,
  HotelInventoryResponseConsumer.JSON_PROPERTY_PLACES,
  HotelInventoryResponseConsumer.JSON_PROPERTY_METADATA,
  HotelInventoryResponseConsumer.JSON_PROPERTY_IMAGES,
  HotelInventoryResponseConsumer.JSON_PROPERTY_VIDEOS,
  HotelInventoryResponseConsumer.JSON_PROPERTY_RECOGNITIONS,
  HotelInventoryResponseConsumer.JSON_PROPERTY_ANNOUNCEMENTS,
  HotelInventoryResponseConsumer.JSON_PROPERTY_REVIEWS,
  HotelInventoryResponseConsumer.JSON_PROPERTY_SALES_CHANNEL,
  HotelInventoryResponseConsumer.JSON_PROPERTY_BEST_PRICE,
  HotelInventoryResponseConsumer.JSON_PROPERTY_AVAILABLE,
  HotelInventoryResponseConsumer.JSON_PROPERTY_CHEAPEST_ROOM_TYPES
})
@JsonTypeName("HotelInventoryResponse_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-17T14:17:28.917189324+07:00[Asia/Bangkok]")
public class HotelInventoryResponseConsumer {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapConsumer hotel;

  public static final String JSON_PROPERTY_GREEN_INDEX_SCORES = "greenIndexScores";
  private AggregateGreendexAnswersConsumer greenIndexScores;

  public static final String JSON_PROPERTY_ROOM_TYPES = "roomTypes";
  private List<RoomTypeWithPriceConfigurationsConsumer> roomTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private List<MeetingRoomLocalizedInventoryConsumer> meetingRooms = new ArrayList<>();

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private List<RestaurantLocalizedInventoryConsumer> restaurants = new ArrayList<>();

  public static final String JSON_PROPERTY_SPAS = "spas";
  private List<SpaLocalizedInventoryConsumer> spas = new ArrayList<>();

  public static final String JSON_PROPERTY_ACTIVITIES = "activities";
  private List<ActivityLocalizedInventoryConsumer> activities = new ArrayList<>();

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private List<AttractionLocalizedInventoryConsumer> attractions = new ArrayList<>();

  public static final String JSON_PROPERTY_PLACES = "places";
  private List<PlaceLocalizedInventoryConsumer> places = new ArrayList<>();

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private List<MetaDataConsumer> metadata = new ArrayList<>();

  public static final String JSON_PROPERTY_IMAGES = "images";
  private List<AbstractSimpleMultimediaConsumer> images = new ArrayList<>();

  public static final String JSON_PROPERTY_VIDEOS = "videos";
  private List<AbstractSimpleMultimediaConsumer> videos = new ArrayList<>();

  public static final String JSON_PROPERTY_RECOGNITIONS = "recognitions";
  private List<RecognitionConsumer> recognitions = new ArrayList<>();

  public static final String JSON_PROPERTY_ANNOUNCEMENTS = "announcements";
  private List<AnnouncementConsumer> announcements = new ArrayList<>();

  public static final String JSON_PROPERTY_REVIEWS = "reviews";
  private List<ReviewConsumer> reviews = new ArrayList<>();

  public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
  private SalesChannelInfoConsumer salesChannel;

  public static final String JSON_PROPERTY_BEST_PRICE = "bestPrice";
  private RoomTypeWithPriceConfigurationConsumer bestPrice;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_CHEAPEST_ROOM_TYPES = "cheapestRoomTypes";
  private List<RoomTypeWithPriceConfigurationConsumer> cheapestRoomTypes = new ArrayList<>();

  public HotelInventoryResponseConsumer() {
  }

  public HotelInventoryResponseConsumer hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique property identifier to retrieve inventory for.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelInventoryResponseConsumer urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique url-friendly record identifier of property.
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelInventoryResponseConsumer hotel(HotelOnMapConsumer hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMapConsumer getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotel(HotelOnMapConsumer hotel) {
    this.hotel = hotel;
  }


  public HotelInventoryResponseConsumer greenIndexScores(AggregateGreendexAnswersConsumer greenIndexScores) {
    
    this.greenIndexScores = greenIndexScores;
    return this;
  }

   /**
   * Get greenIndexScores
   * @return greenIndexScores
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AggregateGreendexAnswersConsumer getGreenIndexScores() {
    return greenIndexScores;
  }


  @JsonProperty(JSON_PROPERTY_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGreenIndexScores(AggregateGreendexAnswersConsumer greenIndexScores) {
    this.greenIndexScores = greenIndexScores;
  }


  public HotelInventoryResponseConsumer roomTypes(List<RoomTypeWithPriceConfigurationsConsumer> roomTypes) {
    
    this.roomTypes = roomTypes;
    return this;
  }

  public HotelInventoryResponseConsumer addRoomTypesItem(RoomTypeWithPriceConfigurationsConsumer roomTypesItem) {
    if (this.roomTypes == null) {
      this.roomTypes = new ArrayList<>();
    }
    this.roomTypes.add(roomTypesItem);
    return this;
  }

   /**
   * List of room types with price configurations based on the itinerary that was passed on the user session.
   * @return roomTypes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomTypeWithPriceConfigurationsConsumer> getRoomTypes() {
    return roomTypes;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypes(List<RoomTypeWithPriceConfigurationsConsumer> roomTypes) {
    this.roomTypes = roomTypes;
  }


  public HotelInventoryResponseConsumer meetingRooms(List<MeetingRoomLocalizedInventoryConsumer> meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

  public HotelInventoryResponseConsumer addMeetingRoomsItem(MeetingRoomLocalizedInventoryConsumer meetingRoomsItem) {
    if (this.meetingRooms == null) {
      this.meetingRooms = new ArrayList<>();
    }
    this.meetingRooms.add(meetingRoomsItem);
    return this;
  }

   /**
   * List of property meeting rooms on and off the premises.
   * @return meetingRooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MeetingRoomLocalizedInventoryConsumer> getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(List<MeetingRoomLocalizedInventoryConsumer> meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public HotelInventoryResponseConsumer restaurants(List<RestaurantLocalizedInventoryConsumer> restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

  public HotelInventoryResponseConsumer addRestaurantsItem(RestaurantLocalizedInventoryConsumer restaurantsItem) {
    if (this.restaurants == null) {
      this.restaurants = new ArrayList<>();
    }
    this.restaurants.add(restaurantsItem);
    return this;
  }

   /**
   * List of property restaurants on and off the premises.
   * @return restaurants
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RestaurantLocalizedInventoryConsumer> getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(List<RestaurantLocalizedInventoryConsumer> restaurants) {
    this.restaurants = restaurants;
  }


  public HotelInventoryResponseConsumer spas(List<SpaLocalizedInventoryConsumer> spas) {
    
    this.spas = spas;
    return this;
  }

  public HotelInventoryResponseConsumer addSpasItem(SpaLocalizedInventoryConsumer spasItem) {
    if (this.spas == null) {
      this.spas = new ArrayList<>();
    }
    this.spas.add(spasItem);
    return this;
  }

   /**
   * List of property spas on and off the premises.
   * @return spas
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SpaLocalizedInventoryConsumer> getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(List<SpaLocalizedInventoryConsumer> spas) {
    this.spas = spas;
  }


  public HotelInventoryResponseConsumer activities(List<ActivityLocalizedInventoryConsumer> activities) {
    
    this.activities = activities;
    return this;
  }

  public HotelInventoryResponseConsumer addActivitiesItem(ActivityLocalizedInventoryConsumer activitiesItem) {
    if (this.activities == null) {
      this.activities = new ArrayList<>();
    }
    this.activities.add(activitiesItem);
    return this;
  }

   /**
   * List of property activities on and off the premises.
   * @return activities
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ActivityLocalizedInventoryConsumer> getActivities() {
    return activities;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivities(List<ActivityLocalizedInventoryConsumer> activities) {
    this.activities = activities;
  }


  public HotelInventoryResponseConsumer attractions(List<AttractionLocalizedInventoryConsumer> attractions) {
    
    this.attractions = attractions;
    return this;
  }

  public HotelInventoryResponseConsumer addAttractionsItem(AttractionLocalizedInventoryConsumer attractionsItem) {
    if (this.attractions == null) {
      this.attractions = new ArrayList<>();
    }
    this.attractions.add(attractionsItem);
    return this;
  }

   /**
   * List of property attractions on and off the premises.
   * @return attractions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AttractionLocalizedInventoryConsumer> getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(List<AttractionLocalizedInventoryConsumer> attractions) {
    this.attractions = attractions;
  }


  public HotelInventoryResponseConsumer places(List<PlaceLocalizedInventoryConsumer> places) {
    
    this.places = places;
    return this;
  }

  public HotelInventoryResponseConsumer addPlacesItem(PlaceLocalizedInventoryConsumer placesItem) {
    if (this.places == null) {
      this.places = new ArrayList<>();
    }
    this.places.add(placesItem);
    return this;
  }

   /**
   * List of property places on and off the premises.
   * @return places
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PlaceLocalizedInventoryConsumer> getPlaces() {
    return places;
  }


  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlaces(List<PlaceLocalizedInventoryConsumer> places) {
    this.places = places;
  }


  public HotelInventoryResponseConsumer metadata(List<MetaDataConsumer> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public HotelInventoryResponseConsumer addMetadataItem(MetaDataConsumer metadataItem) {
    if (this.metadata == null) {
      this.metadata = new ArrayList<>();
    }
    this.metadata.add(metadataItem);
    return this;
  }

   /**
   * List of property meta data.
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MetaDataConsumer> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(List<MetaDataConsumer> metadata) {
    this.metadata = metadata;
  }


  public HotelInventoryResponseConsumer images(List<AbstractSimpleMultimediaConsumer> images) {
    
    this.images = images;
    return this;
  }

  public HotelInventoryResponseConsumer addImagesItem(AbstractSimpleMultimediaConsumer imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

   /**
   * List of property images
   * @return images
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AbstractSimpleMultimediaConsumer> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(List<AbstractSimpleMultimediaConsumer> images) {
    this.images = images;
  }


  public HotelInventoryResponseConsumer videos(List<AbstractSimpleMultimediaConsumer> videos) {
    
    this.videos = videos;
    return this;
  }

  public HotelInventoryResponseConsumer addVideosItem(AbstractSimpleMultimediaConsumer videosItem) {
    if (this.videos == null) {
      this.videos = new ArrayList<>();
    }
    this.videos.add(videosItem);
    return this;
  }

   /**
   * List of property videos
   * @return videos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AbstractSimpleMultimediaConsumer> getVideos() {
    return videos;
  }


  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideos(List<AbstractSimpleMultimediaConsumer> videos) {
    this.videos = videos;
  }


  public HotelInventoryResponseConsumer recognitions(List<RecognitionConsumer> recognitions) {
    
    this.recognitions = recognitions;
    return this;
  }

  public HotelInventoryResponseConsumer addRecognitionsItem(RecognitionConsumer recognitionsItem) {
    if (this.recognitions == null) {
      this.recognitions = new ArrayList<>();
    }
    this.recognitions.add(recognitionsItem);
    return this;
  }

   /**
   * List of property recognitions
   * @return recognitions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RecognitionConsumer> getRecognitions() {
    return recognitions;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitions(List<RecognitionConsumer> recognitions) {
    this.recognitions = recognitions;
  }


  public HotelInventoryResponseConsumer announcements(List<AnnouncementConsumer> announcements) {
    
    this.announcements = announcements;
    return this;
  }

  public HotelInventoryResponseConsumer addAnnouncementsItem(AnnouncementConsumer announcementsItem) {
    if (this.announcements == null) {
      this.announcements = new ArrayList<>();
    }
    this.announcements.add(announcementsItem);
    return this;
  }

   /**
   * List of property announcements
   * @return announcements
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANNOUNCEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AnnouncementConsumer> getAnnouncements() {
    return announcements;
  }


  @JsonProperty(JSON_PROPERTY_ANNOUNCEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnouncements(List<AnnouncementConsumer> announcements) {
    this.announcements = announcements;
  }


  public HotelInventoryResponseConsumer reviews(List<ReviewConsumer> reviews) {
    
    this.reviews = reviews;
    return this;
  }

  public HotelInventoryResponseConsumer addReviewsItem(ReviewConsumer reviewsItem) {
    if (this.reviews == null) {
      this.reviews = new ArrayList<>();
    }
    this.reviews.add(reviewsItem);
    return this;
  }

   /**
   * List of property reviews
   * @return reviews
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReviewConsumer> getReviews() {
    return reviews;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviews(List<ReviewConsumer> reviews) {
    this.reviews = reviews;
  }


  public HotelInventoryResponseConsumer salesChannel(SalesChannelInfoConsumer salesChannel) {
    
    this.salesChannel = salesChannel;
    return this;
  }

   /**
   * Get salesChannel
   * @return salesChannel
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SalesChannelInfoConsumer getSalesChannel() {
    return salesChannel;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSalesChannel(SalesChannelInfoConsumer salesChannel) {
    this.salesChannel = salesChannel;
  }


  public HotelInventoryResponseConsumer bestPrice(RoomTypeWithPriceConfigurationConsumer bestPrice) {
    
    this.bestPrice = bestPrice;
    return this;
  }

   /**
   * Get bestPrice
   * @return bestPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomTypeWithPriceConfigurationConsumer getBestPrice() {
    return bestPrice;
  }


  @JsonProperty(JSON_PROPERTY_BEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBestPrice(RoomTypeWithPriceConfigurationConsumer bestPrice) {
    this.bestPrice = bestPrice;
  }


  public HotelInventoryResponseConsumer available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Get available
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public HotelInventoryResponseConsumer cheapestRoomTypes(List<RoomTypeWithPriceConfigurationConsumer> cheapestRoomTypes) {
    
    this.cheapestRoomTypes = cheapestRoomTypes;
    return this;
  }

  public HotelInventoryResponseConsumer addCheapestRoomTypesItem(RoomTypeWithPriceConfigurationConsumer cheapestRoomTypesItem) {
    if (this.cheapestRoomTypes == null) {
      this.cheapestRoomTypes = new ArrayList<>();
    }
    this.cheapestRoomTypes.add(cheapestRoomTypesItem);
    return this;
  }

   /**
   * Get cheapestRoomTypes
   * @return cheapestRoomTypes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHEAPEST_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomTypeWithPriceConfigurationConsumer> getCheapestRoomTypes() {
    return cheapestRoomTypes;
  }


  @JsonProperty(JSON_PROPERTY_CHEAPEST_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheapestRoomTypes(List<RoomTypeWithPriceConfigurationConsumer> cheapestRoomTypes) {
    this.cheapestRoomTypes = cheapestRoomTypes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelInventoryResponseConsumer hotelInventoryResponseConsumer = (HotelInventoryResponseConsumer) o;
    return Objects.equals(this.hotelIdentifier, hotelInventoryResponseConsumer.hotelIdentifier) &&
        Objects.equals(this.urlName, hotelInventoryResponseConsumer.urlName) &&
        Objects.equals(this.hotel, hotelInventoryResponseConsumer.hotel) &&
        Objects.equals(this.greenIndexScores, hotelInventoryResponseConsumer.greenIndexScores) &&
        Objects.equals(this.roomTypes, hotelInventoryResponseConsumer.roomTypes) &&
        Objects.equals(this.meetingRooms, hotelInventoryResponseConsumer.meetingRooms) &&
        Objects.equals(this.restaurants, hotelInventoryResponseConsumer.restaurants) &&
        Objects.equals(this.spas, hotelInventoryResponseConsumer.spas) &&
        Objects.equals(this.activities, hotelInventoryResponseConsumer.activities) &&
        Objects.equals(this.attractions, hotelInventoryResponseConsumer.attractions) &&
        Objects.equals(this.places, hotelInventoryResponseConsumer.places) &&
        Objects.equals(this.metadata, hotelInventoryResponseConsumer.metadata) &&
        Objects.equals(this.images, hotelInventoryResponseConsumer.images) &&
        Objects.equals(this.videos, hotelInventoryResponseConsumer.videos) &&
        Objects.equals(this.recognitions, hotelInventoryResponseConsumer.recognitions) &&
        Objects.equals(this.announcements, hotelInventoryResponseConsumer.announcements) &&
        Objects.equals(this.reviews, hotelInventoryResponseConsumer.reviews) &&
        Objects.equals(this.salesChannel, hotelInventoryResponseConsumer.salesChannel) &&
        Objects.equals(this.bestPrice, hotelInventoryResponseConsumer.bestPrice) &&
        Objects.equals(this.available, hotelInventoryResponseConsumer.available) &&
        Objects.equals(this.cheapestRoomTypes, hotelInventoryResponseConsumer.cheapestRoomTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, urlName, hotel, greenIndexScores, roomTypes, meetingRooms, restaurants, spas, activities, attractions, places, metadata, images, videos, recognitions, announcements, reviews, salesChannel, bestPrice, available, cheapestRoomTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelInventoryResponseConsumer {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    greenIndexScores: ").append(toIndentedString(greenIndexScores)).append("\n");
    sb.append("    roomTypes: ").append(toIndentedString(roomTypes)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    activities: ").append(toIndentedString(activities)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    places: ").append(toIndentedString(places)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    videos: ").append(toIndentedString(videos)).append("\n");
    sb.append("    recognitions: ").append(toIndentedString(recognitions)).append("\n");
    sb.append("    announcements: ").append(toIndentedString(announcements)).append("\n");
    sb.append("    reviews: ").append(toIndentedString(reviews)).append("\n");
    sb.append("    salesChannel: ").append(toIndentedString(salesChannel)).append("\n");
    sb.append("    bestPrice: ").append(toIndentedString(bestPrice)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    cheapestRoomTypes: ").append(toIndentedString(cheapestRoomTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

