/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.7.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.LocalizedDescriptionConsumer;
import travel.wink.sdk.inventory.model.LocalizedPriceConsumer;
import travel.wink.sdk.inventory.model.SimpleDescriptionConsumer;
import travel.wink.sdk.inventory.model.SimpleMultimediaConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * This is one localized bookable item that can stand alongside a restaurant / meeting room etc.
 */
@JsonPropertyOrder({
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_IDENTIFIER,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_NAME,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_DESCRIPTIONS,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_PRICING_TYPE,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_PRICE,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_MULTIMEDIAS,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_MIN_PAX,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_MAX_PAX,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_OFFER_DETAILS,
  LocalizedTransactionalTravelInventoryConsumer.JSON_PROPERTY_PROMOTION
})
@JsonTypeName("LocalizedTransactionalTravelInventory_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-17T14:17:28.917189324+07:00[Asia/Bangkok]")
public class LocalizedTransactionalTravelInventoryConsumer {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionConsumer> descriptions = new ArrayList<>();

  /**
   * How this inventory item should be priced.
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_PRICE = "price";
  private LocalizedPriceConsumer price;

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaConsumer> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_MIN_PAX = "minPax";
  private Integer minPax;

  public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
  private Integer maxPax;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<LocalizedDescriptionConsumer> offerDetails = new ArrayList<>();

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private String promotion;

  public LocalizedTransactionalTravelInventoryConsumer() {
  }

  public LocalizedTransactionalTravelInventoryConsumer identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique transactional identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public LocalizedTransactionalTravelInventoryConsumer name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of transactional inventory.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public LocalizedTransactionalTravelInventoryConsumer descriptions(List<SimpleDescriptionConsumer> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public LocalizedTransactionalTravelInventoryConsumer addDescriptionsItem(SimpleDescriptionConsumer descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionConsumer> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionConsumer> descriptions) {
    this.descriptions = descriptions;
  }


  public LocalizedTransactionalTravelInventoryConsumer pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * How this inventory item should be priced.
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public LocalizedTransactionalTravelInventoryConsumer price(LocalizedPriceConsumer price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalizedPriceConsumer getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(LocalizedPriceConsumer price) {
    this.price = price;
  }


  public LocalizedTransactionalTravelInventoryConsumer multimedias(List<SimpleMultimediaConsumer> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public LocalizedTransactionalTravelInventoryConsumer addMultimediasItem(SimpleMultimediaConsumer multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of item.
   * @return multimedias
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaConsumer> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimedias(List<SimpleMultimediaConsumer> multimedias) {
    this.multimedias = multimedias;
  }


  public LocalizedTransactionalTravelInventoryConsumer minPax(Integer minPax) {
    
    this.minPax = minPax;
    return this;
  }

   /**
   * Whether there is a limit to minimum group size.
   * @return minPax
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinPax() {
    return minPax;
  }


  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinPax(Integer minPax) {
    this.minPax = minPax;
  }


  public LocalizedTransactionalTravelInventoryConsumer maxPax(Integer maxPax) {
    
    this.maxPax = maxPax;
    return this;
  }

   /**
   * Whether there is a limit to maximum group size.
   * @return maxPax
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxPax() {
    return maxPax;
  }


  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxPax(Integer maxPax) {
    this.maxPax = maxPax;
  }


  public LocalizedTransactionalTravelInventoryConsumer offerDetails(List<LocalizedDescriptionConsumer> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public LocalizedTransactionalTravelInventoryConsumer addOfferDetailsItem(LocalizedDescriptionConsumer offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Localized offer details if rate plan discount applies.
   * @return offerDetails
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionConsumer> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<LocalizedDescriptionConsumer> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public LocalizedTransactionalTravelInventoryConsumer promotion(String promotion) {
    
    this.promotion = promotion;
    return this;
  }

   /**
   * If a package is linked to a rate plan the user could be entitled to a promotional discount if she enters a code. When this field is populated, it means the discount was applied to the package.
   * @return promotion
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(String promotion) {
    this.promotion = promotion;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LocalizedTransactionalTravelInventoryConsumer localizedTransactionalTravelInventoryConsumer = (LocalizedTransactionalTravelInventoryConsumer) o;
    return Objects.equals(this.identifier, localizedTransactionalTravelInventoryConsumer.identifier) &&
        Objects.equals(this.name, localizedTransactionalTravelInventoryConsumer.name) &&
        Objects.equals(this.descriptions, localizedTransactionalTravelInventoryConsumer.descriptions) &&
        Objects.equals(this.pricingType, localizedTransactionalTravelInventoryConsumer.pricingType) &&
        Objects.equals(this.price, localizedTransactionalTravelInventoryConsumer.price) &&
        Objects.equals(this.multimedias, localizedTransactionalTravelInventoryConsumer.multimedias) &&
        Objects.equals(this.minPax, localizedTransactionalTravelInventoryConsumer.minPax) &&
        Objects.equals(this.maxPax, localizedTransactionalTravelInventoryConsumer.maxPax) &&
        Objects.equals(this.offerDetails, localizedTransactionalTravelInventoryConsumer.offerDetails) &&
        Objects.equals(this.promotion, localizedTransactionalTravelInventoryConsumer.promotion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, descriptions, pricingType, price, multimedias, minPax, maxPax, offerDetails, promotion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LocalizedTransactionalTravelInventoryConsumer {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    minPax: ").append(toIndentedString(minPax)).append("\n");
    sb.append("    maxPax: ").append(toIndentedString(maxPax)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

