/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import travel.wink.sdk.lookup.model.SearchFiltersNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.UserSessionNonAuthenticatedEntity;

@JsonPropertyOrder(value={"countryCode", "sort", "userSession", "searchFilters", "page", "size"})
@JsonTypeName(value="CountryScoreRequest_Non_Authenticated_Entity")
public class CountryScoreRequestNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private SortEnum sort;
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSessionNonAuthenticatedEntity userSession;
    public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
    private SearchFiltersNonAuthenticatedEntity searchFilters;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size = 6;

    public CountryScoreRequestNonAuthenticatedEntity countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public CountryScoreRequestNonAuthenticatedEntity sort(SortEnum sort) {
        this.sort = sort;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SortEnum getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSort(SortEnum sort) {
        this.sort = sort;
    }

    public CountryScoreRequestNonAuthenticatedEntity userSession(UserSessionNonAuthenticatedEntity userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSessionNonAuthenticatedEntity getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSessionNonAuthenticatedEntity userSession) {
        this.userSession = userSession;
    }

    public CountryScoreRequestNonAuthenticatedEntity searchFilters(SearchFiltersNonAuthenticatedEntity searchFilters) {
        this.searchFilters = searchFilters;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchFiltersNonAuthenticatedEntity getSearchFilters() {
        return this.searchFilters;
    }

    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchFilters(SearchFiltersNonAuthenticatedEntity searchFilters) {
        this.searchFilters = searchFilters;
    }

    public CountryScoreRequestNonAuthenticatedEntity page(Integer page) {
        this.page = page;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public CountryScoreRequestNonAuthenticatedEntity size(Integer size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @Max(value=50L)
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=50L) Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity = (CountryScoreRequestNonAuthenticatedEntity)o;
        return Objects.equals(this.countryCode, countryScoreRequestNonAuthenticatedEntity.countryCode) && Objects.equals((Object)this.sort, (Object)countryScoreRequestNonAuthenticatedEntity.sort) && Objects.equals(this.userSession, countryScoreRequestNonAuthenticatedEntity.userSession) && Objects.equals(this.searchFilters, countryScoreRequestNonAuthenticatedEntity.searchFilters) && Objects.equals(this.page, countryScoreRequestNonAuthenticatedEntity.page) && Objects.equals(this.size, countryScoreRequestNonAuthenticatedEntity.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.countryCode, this.sort, this.userSession, this.searchFilters, this.page, this.size});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CountryScoreRequestNonAuthenticatedEntity {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString((Object)this.sort)).append("\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    searchFilters: ").append(this.toIndentedString(this.searchFilters)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SortEnum {
        MEMBER("MEMBER"),
        PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
        PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
        PRICE("PRICE"),
        POPULARITY("POPULARITY"),
        ECO("ECO"),
        EXPERIENCE("EXPERIENCE"),
        PERK("PERK"),
        LOYALTY("LOYALTY"),
        PACKAGE("PACKAGE");

        private String value;

        private SortEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortEnum fromValue(String value) {
            for (SortEnum b : SortEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

