/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel blocking on the Wink platform. The API gives you all the tools you need to ready your properties and blocking for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel blocking and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel blocking and get that same blocking out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel blocking and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating blocking by region, locale and property flags.  - [Inventory](/blocking): All APIs related to retrieve known travel blocking as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel blocking.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and blocking calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and blocking to sell.  - [Inventory](/affiliate/blocking): The Inventory API exposes endpoints for affiliates to manage the blocking they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel blocking and need taxonomies of standard and non-standard codes for blocking types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel blocking. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Lookup API The Lookup API exposes endpoints to search for blocking by region, type. It's the entryway to bookable blocking when you don't yet know what you are looking for.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.7.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.lookup.model.GeoJsonPointNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * LookupNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  LookupNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_TYPE,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_TYPE_IDENTIFIER,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_NAME,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_URL_NAME,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_OWNER_IDENTIFIER,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_OWNER_NAME,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_CITY_NAME,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY_NAME,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_SUB_COUNTRY_NAME,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_SUB_SUB_COUNTRY_NAME,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY_CODE,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_OWNER_TYPE,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_LANGUAGE_CODE,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_ORIGIN,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_LOWERCASE_NAME,
  LookupNonAuthenticatedEntity.JSON_PROPERTY_LOCATION
})
@JsonTypeName("Lookup_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-11-04T20:30:38.486457190+07:00[Asia/Bangkok]")
public class LookupNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  /**
   * Type of lookup
   */
  public enum TypeEnum {
    CITY("CITY"),
    
    ISLAND("ISLAND"),
    
    HOTEL("HOTEL"),
    
    SPA("SPA"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE"),
    
    COUNTRY("COUNTRY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
  private UUID typeIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_SUB_COUNTRY_NAME = "subCountryName";
  private String subCountryName;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY_NAME = "subSubCountryName";
  private String subSubCountryName;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  /**
   * The type of owner that created this lookup
   */
  public enum OwnerTypeEnum {
    TRAVELIKO("TRAVELIKO"),
    
    HOTEL("HOTEL");

    private String value;

    OwnerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OwnerTypeEnum fromValue(String value) {
      for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_LANGUAGE_CODE = "languageCode";
  private String languageCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private Boolean origin;

  public static final String JSON_PROPERTY_LOWERCASE_NAME = "lowercaseName";
  private String lowercaseName;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointNonAuthenticatedEntity location;

  public LookupNonAuthenticatedEntity() {
  }

  public LookupNonAuthenticatedEntity identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique lookup identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public LookupNonAuthenticatedEntity type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of lookup
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public LookupNonAuthenticatedEntity typeIdentifier(UUID typeIdentifier) {
    
    this.typeIdentifier = typeIdentifier;
    return this;
  }

   /**
   * Unique lookup type identifier
   * @return typeIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getTypeIdentifier() {
    return typeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTypeIdentifier(UUID typeIdentifier) {
    this.typeIdentifier = typeIdentifier;
  }


  public LookupNonAuthenticatedEntity name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of lookup
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public LookupNonAuthenticatedEntity urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Url-friendly slug that uniquely identifies this lookup
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public LookupNonAuthenticatedEntity ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Lookup that is supplier blocking includes the supplier identifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public LookupNonAuthenticatedEntity ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Lookup that is supplier blocking includes the supplier name
   * @return ownerName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public LookupNonAuthenticatedEntity cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * Closest city where lookup entry is located
   * @return cityName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public LookupNonAuthenticatedEntity countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country where lookup entry is located
   * @return countryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public LookupNonAuthenticatedEntity subCountryName(String subCountryName) {
    
    this.subCountryName = subCountryName;
    return this;
  }

   /**
   * State where lookup entry is located
   * @return subCountryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubCountryName() {
    return subCountryName;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountryName(String subCountryName) {
    this.subCountryName = subCountryName;
  }


  public LookupNonAuthenticatedEntity subSubCountryName(String subSubCountryName) {
    
    this.subSubCountryName = subSubCountryName;
    return this;
  }

   /**
   * County where lookup entry is located
   * @return subSubCountryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubSubCountryName() {
    return subSubCountryName;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountryName(String subSubCountryName) {
    this.subSubCountryName = subSubCountryName;
  }


  public LookupNonAuthenticatedEntity countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Country code
   * @return countryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public LookupNonAuthenticatedEntity ownerType(OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

   /**
   * The type of owner that created this lookup
   * @return ownerType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerType(OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }


  public LookupNonAuthenticatedEntity languageCode(String languageCode) {
    
    this.languageCode = languageCode;
    return this;
  }

   /**
   * The language the lookup code was written in
   * @return languageCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguageCode() {
    return languageCode;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguageCode(String languageCode) {
    this.languageCode = languageCode;
  }


  public LookupNonAuthenticatedEntity sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Platform-specific sort
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public LookupNonAuthenticatedEntity origin(Boolean origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * If this lookup is the origin lookup.
   * @return origin
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(Boolean origin) {
    this.origin = origin;
  }


  public LookupNonAuthenticatedEntity lowercaseName(String lowercaseName) {
    
    this.lowercaseName = lowercaseName;
    return this;
  }

   /**
   * Name in lower case
   * @return lowercaseName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOWERCASE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLowercaseName() {
    return lowercaseName;
  }


  @JsonProperty(JSON_PROPERTY_LOWERCASE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLowercaseName(String lowercaseName) {
    this.lowercaseName = lowercaseName;
  }


  public LookupNonAuthenticatedEntity location(GeoJsonPointNonAuthenticatedEntity location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointNonAuthenticatedEntity getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointNonAuthenticatedEntity location) {
    this.location = location;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LookupNonAuthenticatedEntity lookupNonAuthenticatedEntity = (LookupNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, lookupNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.type, lookupNonAuthenticatedEntity.type) &&
        Objects.equals(this.typeIdentifier, lookupNonAuthenticatedEntity.typeIdentifier) &&
        Objects.equals(this.name, lookupNonAuthenticatedEntity.name) &&
        Objects.equals(this.urlName, lookupNonAuthenticatedEntity.urlName) &&
        Objects.equals(this.ownerIdentifier, lookupNonAuthenticatedEntity.ownerIdentifier) &&
        Objects.equals(this.ownerName, lookupNonAuthenticatedEntity.ownerName) &&
        Objects.equals(this.cityName, lookupNonAuthenticatedEntity.cityName) &&
        Objects.equals(this.countryName, lookupNonAuthenticatedEntity.countryName) &&
        Objects.equals(this.subCountryName, lookupNonAuthenticatedEntity.subCountryName) &&
        Objects.equals(this.subSubCountryName, lookupNonAuthenticatedEntity.subSubCountryName) &&
        Objects.equals(this.countryCode, lookupNonAuthenticatedEntity.countryCode) &&
        Objects.equals(this.ownerType, lookupNonAuthenticatedEntity.ownerType) &&
        Objects.equals(this.languageCode, lookupNonAuthenticatedEntity.languageCode) &&
        Objects.equals(this.sort, lookupNonAuthenticatedEntity.sort) &&
        Objects.equals(this.origin, lookupNonAuthenticatedEntity.origin) &&
        Objects.equals(this.lowercaseName, lookupNonAuthenticatedEntity.lowercaseName) &&
        Objects.equals(this.location, lookupNonAuthenticatedEntity.location);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, type, typeIdentifier, name, urlName, ownerIdentifier, ownerName, cityName, countryName, subCountryName, subSubCountryName, countryCode, ownerType, languageCode, sort, origin, lowercaseName, location);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LookupNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    typeIdentifier: ").append(toIndentedString(typeIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    subCountryName: ").append(toIndentedString(subCountryName)).append("\n");
    sb.append("    subSubCountryName: ").append(toIndentedString(subSubCountryName)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    languageCode: ").append(toIndentedString(languageCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    lowercaseName: ").append(toIndentedString(lowercaseName)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

