/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.lookup.invoker.ApiClient;
import travel.wink.sdk.lookup.model.AgencyScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CityScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CitySearchRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CountryScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.GlobalScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.HotelPerCountryCountNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LookupCachedNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LookupNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.MapRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.PageHotelWithBestPriceNonAuthenticatedEntity;

public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec scoreInventoryByAgencyRequestCreation(AgencyScoreRequestNonAuthenticatedEntity agencyScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        AgencyScoreRequestNonAuthenticatedEntity postBody = agencyScoreRequestNonAuthenticatedEntity;
        if (agencyScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'agencyScoreRequestNonAuthenticatedEntity' when calling scoreInventoryByAgency", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/ranked/search/agency", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> scoreInventoryByAgency(AgencyScoreRequestNonAuthenticatedEntity agencyScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.scoreInventoryByAgencyRequestCreation(agencyScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> scoreInventoryByAgencyWithHttpInfo(AgencyScoreRequestNonAuthenticatedEntity agencyScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.scoreInventoryByAgencyRequestCreation(agencyScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec scoreInventoryByAgencyWithResponseSpec(AgencyScoreRequestNonAuthenticatedEntity agencyScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.scoreInventoryByAgencyRequestCreation(agencyScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec scoreInventoryByCityRequestCreation(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        CityScoreRequestNonAuthenticatedEntity postBody = cityScoreRequestNonAuthenticatedEntity;
        if (cityScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequestNonAuthenticatedEntity' when calling scoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> scoreInventoryByCity(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.scoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> scoreInventoryByCityWithHttpInfo(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.scoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec scoreInventoryByCityWithResponseSpec(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.scoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchByGeoLocationRequestCreation(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        MapRequestNonAuthenticatedEntity postBody = mapRequestNonAuthenticatedEntity;
        if (mapRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequestNonAuthenticatedEntity' when calling searchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> searchByGeoLocation(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.searchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> searchByGeoLocationWithHttpInfo(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.searchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchByGeoLocationWithResponseSpec(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.searchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchInventoryByCityRequestCreation(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        CitySearchRequestNonAuthenticatedEntity postBody = citySearchRequestNonAuthenticatedEntity;
        if (citySearchRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequestNonAuthenticatedEntity' when calling searchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> searchInventoryByCity(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.searchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> searchInventoryByCityWithHttpInfo(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.searchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchInventoryByCityWithResponseSpec(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.searchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchScoreByCountryRequestCreation(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        CountryScoreRequestNonAuthenticatedEntity postBody = countryScoreRequestNonAuthenticatedEntity;
        if (countryScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequestNonAuthenticatedEntity' when calling searchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> searchScoreByCountry(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.searchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> searchScoreByCountryWithHttpInfo(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.searchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchScoreByCountryWithResponseSpec(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.searchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchScoreByGlobalRequestCreation(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        GlobalScoreRequestNonAuthenticatedEntity postBody = globalScoreRequestNonAuthenticatedEntity;
        if (globalScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequestNonAuthenticatedEntity' when calling searchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> searchScoreByGlobal(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.searchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> searchScoreByGlobalWithHttpInfo(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.searchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchScoreByGlobalWithResponseSpec(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.searchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchSuggestionsRequestCreation(String term, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling searchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "term", term));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<LookupCachedNonAuthenticatedEntity> searchSuggestions(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>(this){};
        return this.searchSuggestionsRequestCreation(term, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<LookupCachedNonAuthenticatedEntity>>> searchSuggestionsWithHttpInfo(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>(this){};
        return this.searchSuggestionsRequestCreation(term, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchSuggestionsWithResponseSpec(String term, String winkVersion, String accept) throws WebClientResponseException {
        return this.searchSuggestionsRequestCreation(term, winkVersion, accept);
    }

    private WebClient.ResponseSpec showHotelAggregatePerCountryRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/property/aggregate-per-country", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<HotelPerCountryCountNonAuthenticatedEntity> showHotelAggregatePerCountry(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity>(this){};
        return this.showHotelAggregatePerCountryRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<HotelPerCountryCountNonAuthenticatedEntity>>> showHotelAggregatePerCountryWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity>(this){};
        return this.showHotelAggregatePerCountryRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelAggregatePerCountryWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showHotelAggregatePerCountryRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showLookupRequestCreation(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling showLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling showLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("urlName", urlName);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<LookupNonAuthenticatedEntity> showLookup(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>(this){};
        return this.showLookupRequestCreation(urlName, type, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<LookupNonAuthenticatedEntity>> showLookupWithHttpInfo(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>(this){};
        return this.showLookupRequestCreation(urlName, type, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLookupWithResponseSpec(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        return this.showLookupRequestCreation(urlName, type, winkVersion, accept);
    }
}

