/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.lookup.model.GeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.GeoJsonPolygonNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.SearchFiltersNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.UserSessionNonAuthenticatedEntity;

@JsonPropertyOrder(value={"userSession", "location", "bounds", "searchFilters", "inventoryTypes", "page", "size"})
@JsonTypeName(value="MapRequest_Non_Authenticated_Entity")
public class MapRequestNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSessionNonAuthenticatedEntity userSession;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointNonAuthenticatedEntity location;
    public static final String JSON_PROPERTY_BOUNDS = "bounds";
    private GeoJsonPolygonNonAuthenticatedEntity bounds;
    public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
    private SearchFiltersNonAuthenticatedEntity searchFilters;
    public static final String JSON_PROPERTY_INVENTORY_TYPES = "inventoryTypes";
    private List<InventoryTypesEnum> inventoryTypes;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size = 10;

    public MapRequestNonAuthenticatedEntity userSession(UserSessionNonAuthenticatedEntity userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSessionNonAuthenticatedEntity getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSessionNonAuthenticatedEntity userSession) {
        this.userSession = userSession;
    }

    public MapRequestNonAuthenticatedEntity location(GeoJsonPointNonAuthenticatedEntity location) {
        this.location = location;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPointNonAuthenticatedEntity getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(GeoJsonPointNonAuthenticatedEntity location) {
        this.location = location;
    }

    public MapRequestNonAuthenticatedEntity bounds(GeoJsonPolygonNonAuthenticatedEntity bounds) {
        this.bounds = bounds;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPolygonNonAuthenticatedEntity getBounds() {
        return this.bounds;
    }

    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBounds(GeoJsonPolygonNonAuthenticatedEntity bounds) {
        this.bounds = bounds;
    }

    public MapRequestNonAuthenticatedEntity searchFilters(SearchFiltersNonAuthenticatedEntity searchFilters) {
        this.searchFilters = searchFilters;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchFiltersNonAuthenticatedEntity getSearchFilters() {
        return this.searchFilters;
    }

    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchFilters(SearchFiltersNonAuthenticatedEntity searchFilters) {
        this.searchFilters = searchFilters;
    }

    public MapRequestNonAuthenticatedEntity inventoryTypes(List<InventoryTypesEnum> inventoryTypes) {
        this.inventoryTypes = inventoryTypes;
        return this;
    }

    public MapRequestNonAuthenticatedEntity addInventoryTypesItem(InventoryTypesEnum inventoryTypesItem) {
        if (this.inventoryTypes == null) {
            this.inventoryTypes = new ArrayList<InventoryTypesEnum>();
        }
        this.inventoryTypes.add(inventoryTypesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="inventoryTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InventoryTypesEnum> getInventoryTypes() {
        return this.inventoryTypes;
    }

    @JsonProperty(value="inventoryTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInventoryTypes(List<InventoryTypesEnum> inventoryTypes) {
        this.inventoryTypes = inventoryTypes;
    }

    public MapRequestNonAuthenticatedEntity page(Integer page) {
        this.page = page;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public MapRequestNonAuthenticatedEntity size(Integer size) {
        this.size = size;
        return this;
    }

    @Nullable
    @Min(value=1L)
    @Max(value=20L)
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=1L) @Max(value=20L) Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity = (MapRequestNonAuthenticatedEntity)o;
        return Objects.equals(this.userSession, mapRequestNonAuthenticatedEntity.userSession) && Objects.equals(this.location, mapRequestNonAuthenticatedEntity.location) && Objects.equals(this.bounds, mapRequestNonAuthenticatedEntity.bounds) && Objects.equals(this.searchFilters, mapRequestNonAuthenticatedEntity.searchFilters) && Objects.equals(this.inventoryTypes, mapRequestNonAuthenticatedEntity.inventoryTypes) && Objects.equals(this.page, mapRequestNonAuthenticatedEntity.page) && Objects.equals(this.size, mapRequestNonAuthenticatedEntity.size);
    }

    public int hashCode() {
        return Objects.hash(this.userSession, this.location, this.bounds, this.searchFilters, this.inventoryTypes, this.page, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MapRequestNonAuthenticatedEntity {\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    searchFilters: ").append(this.toIndentedString(this.searchFilters)).append("\n");
        sb.append("    inventoryTypes: ").append(this.toIndentedString(this.inventoryTypes)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InventoryTypesEnum {
        GUEST_ROOM("GUEST_ROOM"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE"),
        ACTIVITY("ACTIVITY");

        private String value;

        private InventoryTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryTypesEnum fromValue(String value) {
            for (InventoryTypesEnum b : InventoryTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

