package travel.wink.sdk.lookup.api;

import travel.wink.sdk.lookup.invoker.ApiClient;

import travel.wink.sdk.lookup.model.AgencyScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CityScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CitySearchRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CountryScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.GenericErrorMessage;
import travel.wink.sdk.lookup.model.GlobalScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.HotelPerCountryCountNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LookupCachedNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LookupNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.MapRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.PageHotelWithBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.SearchByGeoLocation400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-03T15:00:59.079277963+07:00[Asia/Bangkok]")
public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Ranked Agency Search
     * Search for hotels represented by a property management agency.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param agencyScoreRequestNonAuthenticatedEntity The agencyScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec scoreInventoryByAgencyRequestCreation(AgencyScoreRequestNonAuthenticatedEntity agencyScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = agencyScoreRequestNonAuthenticatedEntity;
        // verify the required parameter 'agencyScoreRequestNonAuthenticatedEntity' is set
        if (agencyScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'agencyScoreRequestNonAuthenticatedEntity' when calling scoreInventoryByAgency", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/ranked/search/agency", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Agency Search
     * Search for hotels represented by a property management agency.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param agencyScoreRequestNonAuthenticatedEntity The agencyScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> scoreInventoryByAgency(AgencyScoreRequestNonAuthenticatedEntity agencyScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return scoreInventoryByAgencyRequestCreation(agencyScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked Agency Search
     * Search for hotels represented by a property management agency.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param agencyScoreRequestNonAuthenticatedEntity The agencyScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> scoreInventoryByAgencyWithHttpInfo(AgencyScoreRequestNonAuthenticatedEntity agencyScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return scoreInventoryByAgencyRequestCreation(agencyScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Ranked Agency Search
     * Search for hotels represented by a property management agency.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param agencyScoreRequestNonAuthenticatedEntity The agencyScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec scoreInventoryByAgencyWithResponseSpec(AgencyScoreRequestNonAuthenticatedEntity agencyScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return scoreInventoryByAgencyRequestCreation(agencyScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param cityScoreRequestNonAuthenticatedEntity The cityScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec scoreInventoryByCityRequestCreation(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = cityScoreRequestNonAuthenticatedEntity;
        // verify the required parameter 'cityScoreRequestNonAuthenticatedEntity' is set
        if (cityScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequestNonAuthenticatedEntity' when calling scoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param cityScoreRequestNonAuthenticatedEntity The cityScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> scoreInventoryByCity(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return scoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param cityScoreRequestNonAuthenticatedEntity The cityScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> scoreInventoryByCityWithHttpInfo(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return scoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param cityScoreRequestNonAuthenticatedEntity The cityScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec scoreInventoryByCityWithResponseSpec(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return scoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param mapRequestNonAuthenticatedEntity The mapRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchByGeoLocationRequestCreation(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = mapRequestNonAuthenticatedEntity;
        // verify the required parameter 'mapRequestNonAuthenticatedEntity' is set
        if (mapRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequestNonAuthenticatedEntity' when calling searchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param mapRequestNonAuthenticatedEntity The mapRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> searchByGeoLocation(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return searchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param mapRequestNonAuthenticatedEntity The mapRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> searchByGeoLocationWithHttpInfo(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return searchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param mapRequestNonAuthenticatedEntity The mapRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchByGeoLocationWithResponseSpec(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return searchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param citySearchRequestNonAuthenticatedEntity The citySearchRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchInventoryByCityRequestCreation(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = citySearchRequestNonAuthenticatedEntity;
        // verify the required parameter 'citySearchRequestNonAuthenticatedEntity' is set
        if (citySearchRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequestNonAuthenticatedEntity' when calling searchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param citySearchRequestNonAuthenticatedEntity The citySearchRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> searchInventoryByCity(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return searchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param citySearchRequestNonAuthenticatedEntity The citySearchRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> searchInventoryByCityWithHttpInfo(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return searchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param citySearchRequestNonAuthenticatedEntity The citySearchRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchInventoryByCityWithResponseSpec(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return searchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param countryScoreRequestNonAuthenticatedEntity The countryScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchScoreByCountryRequestCreation(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = countryScoreRequestNonAuthenticatedEntity;
        // verify the required parameter 'countryScoreRequestNonAuthenticatedEntity' is set
        if (countryScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequestNonAuthenticatedEntity' when calling searchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param countryScoreRequestNonAuthenticatedEntity The countryScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> searchScoreByCountry(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return searchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param countryScoreRequestNonAuthenticatedEntity The countryScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> searchScoreByCountryWithHttpInfo(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return searchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param countryScoreRequestNonAuthenticatedEntity The countryScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchScoreByCountryWithResponseSpec(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return searchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param globalScoreRequestNonAuthenticatedEntity The globalScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchScoreByGlobalRequestCreation(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = globalScoreRequestNonAuthenticatedEntity;
        // verify the required parameter 'globalScoreRequestNonAuthenticatedEntity' is set
        if (globalScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequestNonAuthenticatedEntity' when calling searchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param globalScoreRequestNonAuthenticatedEntity The globalScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> searchScoreByGlobal(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return searchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param globalScoreRequestNonAuthenticatedEntity The globalScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> searchScoreByGlobalWithHttpInfo(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return searchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param globalScoreRequestNonAuthenticatedEntity The globalScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchScoreByGlobalWithResponseSpec(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return searchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;LookupCachedNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchSuggestionsRequestCreation(String term, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'term' is set
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling searchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "term", term));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;LookupCachedNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LookupCachedNonAuthenticatedEntity> searchSuggestions(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>() {};
        return searchSuggestionsRequestCreation(term, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;LookupCachedNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<LookupCachedNonAuthenticatedEntity>>> searchSuggestionsWithHttpInfo(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>() {};
        return searchSuggestionsRequestCreation(term, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchSuggestionsWithResponseSpec(String term, String winkVersion, String accept) throws WebClientResponseException {
        return searchSuggestionsRequestCreation(term, winkVersion, accept);
    }
    /**
     * Aggregate Properties by Country
     * Show property count by country.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;HotelPerCountryCountNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelAggregatePerCountryRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/property/aggregate-per-country", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Aggregate Properties by Country
     * Show property count by country.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;HotelPerCountryCountNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<HotelPerCountryCountNonAuthenticatedEntity> showHotelAggregatePerCountry(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity>() {};
        return showHotelAggregatePerCountryRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Aggregate Properties by Country
     * Show property count by country.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;HotelPerCountryCountNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<HotelPerCountryCountNonAuthenticatedEntity>>> showHotelAggregatePerCountryWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelPerCountryCountNonAuthenticatedEntity>() {};
        return showHotelAggregatePerCountryRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Aggregate Properties by Country
     * Show property count by country.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelAggregatePerCountryWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showHotelAggregatePerCountryRequestCreation(winkVersion, accept);
    }
    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return LookupNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLookupRequestCreation(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'urlName' is set
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling showLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling showLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("urlName", urlName);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return LookupNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<LookupNonAuthenticatedEntity> showLookup(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>() {};
        return showLookupRequestCreation(urlName, type, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;LookupNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<LookupNonAuthenticatedEntity>> showLookupWithHttpInfo(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>() {};
        return showLookupRequestCreation(urlName, type, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLookupWithResponseSpec(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        return showLookupRequestCreation(urlName, type, winkVersion, accept);
    }
}
