/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Lookup API The Lookup API exposes endpoints to search for inventory by region, type. It's the entryway to bookable inventory when you don't yet know what you are looking for.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.16.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.lookup.model.GeneralManagerNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.GeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LocalizedDescriptionNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.PropertyPolicyNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.SimpleAddressNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.SimpleMultimediaNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.SocialNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.TravelInventoryRecognitionNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Property details
 */
@JsonPropertyOrder({
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_NAME,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_LOCAL_NAME,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_CHAIN,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_BRAND,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_URL_NAME,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_STAR_RATING,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_BOOKINGS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_AGGREGATE_REVIEW_RATING,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_LOCATION,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_SHORT_DESCRIPTIONS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_LONG_DESCRIPTIONS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_AGGREGATE_GREENDEX_RATING,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_LIFESTYLE_TYPES,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_TOTAL_REVIEWS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_SOCIALS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_IMAGES,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_VIDEOS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_POLICY,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_THIRD_PARTY_REVIEWS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_ATTRACTIONS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_RECREATIONS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_POIS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_RESTAURANTS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_MEETING_ROOMS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_SPAS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_ADD_ONS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_GENERAL_MANAGER,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_LOCATION_CATEGORY,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_SEGMENT_CATEGORY,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_CATEGORY,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_WHEN_BUILT,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_CURRENCY_CODE,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_PRICE_SCORE,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_PERK_SCORE,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_PACKAGE_SCORE,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_LOYALTY_SCORE,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_POPULAR_SCORE,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_EXPERIENCE_SCORE,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_AMENITY_CODES,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_PROPERTY_SECURITY_CODES,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_NUMBER_OF_ROOMS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_ADDRESS,
  HotelOnMapLightweightNonAuthenticatedEntity.JSON_PROPERTY_ACTIVE
})
@JsonTypeName("HotelOnMapLightweight_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-03T15:00:59.079277963+07:00[Asia/Bangkok]")
public class HotelOnMapLightweightNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_CHAIN = "chain";
  private String chain;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  private Integer starRating;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  private Long bookings = 0l;

  public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
  private Float aggregateReviewRating = 0.0f;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointNonAuthenticatedEntity location;

  public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
  private List<LocalizedDescriptionNonAuthenticatedEntity> shortDescriptions;

  public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
  private List<LocalizedDescriptionNonAuthenticatedEntity> longDescriptions;

  public static final String JSON_PROPERTY_AGGREGATE_GREENDEX_RATING = "aggregateGreendexRating";
  private Float aggregateGreendexRating = 0.0f;

  /**
   * A list of lifestyles the property associates with.
   */
  public enum LifestyleTypesEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypesEnum fromValue(String value) {
      for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
  private List<LifestyleTypesEnum> lifestyleTypes;

  public static final String JSON_PROPERTY_TOTAL_REVIEWS = "totalReviews";
  private Integer totalReviews = 0;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialNonAuthenticatedEntity> socials;

  public static final String JSON_PROPERTY_IMAGES = "images";
  private List<SimpleMultimediaNonAuthenticatedEntity> images;

  public static final String JSON_PROPERTY_VIDEOS = "videos";
  private List<SimpleMultimediaNonAuthenticatedEntity> videos;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicyNonAuthenticatedEntity policy;

  public static final String JSON_PROPERTY_THIRD_PARTY_REVIEWS = "thirdPartyReviews";
  private List<TravelInventoryRecognitionNonAuthenticatedEntity> thirdPartyReviews;

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private Integer attractions = 0;

  public static final String JSON_PROPERTY_RECREATIONS = "recreations";
  private Integer recreations = 0;

  public static final String JSON_PROPERTY_POIS = "pois";
  private Integer pois = 0;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private Integer restaurants = 0;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private Integer meetingRooms = 0;

  public static final String JSON_PROPERTY_SPAS = "spas";
  private Integer spas = 0;

  public static final String JSON_PROPERTY_ADD_ONS = "addOns";
  private Integer addOns = 0;

  public static final String JSON_PROPERTY_GENERAL_MANAGER = "generalManager";
  private GeneralManagerNonAuthenticatedEntity generalManager;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT = "membershipRateDiscount";
  private Float membershipRateDiscount = 0f;

  public static final String JSON_PROPERTY_PRICE_SCORE = "priceScore";
  private Integer priceScore = 0;

  public static final String JSON_PROPERTY_PERK_SCORE = "perkScore";
  private Integer perkScore = 0;

  public static final String JSON_PROPERTY_PACKAGE_SCORE = "packageScore";
  private Integer packageScore = 0;

  public static final String JSON_PROPERTY_LOYALTY_SCORE = "loyaltyScore";
  private Integer loyaltyScore = 0;

  public static final String JSON_PROPERTY_POPULAR_SCORE = "popularScore";
  private Integer popularScore = 0;

  public static final String JSON_PROPERTY_EXPERIENCE_SCORE = "experienceScore";
  private Integer experienceScore = 0;

  public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
  private List<String> hotelAmenityCodes;

  public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
  private List<String> propertyAccessibilityCodes;

  public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
  private List<String> propertySecurityCodes;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms = 0;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private SimpleAddressNonAuthenticatedEntity address;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public HotelOnMapLightweightNonAuthenticatedEntity() {
  }

  public HotelOnMapLightweightNonAuthenticatedEntity hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Hotel trade name
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Hotel local name if different from the trade name or if it is the local language.
   * @return localName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity chain(String chain) {
    
    this.chain = chain;
    return this;
  }

   /**
   * Name of hotel chain if applicable.
   * @return chain
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChain() {
    return chain;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChain(String chain) {
    this.chain = chain;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Name of hotel brand
   * @return brand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique URL-friendly name slug of hotel
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity starRating(Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

   /**
   * Official or self-designated property star rating. Note that in some regions there are 6-star hotels. They are the same as 5-star hotels everywhere else.
   * minimum: 0
   * maximum: 6
   * @return starRating
  **/
  @jakarta.annotation.Nullable
 @Min(0) @Max(6)
  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(Integer starRating) {
    this.starRating = starRating;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity bookings(Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

   /**
   * Number of bookings for this property on the wink.travel platform.
   * @return bookings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(Long bookings) {
    this.bookings = bookings;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity aggregateReviewRating(Float aggregateReviewRating) {
    
    this.aggregateReviewRating = aggregateReviewRating;
    return this;
  }

   /**
   * Aggregate score based on all current user reviews.
   * @return aggregateReviewRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateReviewRating() {
    return aggregateReviewRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateReviewRating(Float aggregateReviewRating) {
    this.aggregateReviewRating = aggregateReviewRating;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity location(GeoJsonPointNonAuthenticatedEntity location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointNonAuthenticatedEntity getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointNonAuthenticatedEntity location) {
    this.location = location;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity shortDescriptions(List<LocalizedDescriptionNonAuthenticatedEntity> shortDescriptions) {
    
    this.shortDescriptions = shortDescriptions;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addShortDescriptionsItem(LocalizedDescriptionNonAuthenticatedEntity shortDescriptionsItem) {
    if (this.shortDescriptions == null) {
      this.shortDescriptions = new ArrayList<>();
    }
    this.shortDescriptions.add(shortDescriptionsItem);
    return this;
  }

   /**
   * A localized list of short property descriptions
   * @return shortDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionNonAuthenticatedEntity> getShortDescriptions() {
    return shortDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShortDescriptions(List<LocalizedDescriptionNonAuthenticatedEntity> shortDescriptions) {
    this.shortDescriptions = shortDescriptions;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity longDescriptions(List<LocalizedDescriptionNonAuthenticatedEntity> longDescriptions) {
    
    this.longDescriptions = longDescriptions;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addLongDescriptionsItem(LocalizedDescriptionNonAuthenticatedEntity longDescriptionsItem) {
    if (this.longDescriptions == null) {
      this.longDescriptions = new ArrayList<>();
    }
    this.longDescriptions.add(longDescriptionsItem);
    return this;
  }

   /**
   * A localized list of longer property descriptions
   * @return longDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionNonAuthenticatedEntity> getLongDescriptions() {
    return longDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongDescriptions(List<LocalizedDescriptionNonAuthenticatedEntity> longDescriptions) {
    this.longDescriptions = longDescriptions;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity aggregateGreendexRating(Float aggregateGreendexRating) {
    
    this.aggregateGreendexRating = aggregateGreendexRating;
    return this;
  }

   /**
   * Aggregate Green Index score if the property has answered our questionnaire available in the Extranet.
   * @return aggregateGreendexRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateGreendexRating() {
    return aggregateGreendexRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateGreendexRating(Float aggregateGreendexRating) {
    this.aggregateGreendexRating = aggregateGreendexRating;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    
    this.lifestyleTypes = lifestyleTypes;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
    if (this.lifestyleTypes == null) {
      this.lifestyleTypes = new ArrayList<>();
    }
    this.lifestyleTypes.add(lifestyleTypesItem);
    return this;
  }

   /**
   * Get lifestyleTypes
   * @return lifestyleTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LifestyleTypesEnum> getLifestyleTypes() {
    return lifestyleTypes;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    this.lifestyleTypes = lifestyleTypes;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity totalReviews(Integer totalReviews) {
    
    this.totalReviews = totalReviews;
    return this;
  }

   /**
   * Count of total reviews left by users at this property.
   * @return totalReviews
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalReviews() {
    return totalReviews;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalReviews(Integer totalReviews) {
    this.totalReviews = totalReviews;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity socials(List<SocialNonAuthenticatedEntity> socials) {
    
    this.socials = socials;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addSocialsItem(SocialNonAuthenticatedEntity socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Property&#39;s social network accounts
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialNonAuthenticatedEntity> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialNonAuthenticatedEntity> socials) {
    this.socials = socials;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity images(List<SimpleMultimediaNonAuthenticatedEntity> images) {
    
    this.images = images;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addImagesItem(SimpleMultimediaNonAuthenticatedEntity imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

   /**
   * Property images.
   * @return images
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaNonAuthenticatedEntity> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(List<SimpleMultimediaNonAuthenticatedEntity> images) {
    this.images = images;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity videos(List<SimpleMultimediaNonAuthenticatedEntity> videos) {
    
    this.videos = videos;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addVideosItem(SimpleMultimediaNonAuthenticatedEntity videosItem) {
    if (this.videos == null) {
      this.videos = new ArrayList<>();
    }
    this.videos.add(videosItem);
    return this;
  }

   /**
   * Property videos.
   * @return videos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaNonAuthenticatedEntity> getVideos() {
    return videos;
  }


  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideos(List<SimpleMultimediaNonAuthenticatedEntity> videos) {
    this.videos = videos;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity policy(PropertyPolicyNonAuthenticatedEntity policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicyNonAuthenticatedEntity getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicyNonAuthenticatedEntity policy) {
    this.policy = policy;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity thirdPartyReviews(List<TravelInventoryRecognitionNonAuthenticatedEntity> thirdPartyReviews) {
    
    this.thirdPartyReviews = thirdPartyReviews;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addThirdPartyReviewsItem(TravelInventoryRecognitionNonAuthenticatedEntity thirdPartyReviewsItem) {
    if (this.thirdPartyReviews == null) {
      this.thirdPartyReviews = new ArrayList<>();
    }
    this.thirdPartyReviews.add(thirdPartyReviewsItem);
    return this;
  }

   /**
   * Array of awards and third party reviews given to property by certified / non-certified providers.
   * @return thirdPartyReviews
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionNonAuthenticatedEntity> getThirdPartyReviews() {
    return thirdPartyReviews;
  }


  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThirdPartyReviews(List<TravelInventoryRecognitionNonAuthenticatedEntity> thirdPartyReviews) {
    this.thirdPartyReviews = thirdPartyReviews;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity attractions(Integer attractions) {
    
    this.attractions = attractions;
    return this;
  }

   /**
   * Number of attractions property has listed on its profile.
   * @return attractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(Integer attractions) {
    this.attractions = attractions;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity recreations(Integer recreations) {
    
    this.recreations = recreations;
    return this;
  }

   /**
   * Number of activites property has listed on its profile.
   * @return recreations
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRecreations() {
    return recreations;
  }


  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreations(Integer recreations) {
    this.recreations = recreations;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity pois(Integer pois) {
    
    this.pois = pois;
    return this;
  }

   /**
   * Number of places property has listed on its profile.
   * @return pois
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPois() {
    return pois;
  }


  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPois(Integer pois) {
    this.pois = pois;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity restaurants(Integer restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

   /**
   * Number of restaurants property has on its profile.
   * @return restaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(Integer restaurants) {
    this.restaurants = restaurants;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity meetingRooms(Integer meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

   /**
   * Number of meeting rooms property has on its profile.
   * @return meetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(Integer meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity spas(Integer spas) {
    
    this.spas = spas;
    return this;
  }

   /**
   * Number of spas property has on its profile.
   * @return spas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(Integer spas) {
    this.spas = spas;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity addOns(Integer addOns) {
    
    this.addOns = addOns;
    return this;
  }

   /**
   * Number of add-ons property has on its profile.
   * @return addOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAddOns() {
    return addOns;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOns(Integer addOns) {
    this.addOns = addOns;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity generalManager(GeneralManagerNonAuthenticatedEntity generalManager) {
    
    this.generalManager = generalManager;
    return this;
  }

   /**
   * Get generalManager
   * @return generalManager
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeneralManagerNonAuthenticatedEntity getGeneralManager() {
    return generalManager;
  }


  @JsonProperty(JSON_PROPERTY_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeneralManager(GeneralManagerNonAuthenticatedEntity generalManager) {
    this.generalManager = generalManager;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code for property.
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity membershipRateDiscount(Float membershipRateDiscount) {
    
    this.membershipRateDiscount = membershipRateDiscount;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return membershipRateDiscount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMembershipRateDiscount() {
    return membershipRateDiscount;
  }


  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMembershipRateDiscount(Float membershipRateDiscount) {
    this.membershipRateDiscount = membershipRateDiscount;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity priceScore(Integer priceScore) {
    
    this.priceScore = priceScore;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return priceScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriceScore() {
    return priceScore;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceScore(Integer priceScore) {
    this.priceScore = priceScore;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity perkScore(Integer perkScore) {
    
    this.perkScore = perkScore;
    return this;
  }

   /**
   * A property&#39;s perk score is based on the type of perks that is offered to the guests across all master rates. There is no max score; it&#39;s there to compare it against other properties.
   * @return perkScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkScore() {
    return perkScore;
  }


  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkScore(Integer perkScore) {
    this.perkScore = perkScore;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity packageScore(Integer packageScore) {
    
    this.packageScore = packageScore;
    return this;
  }

   /**
   * A property&#39;s package score is based on general availability and price for all packages and add-ons offered by the property. There is no max score; it&#39;s there to compare it against other properties.
   * @return packageScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPackageScore() {
    return packageScore;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageScore(Integer packageScore) {
    this.packageScore = packageScore;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity loyaltyScore(Integer loyaltyScore) {
    
    this.loyaltyScore = loyaltyScore;
    return this;
  }

   /**
   * A property&#39;s loyalty score is based on calculating how many available rate plans honor loyalty points. There is no max score; it&#39;s there to compare it against other properties.
   * @return loyaltyScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLoyaltyScore() {
    return loyaltyScore;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyScore(Integer loyaltyScore) {
    this.loyaltyScore = loyaltyScore;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity popularScore(Integer popularScore) {
    
    this.popularScore = popularScore;
    return this;
  }

   /**
   * A property&#39;s popular score is based on calculating number of bookings across room types. There is no max score; it&#39;s there to compare it against other properties.
   * @return popularScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPopularScore() {
    return popularScore;
  }


  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopularScore(Integer popularScore) {
    this.popularScore = popularScore;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity experienceScore(Integer experienceScore) {
    
    this.experienceScore = experienceScore;
    return this;
  }

   /**
   * A property&#39;s experience score is based on how calculating how many types of experiences are available and at what price ranges. There is no max score; it&#39;s there to compare it against other properties.
   * @return experienceScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExperienceScore() {
    return experienceScore;
  }


  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperienceScore(Integer experienceScore) {
    this.experienceScore = experienceScore;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity hotelAmenityCodes(List<String> hotelAmenityCodes) {
    
    this.hotelAmenityCodes = hotelAmenityCodes;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
    if (this.hotelAmenityCodes == null) {
      this.hotelAmenityCodes = new ArrayList<>();
    }
    this.hotelAmenityCodes.add(hotelAmenityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;HAC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelAmenityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelAmenityCodes() {
    return hotelAmenityCodes;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
    this.hotelAmenityCodes = hotelAmenityCodes;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
    if (this.propertyAccessibilityCodes == null) {
      this.propertyAccessibilityCodes = new ArrayList<>();
    }
    this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertyAccessibilityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAccessibilityCodes() {
    return propertyAccessibilityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity propertySecurityCodes(List<String> propertySecurityCodes) {
    
    this.propertySecurityCodes = propertySecurityCodes;
    return this;
  }

  public HotelOnMapLightweightNonAuthenticatedEntity addPropertySecurityCodesItem(String propertySecurityCodesItem) {
    if (this.propertySecurityCodes == null) {
      this.propertySecurityCodes = new ArrayList<>();
    }
    this.propertySecurityCodes.add(propertySecurityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertySecurityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertySecurityCodes() {
    return propertySecurityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
    this.propertySecurityCodes = propertySecurityCodes;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for this property.
   * @return numberOfRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity address(SimpleAddressNonAuthenticatedEntity address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SimpleAddressNonAuthenticatedEntity getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(SimpleAddressNonAuthenticatedEntity address) {
    this.address = address;
  }


  public HotelOnMapLightweightNonAuthenticatedEntity active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Whether property is active
   * @return active
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelOnMapLightweightNonAuthenticatedEntity hotelOnMapLightweightNonAuthenticatedEntity = (HotelOnMapLightweightNonAuthenticatedEntity) o;
    return Objects.equals(this.hotelIdentifier, hotelOnMapLightweightNonAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.name, hotelOnMapLightweightNonAuthenticatedEntity.name) &&
        Objects.equals(this.localName, hotelOnMapLightweightNonAuthenticatedEntity.localName) &&
        Objects.equals(this.chain, hotelOnMapLightweightNonAuthenticatedEntity.chain) &&
        Objects.equals(this.brand, hotelOnMapLightweightNonAuthenticatedEntity.brand) &&
        Objects.equals(this.urlName, hotelOnMapLightweightNonAuthenticatedEntity.urlName) &&
        Objects.equals(this.starRating, hotelOnMapLightweightNonAuthenticatedEntity.starRating) &&
        Objects.equals(this.bookings, hotelOnMapLightweightNonAuthenticatedEntity.bookings) &&
        Objects.equals(this.aggregateReviewRating, hotelOnMapLightweightNonAuthenticatedEntity.aggregateReviewRating) &&
        Objects.equals(this.location, hotelOnMapLightweightNonAuthenticatedEntity.location) &&
        Objects.equals(this.shortDescriptions, hotelOnMapLightweightNonAuthenticatedEntity.shortDescriptions) &&
        Objects.equals(this.longDescriptions, hotelOnMapLightweightNonAuthenticatedEntity.longDescriptions) &&
        Objects.equals(this.aggregateGreendexRating, hotelOnMapLightweightNonAuthenticatedEntity.aggregateGreendexRating) &&
        Objects.equals(this.lifestyleTypes, hotelOnMapLightweightNonAuthenticatedEntity.lifestyleTypes) &&
        Objects.equals(this.totalReviews, hotelOnMapLightweightNonAuthenticatedEntity.totalReviews) &&
        Objects.equals(this.socials, hotelOnMapLightweightNonAuthenticatedEntity.socials) &&
        Objects.equals(this.images, hotelOnMapLightweightNonAuthenticatedEntity.images) &&
        Objects.equals(this.videos, hotelOnMapLightweightNonAuthenticatedEntity.videos) &&
        Objects.equals(this.policy, hotelOnMapLightweightNonAuthenticatedEntity.policy) &&
        Objects.equals(this.thirdPartyReviews, hotelOnMapLightweightNonAuthenticatedEntity.thirdPartyReviews) &&
        Objects.equals(this.attractions, hotelOnMapLightweightNonAuthenticatedEntity.attractions) &&
        Objects.equals(this.recreations, hotelOnMapLightweightNonAuthenticatedEntity.recreations) &&
        Objects.equals(this.pois, hotelOnMapLightweightNonAuthenticatedEntity.pois) &&
        Objects.equals(this.restaurants, hotelOnMapLightweightNonAuthenticatedEntity.restaurants) &&
        Objects.equals(this.meetingRooms, hotelOnMapLightweightNonAuthenticatedEntity.meetingRooms) &&
        Objects.equals(this.spas, hotelOnMapLightweightNonAuthenticatedEntity.spas) &&
        Objects.equals(this.addOns, hotelOnMapLightweightNonAuthenticatedEntity.addOns) &&
        Objects.equals(this.generalManager, hotelOnMapLightweightNonAuthenticatedEntity.generalManager) &&
        Objects.equals(this.locationCategory, hotelOnMapLightweightNonAuthenticatedEntity.locationCategory) &&
        Objects.equals(this.segmentCategory, hotelOnMapLightweightNonAuthenticatedEntity.segmentCategory) &&
        Objects.equals(this.hotelCategory, hotelOnMapLightweightNonAuthenticatedEntity.hotelCategory) &&
        Objects.equals(this.architecturalStyle, hotelOnMapLightweightNonAuthenticatedEntity.architecturalStyle) &&
        Objects.equals(this.whenBuilt, hotelOnMapLightweightNonAuthenticatedEntity.whenBuilt) &&
        Objects.equals(this.currencyCode, hotelOnMapLightweightNonAuthenticatedEntity.currencyCode) &&
        Objects.equals(this.membershipRateDiscount, hotelOnMapLightweightNonAuthenticatedEntity.membershipRateDiscount) &&
        Objects.equals(this.priceScore, hotelOnMapLightweightNonAuthenticatedEntity.priceScore) &&
        Objects.equals(this.perkScore, hotelOnMapLightweightNonAuthenticatedEntity.perkScore) &&
        Objects.equals(this.packageScore, hotelOnMapLightweightNonAuthenticatedEntity.packageScore) &&
        Objects.equals(this.loyaltyScore, hotelOnMapLightweightNonAuthenticatedEntity.loyaltyScore) &&
        Objects.equals(this.popularScore, hotelOnMapLightweightNonAuthenticatedEntity.popularScore) &&
        Objects.equals(this.experienceScore, hotelOnMapLightweightNonAuthenticatedEntity.experienceScore) &&
        Objects.equals(this.hotelAmenityCodes, hotelOnMapLightweightNonAuthenticatedEntity.hotelAmenityCodes) &&
        Objects.equals(this.propertyAccessibilityCodes, hotelOnMapLightweightNonAuthenticatedEntity.propertyAccessibilityCodes) &&
        Objects.equals(this.propertySecurityCodes, hotelOnMapLightweightNonAuthenticatedEntity.propertySecurityCodes) &&
        Objects.equals(this.numberOfRooms, hotelOnMapLightweightNonAuthenticatedEntity.numberOfRooms) &&
        Objects.equals(this.address, hotelOnMapLightweightNonAuthenticatedEntity.address) &&
        Objects.equals(this.active, hotelOnMapLightweightNonAuthenticatedEntity.active);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, name, localName, chain, brand, urlName, starRating, bookings, aggregateReviewRating, location, shortDescriptions, longDescriptions, aggregateGreendexRating, lifestyleTypes, totalReviews, socials, images, videos, policy, thirdPartyReviews, attractions, recreations, pois, restaurants, meetingRooms, spas, addOns, generalManager, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, currencyCode, membershipRateDiscount, priceScore, perkScore, packageScore, loyaltyScore, popularScore, experienceScore, hotelAmenityCodes, propertyAccessibilityCodes, propertySecurityCodes, numberOfRooms, address, active);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelOnMapLightweightNonAuthenticatedEntity {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    chain: ").append(toIndentedString(chain)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    aggregateReviewRating: ").append(toIndentedString(aggregateReviewRating)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    shortDescriptions: ").append(toIndentedString(shortDescriptions)).append("\n");
    sb.append("    longDescriptions: ").append(toIndentedString(longDescriptions)).append("\n");
    sb.append("    aggregateGreendexRating: ").append(toIndentedString(aggregateGreendexRating)).append("\n");
    sb.append("    lifestyleTypes: ").append(toIndentedString(lifestyleTypes)).append("\n");
    sb.append("    totalReviews: ").append(toIndentedString(totalReviews)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    videos: ").append(toIndentedString(videos)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    thirdPartyReviews: ").append(toIndentedString(thirdPartyReviews)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    recreations: ").append(toIndentedString(recreations)).append("\n");
    sb.append("    pois: ").append(toIndentedString(pois)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    addOns: ").append(toIndentedString(addOns)).append("\n");
    sb.append("    generalManager: ").append(toIndentedString(generalManager)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    membershipRateDiscount: ").append(toIndentedString(membershipRateDiscount)).append("\n");
    sb.append("    priceScore: ").append(toIndentedString(priceScore)).append("\n");
    sb.append("    perkScore: ").append(toIndentedString(perkScore)).append("\n");
    sb.append("    packageScore: ").append(toIndentedString(packageScore)).append("\n");
    sb.append("    loyaltyScore: ").append(toIndentedString(loyaltyScore)).append("\n");
    sb.append("    popularScore: ").append(toIndentedString(popularScore)).append("\n");
    sb.append("    experienceScore: ").append(toIndentedString(experienceScore)).append("\n");
    sb.append("    hotelAmenityCodes: ").append(toIndentedString(hotelAmenityCodes)).append("\n");
    sb.append("    propertyAccessibilityCodes: ").append(toIndentedString(propertyAccessibilityCodes)).append("\n");
    sb.append("    propertySecurityCodes: ").append(toIndentedString(propertySecurityCodes)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

