package travel.wink.sdk.lookup.api;

import travel.wink.sdk.lookup.invoker.ApiClient;

import travel.wink.sdk.lookup.model.CityScoreRequest;
import travel.wink.sdk.lookup.model.CitySearchRequest;
import travel.wink.sdk.lookup.model.CountryScoreRequest;
import travel.wink.sdk.lookup.model.GenericErrorMessage;
import travel.wink.sdk.lookup.model.GlobalScoreRequest;
import travel.wink.sdk.lookup.model.Lookup;
import travel.wink.sdk.lookup.model.LookupCached;
import travel.wink.sdk.lookup.model.MapRequest;
import travel.wink.sdk.lookup.model.Oauth2SearchByGeoLocation400Response;
import travel.wink.sdk.lookup.model.PageHotelWithBestPrice;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-16T10:43:13.368286067+07:00[Asia/Bangkok]")
public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequest The cityScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ScoreInventoryByCityRequestCreation(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = cityScoreRequest;
        // verify the required parameter 'cityScoreRequest' is set
        if (cityScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequest' when calling oauth2ScoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequest The cityScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2ScoreInventoryByCity(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2ScoreInventoryByCityWithHttpInfo(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequest The mapRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchByGeoLocationRequestCreation(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = mapRequest;
        // verify the required parameter 'mapRequest' is set
        if (mapRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequest' when calling oauth2SearchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequest The mapRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2SearchByGeoLocation(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchByGeoLocationRequestCreation(mapRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchByGeoLocationWithHttpInfo(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchByGeoLocationRequestCreation(mapRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequest The citySearchRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchInventoryByCityRequestCreation(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = citySearchRequest;
        // verify the required parameter 'citySearchRequest' is set
        if (citySearchRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequest' when calling oauth2SearchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequest The citySearchRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2SearchInventoryByCity(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchInventoryByCityWithHttpInfo(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequest The countryScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchScoreByCountryRequestCreation(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = countryScoreRequest;
        // verify the required parameter 'countryScoreRequest' is set
        if (countryScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequest' when calling oauth2SearchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequest The countryScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2SearchScoreByCountry(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchScoreByCountryWithHttpInfo(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequest The globalScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchScoreByGlobalRequestCreation(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = globalScoreRequest;
        // verify the required parameter 'globalScoreRequest' is set
        if (globalScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequest' when calling oauth2SearchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequest The globalScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2SearchScoreByGlobal(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchScoreByGlobalWithHttpInfo(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param accept The accept parameter
     * @return List&lt;LookupCached&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchSuggestionsRequestCreation(String term, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'term' is set
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling oauth2SearchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "term", term));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>() {};
        return apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param accept The accept parameter
     * @return List&lt;LookupCached&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LookupCached> oauth2SearchSuggestions(String term, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>() {};
        return oauth2SearchSuggestionsRequestCreation(term, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<LookupCached>>> oauth2SearchSuggestionsWithHttpInfo(String term, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>() {};
        return oauth2SearchSuggestionsRequestCreation(term, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param accept The accept parameter
     * @return Lookup
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowLookupRequestCreation(String urlName, String type, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'urlName' is set
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("urlName", urlName);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>() {};
        return apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param accept The accept parameter
     * @return Lookup
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Lookup> oauth2ShowLookup(String urlName, String type, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>() {};
        return oauth2ShowLookupRequestCreation(urlName, type, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Lookup>> oauth2ShowLookupWithHttpInfo(String urlName, String type, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>() {};
        return oauth2ShowLookupRequestCreation(urlName, type, accept).toEntity(localVarReturnType);
    }
}
