/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;

@ApiModel(description="Array of awards and third party reviews given to property by certified / non-certified providers.")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "category", "type", "provider", "rating", "maxRating", "date", "officialAppointmentInd", "ratingSymbol"})
public class Recognition {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private String provider;
    public static final String JSON_PROPERTY_RATING = "rating";
    private Float rating;
    public static final String JSON_PROPERTY_MAX_RATING = "maxRating";
    private Float maxRating;
    public static final String JSON_PROPERTY_DATE = "date";
    private LocalDate date;
    public static final String JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND = "officialAppointmentInd";
    private Boolean officialAppointmentInd;
    public static final String JSON_PROPERTY_RATING_SYMBOL = "ratingSymbol";
    private String ratingSymbol;

    public Recognition identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Recognition identifier.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public Recognition hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public Recognition category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="AWARD", required=true, value="Recognition category.")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Recognition type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PERCENT_RATING", required=true, value="Type of rating system the recognition operated on. This allows us to display the score properly.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Recognition provider(String provider) {
        this.provider = provider;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Michelin", required=true, value="The name of the entity that administers this recognition.")
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Recognition rating(Float rating) {
        this.rating = rating;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0.0")
    @ApiModelProperty(example="8.5", required=true, value="The actual award or rating received by the hotel facility.")
    @JsonProperty(value="rating")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0.0") Float getRating() {
        return this.rating;
    }

    @JsonProperty(value="rating")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRating(Float rating) {
        this.rating = rating;
    }

    public Recognition maxRating(Float maxRating) {
        this.maxRating = maxRating;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Use this to let hotels indicate what the total score for this award is.")
    @JsonProperty(value="maxRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getMaxRating() {
        return this.maxRating;
    }

    @JsonProperty(value="maxRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxRating(Float maxRating) {
        this.maxRating = maxRating;
    }

    public Recognition date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Sat Oct 24 07:00:00 ICT 2020", value="The date the award was received")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Recognition officialAppointmentInd(Boolean officialAppointmentInd) {
        this.officialAppointmentInd = officialAppointmentInd;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="When true, this indicates the property has received official permission from the award provider to use the rating in publications and marketing materials; when false this permission has not been granted.")
    @JsonProperty(value="officialAppointmentInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOfficialAppointmentInd() {
        return this.officialAppointmentInd;
    }

    @JsonProperty(value="officialAppointmentInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOfficialAppointmentInd(Boolean officialAppointmentInd) {
        this.officialAppointmentInd = officialAppointmentInd;
    }

    public Recognition ratingSymbol(String ratingSymbol) {
        this.ratingSymbol = ratingSymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="*", value="Provides the symbol used in the rating. Used in conjunction with the Rating.")
    @JsonProperty(value="ratingSymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatingSymbol() {
        return this.ratingSymbol;
    }

    @JsonProperty(value="ratingSymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatingSymbol(String ratingSymbol) {
        this.ratingSymbol = ratingSymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recognition recognition = (Recognition)o;
        return Objects.equals(this.identifier, recognition.identifier) && Objects.equals(this.hotelIdentifier, recognition.hotelIdentifier) && Objects.equals((Object)this.category, (Object)recognition.category) && Objects.equals((Object)this.type, (Object)recognition.type) && Objects.equals(this.provider, recognition.provider) && Objects.equals(this.rating, recognition.rating) && Objects.equals(this.maxRating, recognition.maxRating) && Objects.equals(this.date, recognition.date) && Objects.equals(this.officialAppointmentInd, recognition.officialAppointmentInd) && Objects.equals(this.ratingSymbol, recognition.ratingSymbol);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.category, this.type, this.provider, this.rating, this.maxRating, this.date, this.officialAppointmentInd, this.ratingSymbol});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recognition {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    rating: ").append(this.toIndentedString(this.rating)).append("\n");
        sb.append("    maxRating: ").append(this.toIndentedString(this.maxRating)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    officialAppointmentInd: ").append(this.toIndentedString(this.officialAppointmentInd)).append("\n");
        sb.append("    ratingSymbol: ").append(this.toIndentedString(this.ratingSymbol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        THIRD_PARTY_REVIEW("THIRD_PARTY_REVIEW"),
        PUBLICATION("PUBLICATION"),
        AWARD("AWARD");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        STAR_RATING("STAR_RATING"),
        NUMERIC_RATING("NUMERIC_RATING"),
        PERCENT_RATING("PERCENT_RATING");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

