/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.lookup.model.UserSession;

@JsonPropertyOrder(value={"urlName", "sort", "userSession", "page", "size"})
public class CityScoreRequest {
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    private String urlName;
    public static final String JSON_PROPERTY_SORT = "sort";
    private SortEnum sort;
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSession userSession;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size;

    public CityScoreRequest urlName(String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="los-angeles-california-united-states", required=true, value="Unique url name for city you wish to search in as it was given to you in the lookup entry.")
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public CityScoreRequest sort(SortEnum sort) {
        this.sort = sort;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="MEMBER", required=true, value="Choose the criteria you want the results sorted on.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SortEnum getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSort(SortEnum sort) {
        this.sort = sort;
    }

    public CityScoreRequest userSession(UserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public CityScoreRequest page(Integer page) {
        this.page = page;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="The page to paginate to. Note: Page uses a 0-based index.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public CityScoreRequest size(Integer size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @Max(value=50L)
    @ApiModelProperty(example="10", required=true, value="The result size to return.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=50L) Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CityScoreRequest cityScoreRequest = (CityScoreRequest)o;
        return Objects.equals(this.urlName, cityScoreRequest.urlName) && Objects.equals((Object)this.sort, (Object)cityScoreRequest.sort) && Objects.equals(this.userSession, cityScoreRequest.userSession) && Objects.equals(this.page, cityScoreRequest.page) && Objects.equals(this.size, cityScoreRequest.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.urlName, this.sort, this.userSession, this.page, this.size});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CityScoreRequest {\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString((Object)this.sort)).append("\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SortEnum {
        MEMBER("MEMBER"),
        PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
        PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
        PRICE("PRICE"),
        POPULARITY("POPULARITY"),
        ECO("ECO"),
        EXPERIENCE("EXPERIENCE"),
        PERK("PERK"),
        LOYALTY("LOYALTY"),
        PACKAGE("PACKAGE");

        private String value;

        private SortEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortEnum fromValue(String value) {
            for (SortEnum b : SortEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

