/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.lookup.model.BedConsumer;

@JsonPropertyOrder(value={"type", "bedList"})
@JsonTypeName(value="Bedroom_Consumer")
public class BedroomConsumer {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_BED_LIST = "bedList";
    private List<BedConsumer> bedList = new ArrayList<BedConsumer>();

    public BedroomConsumer type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Type of bedroom")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BedroomConsumer bedList(List<BedConsumer> bedList) {
        this.bedList = bedList;
        return this;
    }

    public BedroomConsumer addBedListItem(BedConsumer bedListItem) {
        this.bedList.add(bedListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="A bedroom can have more than one bed type.")
    @JsonProperty(value="bedList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BedConsumer> getBedList() {
        return this.bedList;
    }

    @JsonProperty(value="bedList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedList(List<BedConsumer> bedList) {
        this.bedList = bedList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BedroomConsumer bedroomConsumer = (BedroomConsumer)o;
        return Objects.equals((Object)this.type, (Object)bedroomConsumer.type) && Objects.equals(this.bedList, bedroomConsumer.bedList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.bedList});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BedroomConsumer {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    bedList: ").append(this.toIndentedString(this.bedList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MASTER("MASTER"),
        QUEEN("QUEEN"),
        JUNIOR("JUNIOR"),
        DORMITORY("DORMITORY"),
        BEDROOM_1("BEDROOM_1"),
        BEDROOM_2("BEDROOM_2"),
        BEDROOM_3("BEDROOM_3"),
        BEDROOM_4("BEDROOM_4"),
        BEDROOM_5("BEDROOM_5"),
        BEDROOM_6("BEDROOM_6"),
        BEDROOM_7("BEDROOM_7"),
        BEDROOM_8("BEDROOM_8"),
        BEDROOM_9("BEDROOM_9"),
        BEDROOM_10("BEDROOM_10");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

