/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Lookup API Welcome to the Lookup API - A programmer-friendly way to search for bespoke travel inventory across geographic regions. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Outlines basic policies for the property.
 */
@ApiModel(description = "Outlines basic policies for the property.")
@JsonPropertyOrder({
  PropertyPolicyConsumer.JSON_PROPERTY_CHILDREN_ALLOWED,
  PropertyPolicyConsumer.JSON_PROPERTY_CHILDREN_MINIMUM_AGE,
  PropertyPolicyConsumer.JSON_PROPERTY_INTERNET_AVAILABILITY,
  PropertyPolicyConsumer.JSON_PROPERTY_INTERNET_CONNECTION_TYPE,
  PropertyPolicyConsumer.JSON_PROPERTY_INTERNET_CONNECTION_LOCATION,
  PropertyPolicyConsumer.JSON_PROPERTY_PARKING_AVAILABILITY,
  PropertyPolicyConsumer.JSON_PROPERTY_PARKING_ACCESS,
  PropertyPolicyConsumer.JSON_PROPERTY_PETS_ALLOWED,
  PropertyPolicyConsumer.JSON_PROPERTY_CHECK_OUT_TIME,
  PropertyPolicyConsumer.JSON_PROPERTY_CHECK_IN_TIME
})
@JsonTypeName("PropertyPolicy_Consumer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:49:42.091933291+07:00[Asia/Bangkok]")
public class PropertyPolicyConsumer {
  public static final String JSON_PROPERTY_CHILDREN_ALLOWED = "childrenAllowed";
  private Boolean childrenAllowed = false;

  public static final String JSON_PROPERTY_CHILDREN_MINIMUM_AGE = "childrenMinimumAge";
  private Integer childrenMinimumAge;

  /**
   * Indicates the availability of internet on the property.
   */
  public enum InternetAvailabilityEnum {
    YES("YES"),
    
    NO("NO"),
    
    YES_PAID("YES_PAID");

    private String value;

    InternetAvailabilityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InternetAvailabilityEnum fromValue(String value) {
      for (InternetAvailabilityEnum b : InternetAvailabilityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERNET_AVAILABILITY = "internetAvailability";
  private InternetAvailabilityEnum internetAvailability;

  /**
   * Indicates how guests can access the Internet on the property.
   */
  public enum InternetConnectionTypeEnum {
    WIFI("WIFI"),
    
    CABLE("CABLE");

    private String value;

    InternetConnectionTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InternetConnectionTypeEnum fromValue(String value) {
      for (InternetConnectionTypeEnum b : InternetConnectionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERNET_CONNECTION_TYPE = "internetConnectionType";
  private InternetConnectionTypeEnum internetConnectionType;

  /**
   * Indicates where internet is available in and around the property.
   */
  public enum InternetConnectionLocationEnum {
    ENTIRE_PROPERTY("ENTIRE_PROPERTY"),
    
    PUBLIC_AREAS("PUBLIC_AREAS"),
    
    ALL_ROOMS("ALL_ROOMS"),
    
    SOME_ROOMS("SOME_ROOMS"),
    
    BUSINESS_CENTER("BUSINESS_CENTER");

    private String value;

    InternetConnectionLocationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InternetConnectionLocationEnum fromValue(String value) {
      for (InternetConnectionLocationEnum b : InternetConnectionLocationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERNET_CONNECTION_LOCATION = "internetConnectionLocation";
  private InternetConnectionLocationEnum internetConnectionLocation;

  /**
   * Indicates whether parking is available at the property.
   */
  public enum ParkingAvailabilityEnum {
    YES("YES"),
    
    NO("NO"),
    
    YES_PAID("YES_PAID");

    private String value;

    ParkingAvailabilityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ParkingAvailabilityEnum fromValue(String value) {
      for (ParkingAvailabilityEnum b : ParkingAvailabilityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PARKING_AVAILABILITY = "parkingAvailability";
  private ParkingAvailabilityEnum parkingAvailability;

  /**
   * Indicates what type of parking is available at the property.
   */
  public enum ParkingAccessEnum {
    PRIVATE("PRIVATE"),
    
    PUBLIC("PUBLIC");

    private String value;

    ParkingAccessEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ParkingAccessEnum fromValue(String value) {
      for (ParkingAccessEnum b : ParkingAccessEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PARKING_ACCESS = "parkingAccess";
  private ParkingAccessEnum parkingAccess;

  public static final String JSON_PROPERTY_PETS_ALLOWED = "petsAllowed";
  private Boolean petsAllowed = false;

  public static final String JSON_PROPERTY_CHECK_OUT_TIME = "checkOutTime";
  private String checkOutTime;

  public static final String JSON_PROPERTY_CHECK_IN_TIME = "checkInTime";
  private String checkInTime;

  public PropertyPolicyConsumer() { 
  }

  public PropertyPolicyConsumer childrenAllowed(Boolean childrenAllowed) {
    
    this.childrenAllowed = childrenAllowed;
    return this;
  }

   /**
   * Indicates whether property allows children
   * @return childrenAllowed
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Indicates whether property allows children")
  @JsonProperty(JSON_PROPERTY_CHILDREN_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getChildrenAllowed() {
    return childrenAllowed;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildrenAllowed(Boolean childrenAllowed) {
    this.childrenAllowed = childrenAllowed;
  }


  public PropertyPolicyConsumer childrenMinimumAge(Integer childrenMinimumAge) {
    
    this.childrenMinimumAge = childrenMinimumAge;
    return this;
  }

   /**
   * When a property allows children, it can also indicate what the minimum age is for children to be allowed.
   * @return childrenMinimumAge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "6", value = "When a property allows children, it can also indicate what the minimum age is for children to be allowed.")
  @JsonProperty(JSON_PROPERTY_CHILDREN_MINIMUM_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildrenMinimumAge() {
    return childrenMinimumAge;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN_MINIMUM_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildrenMinimumAge(Integer childrenMinimumAge) {
    this.childrenMinimumAge = childrenMinimumAge;
  }


  public PropertyPolicyConsumer internetAvailability(InternetAvailabilityEnum internetAvailability) {
    
    this.internetAvailability = internetAvailability;
    return this;
  }

   /**
   * Indicates the availability of internet on the property.
   * @return internetAvailability
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "YES", required = true, value = "Indicates the availability of internet on the property.")
  @JsonProperty(JSON_PROPERTY_INTERNET_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InternetAvailabilityEnum getInternetAvailability() {
    return internetAvailability;
  }


  @JsonProperty(JSON_PROPERTY_INTERNET_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternetAvailability(InternetAvailabilityEnum internetAvailability) {
    this.internetAvailability = internetAvailability;
  }


  public PropertyPolicyConsumer internetConnectionType(InternetConnectionTypeEnum internetConnectionType) {
    
    this.internetConnectionType = internetConnectionType;
    return this;
  }

   /**
   * Indicates how guests can access the Internet on the property.
   * @return internetConnectionType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "WIFI", required = true, value = "Indicates how guests can access the Internet on the property.")
  @JsonProperty(JSON_PROPERTY_INTERNET_CONNECTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InternetConnectionTypeEnum getInternetConnectionType() {
    return internetConnectionType;
  }


  @JsonProperty(JSON_PROPERTY_INTERNET_CONNECTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternetConnectionType(InternetConnectionTypeEnum internetConnectionType) {
    this.internetConnectionType = internetConnectionType;
  }


  public PropertyPolicyConsumer internetConnectionLocation(InternetConnectionLocationEnum internetConnectionLocation) {
    
    this.internetConnectionLocation = internetConnectionLocation;
    return this;
  }

   /**
   * Indicates where internet is available in and around the property.
   * @return internetConnectionLocation
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ENTIRE_PROPERTY", required = true, value = "Indicates where internet is available in and around the property.")
  @JsonProperty(JSON_PROPERTY_INTERNET_CONNECTION_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InternetConnectionLocationEnum getInternetConnectionLocation() {
    return internetConnectionLocation;
  }


  @JsonProperty(JSON_PROPERTY_INTERNET_CONNECTION_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternetConnectionLocation(InternetConnectionLocationEnum internetConnectionLocation) {
    this.internetConnectionLocation = internetConnectionLocation;
  }


  public PropertyPolicyConsumer parkingAvailability(ParkingAvailabilityEnum parkingAvailability) {
    
    this.parkingAvailability = parkingAvailability;
    return this;
  }

   /**
   * Indicates whether parking is available at the property.
   * @return parkingAvailability
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "YES", required = true, value = "Indicates whether parking is available at the property.")
  @JsonProperty(JSON_PROPERTY_PARKING_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ParkingAvailabilityEnum getParkingAvailability() {
    return parkingAvailability;
  }


  @JsonProperty(JSON_PROPERTY_PARKING_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setParkingAvailability(ParkingAvailabilityEnum parkingAvailability) {
    this.parkingAvailability = parkingAvailability;
  }


  public PropertyPolicyConsumer parkingAccess(ParkingAccessEnum parkingAccess) {
    
    this.parkingAccess = parkingAccess;
    return this;
  }

   /**
   * Indicates what type of parking is available at the property.
   * @return parkingAccess
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "PRIVATE", required = true, value = "Indicates what type of parking is available at the property.")
  @JsonProperty(JSON_PROPERTY_PARKING_ACCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ParkingAccessEnum getParkingAccess() {
    return parkingAccess;
  }


  @JsonProperty(JSON_PROPERTY_PARKING_ACCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setParkingAccess(ParkingAccessEnum parkingAccess) {
    this.parkingAccess = parkingAccess;
  }


  public PropertyPolicyConsumer petsAllowed(Boolean petsAllowed) {
    
    this.petsAllowed = petsAllowed;
    return this;
  }

   /**
   * Indicates whether pets are allowed on the property. Note: There are thousand different kinds of pets. Just because the property allows small dogs does not mean the guest can bring a python. Always best to check with property.
   * @return petsAllowed
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Indicates whether pets are allowed on the property. Note: There are thousand different kinds of pets. Just because the property allows small dogs does not mean the guest can bring a python. Always best to check with property.")
  @JsonProperty(JSON_PROPERTY_PETS_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getPetsAllowed() {
    return petsAllowed;
  }


  @JsonProperty(JSON_PROPERTY_PETS_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPetsAllowed(Boolean petsAllowed) {
    this.petsAllowed = petsAllowed;
  }


  public PropertyPolicyConsumer checkOutTime(String checkOutTime) {
    
    this.checkOutTime = checkOutTime;
    return this;
  }

   /**
   * When the guest has to check out.
   * @return checkOutTime
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "10:00", required = true, value = "When the guest has to check out.")
  @JsonProperty(JSON_PROPERTY_CHECK_OUT_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCheckOutTime() {
    return checkOutTime;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_OUT_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCheckOutTime(String checkOutTime) {
    this.checkOutTime = checkOutTime;
  }


  public PropertyPolicyConsumer checkInTime(String checkInTime) {
    
    this.checkInTime = checkInTime;
    return this;
  }

   /**
   * When the guest can check in.
   * @return checkInTime
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "14:00", required = true, value = "When the guest can check in.")
  @JsonProperty(JSON_PROPERTY_CHECK_IN_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCheckInTime() {
    return checkInTime;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_IN_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCheckInTime(String checkInTime) {
    this.checkInTime = checkInTime;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyPolicyConsumer propertyPolicyConsumer = (PropertyPolicyConsumer) o;
    return Objects.equals(this.childrenAllowed, propertyPolicyConsumer.childrenAllowed) &&
        Objects.equals(this.childrenMinimumAge, propertyPolicyConsumer.childrenMinimumAge) &&
        Objects.equals(this.internetAvailability, propertyPolicyConsumer.internetAvailability) &&
        Objects.equals(this.internetConnectionType, propertyPolicyConsumer.internetConnectionType) &&
        Objects.equals(this.internetConnectionLocation, propertyPolicyConsumer.internetConnectionLocation) &&
        Objects.equals(this.parkingAvailability, propertyPolicyConsumer.parkingAvailability) &&
        Objects.equals(this.parkingAccess, propertyPolicyConsumer.parkingAccess) &&
        Objects.equals(this.petsAllowed, propertyPolicyConsumer.petsAllowed) &&
        Objects.equals(this.checkOutTime, propertyPolicyConsumer.checkOutTime) &&
        Objects.equals(this.checkInTime, propertyPolicyConsumer.checkInTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(childrenAllowed, childrenMinimumAge, internetAvailability, internetConnectionType, internetConnectionLocation, parkingAvailability, parkingAccess, petsAllowed, checkOutTime, checkInTime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyPolicyConsumer {\n");
    sb.append("    childrenAllowed: ").append(toIndentedString(childrenAllowed)).append("\n");
    sb.append("    childrenMinimumAge: ").append(toIndentedString(childrenMinimumAge)).append("\n");
    sb.append("    internetAvailability: ").append(toIndentedString(internetAvailability)).append("\n");
    sb.append("    internetConnectionType: ").append(toIndentedString(internetConnectionType)).append("\n");
    sb.append("    internetConnectionLocation: ").append(toIndentedString(internetConnectionLocation)).append("\n");
    sb.append("    parkingAvailability: ").append(toIndentedString(parkingAvailability)).append("\n");
    sb.append("    parkingAccess: ").append(toIndentedString(parkingAccess)).append("\n");
    sb.append("    petsAllowed: ").append(toIndentedString(petsAllowed)).append("\n");
    sb.append("    checkOutTime: ").append(toIndentedString(checkOutTime)).append("\n");
    sb.append("    checkInTime: ").append(toIndentedString(checkInTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

