/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Lookup API Welcome to the Lookup API - A programmer-friendly way to search for bespoke travel inventory across geographic regions. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * How user likes to have results displayed
 */
@ApiModel(description = "How user likes to have results displayed")
@JsonPropertyOrder({
  SearchFiltersConsumer.JSON_PROPERTY_MAX_DISTANCE,
  SearchFiltersConsumer.JSON_PROPERTY_LIFESTYLE,
  SearchFiltersConsumer.JSON_PROPERTY_STAR_RATING,
  SearchFiltersConsumer.JSON_PROPERTY_PERKS,
  SearchFiltersConsumer.JSON_PROPERTY_DISPLAY_BY
})
@JsonTypeName("SearchFilters_Consumer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:49:42.091933291+07:00[Asia/Bangkok]")
public class SearchFiltersConsumer {
  public static final String JSON_PROPERTY_MAX_DISTANCE = "maxDistance";
  private Double maxDistance;

  /**
   * A user can filter inventory on a lifestyle
   */
  public enum LifestyleEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleEnum fromValue(String value) {
      for (LifestyleEnum b : LifestyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE = "lifestyle";
  private LifestyleEnum lifestyle;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  private Integer starRating;

  public static final String JSON_PROPERTY_PERKS = "perks";
  private List<String> perks = null;

  public static final String JSON_PROPERTY_DISPLAY_BY = "displayBy";
  private String displayBy;

  public SearchFiltersConsumer() { 
  }

  public SearchFiltersConsumer maxDistance(Double maxDistance) {
    
    this.maxDistance = maxDistance;
    return this;
  }

   /**
   * A user can query for hotels that are close to UserSession.location
   * @return maxDistance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "A user can query for hotels that are close to UserSession.location")
  @JsonProperty(JSON_PROPERTY_MAX_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMaxDistance() {
    return maxDistance;
  }


  @JsonProperty(JSON_PROPERTY_MAX_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxDistance(Double maxDistance) {
    this.maxDistance = maxDistance;
  }


  public SearchFiltersConsumer lifestyle(LifestyleEnum lifestyle) {
    
    this.lifestyle = lifestyle;
    return this;
  }

   /**
   * A user can filter inventory on a lifestyle
   * @return lifestyle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LIFESTYLE_RELAX", value = "A user can filter inventory on a lifestyle")
  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleEnum getLifestyle() {
    return lifestyle;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyle(LifestyleEnum lifestyle) {
    this.lifestyle = lifestyle;
  }


  public SearchFiltersConsumer starRating(Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

   /**
   * A user can filter on number of hotel stars
   * @return starRating
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4", value = "A user can filter on number of hotel stars")
  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(Integer starRating) {
    this.starRating = starRating;
  }


  public SearchFiltersConsumer perks(List<String> perks) {
    
    this.perks = perks;
    return this;
  }

  public SearchFiltersConsumer addPerksItem(String perksItem) {
    if (this.perks == null) {
      this.perks = new ArrayList<>();
    }
    this.perks.add(perksItem);
    return this;
  }

   /**
   * Get perks
   * @return perks
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPerks() {
    return perks;
  }


  @JsonProperty(JSON_PROPERTY_PERKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerks(List<String> perks) {
    this.perks = perks;
  }


  public SearchFiltersConsumer displayBy(String displayBy) {
    
    this.displayBy = displayBy;
    return this;
  }

   /**
   * Get displayBy
   * @return displayBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayBy() {
    return displayBy;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayBy(String displayBy) {
    this.displayBy = displayBy;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchFiltersConsumer searchFiltersConsumer = (SearchFiltersConsumer) o;
    return Objects.equals(this.maxDistance, searchFiltersConsumer.maxDistance) &&
        Objects.equals(this.lifestyle, searchFiltersConsumer.lifestyle) &&
        Objects.equals(this.starRating, searchFiltersConsumer.starRating) &&
        Objects.equals(this.perks, searchFiltersConsumer.perks) &&
        Objects.equals(this.displayBy, searchFiltersConsumer.displayBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxDistance, lifestyle, starRating, perks, displayBy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchFiltersConsumer {\n");
    sb.append("    maxDistance: ").append(toIndentedString(maxDistance)).append("\n");
    sb.append("    lifestyle: ").append(toIndentedString(lifestyle)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("    perks: ").append(toIndentedString(perks)).append("\n");
    sb.append("    displayBy: ").append(toIndentedString(displayBy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

