/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.lookup.model.MoneysConsumer;
import travel.wink.sdk.lookup.model.QuoteConsumer;

@ApiModel(description="Localized price")
@JsonPropertyOrder(value={"sourceToUserCurrencyQuote", "sourceToInternalCurrencyQuote", "userSpecifiedCurrencyBaseTotal", "sourceBaseTotal", "internalBaseTotal", "userSpecifiedCurrencyPromotionalModifier", "sourcePromotionalModifier", "internalPromotionalModifier", "userSpecifiedCurrencyPremiumModifier", "sourcePremiumModifier", "internalPremiumModifier", "userSpecifiedCurrencyChannelModifier", "sourceChannelModifier", "internalChannelModifier", "quantity", "promotionalDiscountPercent", "channelDiscountPercent", "premiumPercent", "sourceTotal", "userSpecifiedCurrencyTotal", "internalTotal", "hasPromotion", "hasPremium", "totalDiscountPercent", "hasChannelDiscount"})
@JsonTypeName(value="LocalizedPrice_Consumer")
public class LocalizedPriceConsumer {
    public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
    private QuoteConsumer sourceToUserCurrencyQuote;
    public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
    private QuoteConsumer sourceToInternalCurrencyQuote;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
    private MoneysConsumer userSpecifiedCurrencyBaseTotal;
    public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
    private MoneysConsumer sourceBaseTotal;
    public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
    private MoneysConsumer internalBaseTotal;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
    private Double userSpecifiedCurrencyPromotionalModifier;
    public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
    private Double sourcePromotionalModifier;
    public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
    private Double internalPromotionalModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
    private Double userSpecifiedCurrencyPremiumModifier;
    public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
    private Double sourcePremiumModifier;
    public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
    private Double internalPremiumModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
    private Double userSpecifiedCurrencyChannelModifier;
    public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
    private Double sourceChannelModifier;
    public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
    private Double internalChannelModifier;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity = 1;
    public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
    private Float promotionalDiscountPercent;
    public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
    private Float channelDiscountPercent;
    public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
    private Float premiumPercent;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    private MoneysConsumer sourceTotal;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    private MoneysConsumer userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    private MoneysConsumer internalTotal;
    public static final String JSON_PROPERTY_HAS_PROMOTION = "hasPromotion";
    private Boolean hasPromotion;
    public static final String JSON_PROPERTY_HAS_PREMIUM = "hasPremium";
    private Boolean hasPremium;
    public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
    private Float totalDiscountPercent;
    public static final String JSON_PROPERTY_HAS_CHANNEL_DISCOUNT = "hasChannelDiscount";
    private Boolean hasChannelDiscount;

    public LocalizedPriceConsumer sourceToUserCurrencyQuote(QuoteConsumer sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteConsumer getSourceToUserCurrencyQuote() {
        return this.sourceToUserCurrencyQuote;
    }

    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceToUserCurrencyQuote(QuoteConsumer sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    }

    public LocalizedPriceConsumer sourceToInternalCurrencyQuote(QuoteConsumer sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteConsumer getSourceToInternalCurrencyQuote() {
        return this.sourceToInternalCurrencyQuote;
    }

    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceToInternalCurrencyQuote(QuoteConsumer sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    }

    public LocalizedPriceConsumer userSpecifiedCurrencyBaseTotal(MoneysConsumer userSpecifiedCurrencyBaseTotal) {
        this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSpecifiedCurrencyBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysConsumer getUserSpecifiedCurrencyBaseTotal() {
        return this.userSpecifiedCurrencyBaseTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSpecifiedCurrencyBaseTotal(MoneysConsumer userSpecifiedCurrencyBaseTotal) {
        this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    }

    public LocalizedPriceConsumer sourceBaseTotal(MoneysConsumer sourceBaseTotal) {
        this.sourceBaseTotal = sourceBaseTotal;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysConsumer getSourceBaseTotal() {
        return this.sourceBaseTotal;
    }

    @JsonProperty(value="sourceBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceBaseTotal(MoneysConsumer sourceBaseTotal) {
        this.sourceBaseTotal = sourceBaseTotal;
    }

    public LocalizedPriceConsumer internalBaseTotal(MoneysConsumer internalBaseTotal) {
        this.internalBaseTotal = internalBaseTotal;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="internalBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysConsumer getInternalBaseTotal() {
        return this.internalBaseTotal;
    }

    @JsonProperty(value="internalBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalBaseTotal(MoneysConsumer internalBaseTotal) {
        this.internalBaseTotal = internalBaseTotal;
    }

    public LocalizedPriceConsumer userSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
        this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Promotional modifiers in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyPromotionalModifier() {
        return this.userSpecifiedCurrencyPromotionalModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
        this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    }

    public LocalizedPriceConsumer sourcePromotionalModifier(Double sourcePromotionalModifier) {
        this.sourcePromotionalModifier = sourcePromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Promotional modifiers in hotel currency")
    @JsonProperty(value="sourcePromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourcePromotionalModifier() {
        return this.sourcePromotionalModifier;
    }

    @JsonProperty(value="sourcePromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePromotionalModifier(Double sourcePromotionalModifier) {
        this.sourcePromotionalModifier = sourcePromotionalModifier;
    }

    public LocalizedPriceConsumer internalPromotionalModifier(Double internalPromotionalModifier) {
        this.internalPromotionalModifier = internalPromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Promotional modifiers in wink currency")
    @JsonProperty(value="internalPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalPromotionalModifier() {
        return this.internalPromotionalModifier;
    }

    @JsonProperty(value="internalPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalPromotionalModifier(Double internalPromotionalModifier) {
        this.internalPromotionalModifier = internalPromotionalModifier;
    }

    public LocalizedPriceConsumer userSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
        this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Premium modifiers in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyPremiumModifier() {
        return this.userSpecifiedCurrencyPremiumModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
        this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    }

    public LocalizedPriceConsumer sourcePremiumModifier(Double sourcePremiumModifier) {
        this.sourcePremiumModifier = sourcePremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Premium modifiers in hotel currency")
    @JsonProperty(value="sourcePremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourcePremiumModifier() {
        return this.sourcePremiumModifier;
    }

    @JsonProperty(value="sourcePremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePremiumModifier(Double sourcePremiumModifier) {
        this.sourcePremiumModifier = sourcePremiumModifier;
    }

    public LocalizedPriceConsumer internalPremiumModifier(Double internalPremiumModifier) {
        this.internalPremiumModifier = internalPremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Premium modifiers in wink currency")
    @JsonProperty(value="internalPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalPremiumModifier() {
        return this.internalPremiumModifier;
    }

    @JsonProperty(value="internalPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalPremiumModifier(Double internalPremiumModifier) {
        this.internalPremiumModifier = internalPremiumModifier;
    }

    public LocalizedPriceConsumer userSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
        this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyChannelModifier() {
        return this.userSpecifiedCurrencyChannelModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
        this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    }

    public LocalizedPriceConsumer sourceChannelModifier(Double sourceChannelModifier) {
        this.sourceChannelModifier = sourceChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in hotel currency")
    @JsonProperty(value="sourceChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourceChannelModifier() {
        return this.sourceChannelModifier;
    }

    @JsonProperty(value="sourceChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceChannelModifier(Double sourceChannelModifier) {
        this.sourceChannelModifier = sourceChannelModifier;
    }

    public LocalizedPriceConsumer internalChannelModifier(Double internalChannelModifier) {
        this.internalChannelModifier = internalChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in wink currency")
    @JsonProperty(value="internalChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalChannelModifier() {
        return this.internalChannelModifier;
    }

    @JsonProperty(value="internalChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalChannelModifier(Double internalChannelModifier) {
        this.internalChannelModifier = internalChannelModifier;
    }

    public LocalizedPriceConsumer quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How many of this item is included in this price")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public LocalizedPriceConsumer promotionalDiscountPercent(Float promotionalDiscountPercent) {
        this.promotionalDiscountPercent = promotionalDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Promotional discount percent")
    @JsonProperty(value="promotionalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPromotionalDiscountPercent() {
        return this.promotionalDiscountPercent;
    }

    @JsonProperty(value="promotionalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
        this.promotionalDiscountPercent = promotionalDiscountPercent;
    }

    public LocalizedPriceConsumer channelDiscountPercent(Float channelDiscountPercent) {
        this.channelDiscountPercent = channelDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Channel discount percent")
    @JsonProperty(value="channelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getChannelDiscountPercent() {
        return this.channelDiscountPercent;
    }

    @JsonProperty(value="channelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelDiscountPercent(Float channelDiscountPercent) {
        this.channelDiscountPercent = channelDiscountPercent;
    }

    public LocalizedPriceConsumer premiumPercent(Float premiumPercent) {
        this.premiumPercent = premiumPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Premium percent")
    @JsonProperty(value="premiumPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPremiumPercent() {
        return this.premiumPercent;
    }

    @JsonProperty(value="premiumPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPremiumPercent(Float premiumPercent) {
        this.premiumPercent = premiumPercent;
    }

    public LocalizedPriceConsumer sourceTotal(MoneysConsumer sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(MoneysConsumer sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public LocalizedPriceConsumer userSpecifiedCurrencyTotal(MoneysConsumer userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(MoneysConsumer userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public LocalizedPriceConsumer internalTotal(MoneysConsumer internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(MoneysConsumer internalTotal) {
        this.internalTotal = internalTotal;
    }

    public LocalizedPriceConsumer hasPromotion(Boolean hasPromotion) {
        this.hasPromotion = hasPromotion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hasPromotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPromotion() {
        return this.hasPromotion;
    }

    @JsonProperty(value="hasPromotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPromotion(Boolean hasPromotion) {
        this.hasPromotion = hasPromotion;
    }

    public LocalizedPriceConsumer hasPremium(Boolean hasPremium) {
        this.hasPremium = hasPremium;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hasPremium")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPremium() {
        return this.hasPremium;
    }

    @JsonProperty(value="hasPremium")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPremium(Boolean hasPremium) {
        this.hasPremium = hasPremium;
    }

    public LocalizedPriceConsumer totalDiscountPercent(Float totalDiscountPercent) {
        this.totalDiscountPercent = totalDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalDiscountPercent() {
        return this.totalDiscountPercent;
    }

    @JsonProperty(value="totalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDiscountPercent(Float totalDiscountPercent) {
        this.totalDiscountPercent = totalDiscountPercent;
    }

    public LocalizedPriceConsumer hasChannelDiscount(Boolean hasChannelDiscount) {
        this.hasChannelDiscount = hasChannelDiscount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hasChannelDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasChannelDiscount() {
        return this.hasChannelDiscount;
    }

    @JsonProperty(value="hasChannelDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasChannelDiscount(Boolean hasChannelDiscount) {
        this.hasChannelDiscount = hasChannelDiscount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedPriceConsumer localizedPriceConsumer = (LocalizedPriceConsumer)o;
        return Objects.equals(this.sourceToUserCurrencyQuote, localizedPriceConsumer.sourceToUserCurrencyQuote) && Objects.equals(this.sourceToInternalCurrencyQuote, localizedPriceConsumer.sourceToInternalCurrencyQuote) && Objects.equals(this.userSpecifiedCurrencyBaseTotal, localizedPriceConsumer.userSpecifiedCurrencyBaseTotal) && Objects.equals(this.sourceBaseTotal, localizedPriceConsumer.sourceBaseTotal) && Objects.equals(this.internalBaseTotal, localizedPriceConsumer.internalBaseTotal) && Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, localizedPriceConsumer.userSpecifiedCurrencyPromotionalModifier) && Objects.equals(this.sourcePromotionalModifier, localizedPriceConsumer.sourcePromotionalModifier) && Objects.equals(this.internalPromotionalModifier, localizedPriceConsumer.internalPromotionalModifier) && Objects.equals(this.userSpecifiedCurrencyPremiumModifier, localizedPriceConsumer.userSpecifiedCurrencyPremiumModifier) && Objects.equals(this.sourcePremiumModifier, localizedPriceConsumer.sourcePremiumModifier) && Objects.equals(this.internalPremiumModifier, localizedPriceConsumer.internalPremiumModifier) && Objects.equals(this.userSpecifiedCurrencyChannelModifier, localizedPriceConsumer.userSpecifiedCurrencyChannelModifier) && Objects.equals(this.sourceChannelModifier, localizedPriceConsumer.sourceChannelModifier) && Objects.equals(this.internalChannelModifier, localizedPriceConsumer.internalChannelModifier) && Objects.equals(this.quantity, localizedPriceConsumer.quantity) && Objects.equals(this.promotionalDiscountPercent, localizedPriceConsumer.promotionalDiscountPercent) && Objects.equals(this.channelDiscountPercent, localizedPriceConsumer.channelDiscountPercent) && Objects.equals(this.premiumPercent, localizedPriceConsumer.premiumPercent) && Objects.equals(this.sourceTotal, localizedPriceConsumer.sourceTotal) && Objects.equals(this.userSpecifiedCurrencyTotal, localizedPriceConsumer.userSpecifiedCurrencyTotal) && Objects.equals(this.internalTotal, localizedPriceConsumer.internalTotal) && Objects.equals(this.hasPromotion, localizedPriceConsumer.hasPromotion) && Objects.equals(this.hasPremium, localizedPriceConsumer.hasPremium) && Objects.equals(this.totalDiscountPercent, localizedPriceConsumer.totalDiscountPercent) && Objects.equals(this.hasChannelDiscount, localizedPriceConsumer.hasChannelDiscount);
    }

    public int hashCode() {
        return Objects.hash(this.sourceToUserCurrencyQuote, this.sourceToInternalCurrencyQuote, this.userSpecifiedCurrencyBaseTotal, this.sourceBaseTotal, this.internalBaseTotal, this.userSpecifiedCurrencyPromotionalModifier, this.sourcePromotionalModifier, this.internalPromotionalModifier, this.userSpecifiedCurrencyPremiumModifier, this.sourcePremiumModifier, this.internalPremiumModifier, this.userSpecifiedCurrencyChannelModifier, this.sourceChannelModifier, this.internalChannelModifier, this.quantity, this.promotionalDiscountPercent, this.channelDiscountPercent, this.premiumPercent, this.sourceTotal, this.userSpecifiedCurrencyTotal, this.internalTotal, this.hasPromotion, this.hasPremium, this.totalDiscountPercent, this.hasChannelDiscount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocalizedPriceConsumer {\n");
        sb.append("    sourceToUserCurrencyQuote: ").append(this.toIndentedString(this.sourceToUserCurrencyQuote)).append("\n");
        sb.append("    sourceToInternalCurrencyQuote: ").append(this.toIndentedString(this.sourceToInternalCurrencyQuote)).append("\n");
        sb.append("    userSpecifiedCurrencyBaseTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyBaseTotal)).append("\n");
        sb.append("    sourceBaseTotal: ").append(this.toIndentedString(this.sourceBaseTotal)).append("\n");
        sb.append("    internalBaseTotal: ").append(this.toIndentedString(this.internalBaseTotal)).append("\n");
        sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyPromotionalModifier)).append("\n");
        sb.append("    sourcePromotionalModifier: ").append(this.toIndentedString(this.sourcePromotionalModifier)).append("\n");
        sb.append("    internalPromotionalModifier: ").append(this.toIndentedString(this.internalPromotionalModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyPremiumModifier)).append("\n");
        sb.append("    sourcePremiumModifier: ").append(this.toIndentedString(this.sourcePremiumModifier)).append("\n");
        sb.append("    internalPremiumModifier: ").append(this.toIndentedString(this.internalPremiumModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyChannelModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyChannelModifier)).append("\n");
        sb.append("    sourceChannelModifier: ").append(this.toIndentedString(this.sourceChannelModifier)).append("\n");
        sb.append("    internalChannelModifier: ").append(this.toIndentedString(this.internalChannelModifier)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    promotionalDiscountPercent: ").append(this.toIndentedString(this.promotionalDiscountPercent)).append("\n");
        sb.append("    channelDiscountPercent: ").append(this.toIndentedString(this.channelDiscountPercent)).append("\n");
        sb.append("    premiumPercent: ").append(this.toIndentedString(this.premiumPercent)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("    hasPromotion: ").append(this.toIndentedString(this.hasPromotion)).append("\n");
        sb.append("    hasPremium: ").append(this.toIndentedString(this.hasPremium)).append("\n");
        sb.append("    totalDiscountPercent: ").append(this.toIndentedString(this.totalDiscountPercent)).append("\n");
        sb.append("    hasChannelDiscount: ").append(this.toIndentedString(this.hasChannelDiscount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

