/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Lookup API Welcome to the Lookup API - A programmer-friendly way to search for bespoke travel inventory across geographic regions. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.lookup.model.RoomTypeWithPriceConfigurationConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Best-priced room at property
 */
@ApiModel(description = "Best-priced room at property")
@JsonPropertyOrder({
  RoomTypeWithBestPriceConsumer.JSON_PROPERTY_ROOM_TYPE_WITH_PRICE_CONFIGURATION,
  RoomTypeWithBestPriceConsumer.JSON_PROPERTY_PERK_VALUE,
  RoomTypeWithBestPriceConsumer.JSON_PROPERTY_AVAILABLE,
  RoomTypeWithBestPriceConsumer.JSON_PROPERTY_SORT
})
@JsonTypeName("RoomTypeWithBestPrice_Consumer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-24T11:14:39.269945519+07:00[Asia/Bangkok]")
public class RoomTypeWithBestPriceConsumer {
  public static final String JSON_PROPERTY_ROOM_TYPE_WITH_PRICE_CONFIGURATION = "roomTypeWithPriceConfiguration";
  private RoomTypeWithPriceConfigurationConsumer roomTypeWithPriceConfiguration;

  public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
  private Integer perkValue;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public RoomTypeWithBestPriceConsumer() { 
  }

  public RoomTypeWithBestPriceConsumer roomTypeWithPriceConfiguration(RoomTypeWithPriceConfigurationConsumer roomTypeWithPriceConfiguration) {
    
    this.roomTypeWithPriceConfiguration = roomTypeWithPriceConfiguration;
    return this;
  }

   /**
   * Get roomTypeWithPriceConfiguration
   * @return roomTypeWithPriceConfiguration
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_WITH_PRICE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomTypeWithPriceConfigurationConsumer getRoomTypeWithPriceConfiguration() {
    return roomTypeWithPriceConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_WITH_PRICE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypeWithPriceConfiguration(RoomTypeWithPriceConfigurationConsumer roomTypeWithPriceConfiguration) {
    this.roomTypeWithPriceConfiguration = roomTypeWithPriceConfiguration;
  }


  public RoomTypeWithBestPriceConsumer perkValue(Integer perkValue) {
    
    this.perkValue = perkValue;
    return this;
  }

   /**
   * The sum of all perks the master rate had made available.
   * @return perkValue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The sum of all perks the master rate had made available.")
  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkValue() {
    return perkValue;
  }


  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkValue(Integer perkValue) {
    this.perkValue = perkValue;
  }


  public RoomTypeWithBestPriceConsumer available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Whether this room type is available with this configuration
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether this room type is available with this configuration")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public RoomTypeWithBestPriceConsumer sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * When this room type is displayed in conjunction with many others, this sort property will often times be populated to indicate how the room types should be sorted and displayed.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "When this room type is displayed in conjunction with many others, this sort property will often times be populated to indicate how the room types should be sorted and displayed.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomTypeWithBestPriceConsumer roomTypeWithBestPriceConsumer = (RoomTypeWithBestPriceConsumer) o;
    return Objects.equals(this.roomTypeWithPriceConfiguration, roomTypeWithBestPriceConsumer.roomTypeWithPriceConfiguration) &&
        Objects.equals(this.perkValue, roomTypeWithBestPriceConsumer.perkValue) &&
        Objects.equals(this.available, roomTypeWithBestPriceConsumer.available) &&
        Objects.equals(this.sort, roomTypeWithBestPriceConsumer.sort);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roomTypeWithPriceConfiguration, perkValue, available, sort);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomTypeWithBestPriceConsumer {\n");
    sb.append("    roomTypeWithPriceConfiguration: ").append(toIndentedString(roomTypeWithPriceConfiguration)).append("\n");
    sb.append("    perkValue: ").append(toIndentedString(perkValue)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

