/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.lookup.model.GeoJsonPointConsumer;

@JsonPropertyOrder(value={"identifier", "type", "typeIdentifier", "name", "urlName", "ownerIdentifier", "ownerName", "cityName", "countryName", "subCountryName", "subSubCountryName", "countryCode", "ownerType", "languageCode", "sort", "origin", "lowercaseName", "locationX", "locationY", "location"})
@JsonTypeName(value="LookupCached_Consumer")
public class LookupCachedConsumer {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
    private UUID typeIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    private String urlName;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_CITY_NAME = "cityName";
    private String cityName;
    public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
    private String countryName;
    public static final String JSON_PROPERTY_SUB_COUNTRY_NAME = "subCountryName";
    private String subCountryName;
    public static final String JSON_PROPERTY_SUB_SUB_COUNTRY_NAME = "subSubCountryName";
    private String subSubCountryName;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_LANGUAGE_CODE = "languageCode";
    private String languageCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private Boolean origin;
    public static final String JSON_PROPERTY_LOWERCASE_NAME = "lowercaseName";
    private String lowercaseName;
    public static final String JSON_PROPERTY_LOCATION_X = "locationX";
    private Double locationX;
    public static final String JSON_PROPERTY_LOCATION_Y = "locationY";
    private Double locationY;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointConsumer location;

    public LookupCachedConsumer identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique lookup identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public LookupCachedConsumer type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVITY", value="Type of lookup")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LookupCachedConsumer typeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique lookup type identifier")
    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public LookupCachedConsumer name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Archery on horseback", value="Name of lookup")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public LookupCachedConsumer urlName(String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="archery-on-horseback", value="Url-friendly slug that uniquely identifies this lookup")
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public LookupCachedConsumer ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Lookup that is supplier inventory includes the supplier identifier")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public LookupCachedConsumer ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My Chic Hotel", value="Lookup that is supplier inventory includes the supplier name")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public LookupCachedConsumer cityName(String cityName) {
        this.cityName = cityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Los Angeles", value="Closest city where lookup entry is located")
    @JsonProperty(value="cityName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCityName() {
        return this.cityName;
    }

    @JsonProperty(value="cityName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public LookupCachedConsumer countryName(String countryName) {
        this.countryName = countryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="United States", value="Country where lookup entry is located")
    @JsonProperty(value="countryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryName() {
        return this.countryName;
    }

    @JsonProperty(value="countryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public LookupCachedConsumer subCountryName(String subCountryName) {
        this.subCountryName = subCountryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="California", value="State where lookup entry is located")
    @JsonProperty(value="subCountryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubCountryName() {
        return this.subCountryName;
    }

    @JsonProperty(value="subCountryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubCountryName(String subCountryName) {
        this.subCountryName = subCountryName;
    }

    public LookupCachedConsumer subSubCountryName(String subSubCountryName) {
        this.subSubCountryName = subSubCountryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Orange County", value="County where lookup entry is located")
    @JsonProperty(value="subSubCountryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubSubCountryName() {
        return this.subSubCountryName;
    }

    @JsonProperty(value="subSubCountryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubSubCountryName(String subSubCountryName) {
        this.subSubCountryName = subSubCountryName;
    }

    public LookupCachedConsumer countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", value="Country code")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public LookupCachedConsumer ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="HOTEL", value="The type of owner that created this lookup")
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public LookupCachedConsumer languageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en-US", value="The language the lookup code was written in")
    @JsonProperty(value="languageCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguageCode() {
        return this.languageCode;
    }

    @JsonProperty(value="languageCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public LookupCachedConsumer sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Platform-specific sort")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public LookupCachedConsumer origin(Boolean origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="If this lookup is the origin lookup.")
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(Boolean origin) {
        this.origin = origin;
    }

    public LookupCachedConsumer lowercaseName(String lowercaseName) {
        this.lowercaseName = lowercaseName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="archery on horseback", value="Name in lower case")
    @JsonProperty(value="lowercaseName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLowercaseName() {
        return this.lowercaseName;
    }

    @JsonProperty(value="lowercaseName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLowercaseName(String lowercaseName) {
        this.lowercaseName = lowercaseName;
    }

    public LookupCachedConsumer locationX(Double locationX) {
        this.locationX = locationX;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12.003455", value="Longitude")
    @JsonProperty(value="locationX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLocationX() {
        return this.locationX;
    }

    @JsonProperty(value="locationX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationX(Double locationX) {
        this.locationX = locationX;
    }

    public LookupCachedConsumer locationY(Double locationY) {
        this.locationY = locationY;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="25.012", value="Latitude")
    @JsonProperty(value="locationY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLocationY() {
        return this.locationY;
    }

    @JsonProperty(value="locationY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationY(Double locationY) {
        this.locationY = locationY;
    }

    public LookupCachedConsumer location(GeoJsonPointConsumer location) {
        this.location = location;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPointConsumer getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(GeoJsonPointConsumer location) {
        this.location = location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupCachedConsumer lookupCachedConsumer = (LookupCachedConsumer)o;
        return Objects.equals(this.identifier, lookupCachedConsumer.identifier) && Objects.equals((Object)this.type, (Object)lookupCachedConsumer.type) && Objects.equals(this.typeIdentifier, lookupCachedConsumer.typeIdentifier) && Objects.equals(this.name, lookupCachedConsumer.name) && Objects.equals(this.urlName, lookupCachedConsumer.urlName) && Objects.equals(this.ownerIdentifier, lookupCachedConsumer.ownerIdentifier) && Objects.equals(this.ownerName, lookupCachedConsumer.ownerName) && Objects.equals(this.cityName, lookupCachedConsumer.cityName) && Objects.equals(this.countryName, lookupCachedConsumer.countryName) && Objects.equals(this.subCountryName, lookupCachedConsumer.subCountryName) && Objects.equals(this.subSubCountryName, lookupCachedConsumer.subSubCountryName) && Objects.equals(this.countryCode, lookupCachedConsumer.countryCode) && Objects.equals((Object)this.ownerType, (Object)lookupCachedConsumer.ownerType) && Objects.equals(this.languageCode, lookupCachedConsumer.languageCode) && Objects.equals(this.sort, lookupCachedConsumer.sort) && Objects.equals(this.origin, lookupCachedConsumer.origin) && Objects.equals(this.lowercaseName, lookupCachedConsumer.lowercaseName) && Objects.equals(this.locationX, lookupCachedConsumer.locationX) && Objects.equals(this.locationY, lookupCachedConsumer.locationY) && Objects.equals(this.location, lookupCachedConsumer.location);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.type, this.typeIdentifier, this.name, this.urlName, this.ownerIdentifier, this.ownerName, this.cityName, this.countryName, this.subCountryName, this.subSubCountryName, this.countryCode, this.ownerType, this.languageCode, this.sort, this.origin, this.lowercaseName, this.locationX, this.locationY, this.location});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LookupCachedConsumer {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    typeIdentifier: ").append(this.toIndentedString(this.typeIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    cityName: ").append(this.toIndentedString(this.cityName)).append("\n");
        sb.append("    countryName: ").append(this.toIndentedString(this.countryName)).append("\n");
        sb.append("    subCountryName: ").append(this.toIndentedString(this.subCountryName)).append("\n");
        sb.append("    subSubCountryName: ").append(this.toIndentedString(this.subSubCountryName)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    lowercaseName: ").append(this.toIndentedString(this.lowercaseName)).append("\n");
        sb.append("    locationX: ").append(this.toIndentedString(this.locationX)).append("\n");
        sb.append("    locationY: ").append(this.toIndentedString(this.locationY)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CITY("CITY"),
        ISLAND("ISLAND"),
        HOTEL("HOTEL"),
        SPA("SPA"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        ATTRACTION("ATTRACTION"),
        ACTIVITY("ACTIVITY"),
        PLACE("PLACE"),
        COUNTRY("COUNTRY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OwnerTypeEnum {
        TRAVELIKO("TRAVELIKO"),
        HOTEL("HOTEL");

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

