package travel.wink.sdk.lookup.api;

import travel.wink.sdk.lookup.invoker.ApiClient;

import travel.wink.sdk.lookup.model.CityScoreRequestConsumer;
import travel.wink.sdk.lookup.model.CitySearchRequestConsumer;
import travel.wink.sdk.lookup.model.CountryScoreRequestConsumer;
import travel.wink.sdk.lookup.model.GenericErrorMessage;
import travel.wink.sdk.lookup.model.GlobalScoreRequestConsumer;
import travel.wink.sdk.lookup.model.LookupCachedConsumer;
import travel.wink.sdk.lookup.model.LookupConsumer;
import travel.wink.sdk.lookup.model.MapRequestConsumer;
import travel.wink.sdk.lookup.model.Oauth2SearchByGeoLocation400Response;
import travel.wink.sdk.lookup.model.PageHotelWithBestPriceConsumer;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-06T14:59:40.626118928+07:00[Asia/Bangkok]")
public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequestConsumer The cityScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ScoreInventoryByCityRequestCreation(CityScoreRequestConsumer cityScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = cityScoreRequestConsumer;
        // verify the required parameter 'cityScoreRequestConsumer' is set
        if (cityScoreRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequestConsumer' when calling oauth2ScoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequestConsumer The cityScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceConsumer> oauth2ScoreInventoryByCity(CityScoreRequestConsumer cityScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequestConsumer The cityScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2ScoreInventoryByCityWithHttpInfo(CityScoreRequestConsumer cityScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequestConsumer The cityScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ScoreInventoryByCityWithResponseSpec(CityScoreRequestConsumer cityScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequestConsumer The mapRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchByGeoLocationRequestCreation(MapRequestConsumer mapRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = mapRequestConsumer;
        // verify the required parameter 'mapRequestConsumer' is set
        if (mapRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequestConsumer' when calling oauth2SearchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequestConsumer The mapRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceConsumer> oauth2SearchByGeoLocation(MapRequestConsumer mapRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2SearchByGeoLocationRequestCreation(mapRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequestConsumer The mapRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2SearchByGeoLocationWithHttpInfo(MapRequestConsumer mapRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2SearchByGeoLocationRequestCreation(mapRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequestConsumer The mapRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchByGeoLocationWithResponseSpec(MapRequestConsumer mapRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2SearchByGeoLocationRequestCreation(mapRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequestConsumer The citySearchRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchInventoryByCityRequestCreation(CitySearchRequestConsumer citySearchRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = citySearchRequestConsumer;
        // verify the required parameter 'citySearchRequestConsumer' is set
        if (citySearchRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequestConsumer' when calling oauth2SearchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequestConsumer The citySearchRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceConsumer> oauth2SearchInventoryByCity(CitySearchRequestConsumer citySearchRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequestConsumer The citySearchRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2SearchInventoryByCityWithHttpInfo(CitySearchRequestConsumer citySearchRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequestConsumer The citySearchRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchInventoryByCityWithResponseSpec(CitySearchRequestConsumer citySearchRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequestConsumer The countryScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchScoreByCountryRequestCreation(CountryScoreRequestConsumer countryScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = countryScoreRequestConsumer;
        // verify the required parameter 'countryScoreRequestConsumer' is set
        if (countryScoreRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequestConsumer' when calling oauth2SearchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequestConsumer The countryScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceConsumer> oauth2SearchScoreByCountry(CountryScoreRequestConsumer countryScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequestConsumer The countryScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2SearchScoreByCountryWithHttpInfo(CountryScoreRequestConsumer countryScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequestConsumer The countryScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchScoreByCountryWithResponseSpec(CountryScoreRequestConsumer countryScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequestConsumer The globalScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchScoreByGlobalRequestCreation(GlobalScoreRequestConsumer globalScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = globalScoreRequestConsumer;
        // verify the required parameter 'globalScoreRequestConsumer' is set
        if (globalScoreRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequestConsumer' when calling oauth2SearchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequestConsumer The globalScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceConsumer> oauth2SearchScoreByGlobal(GlobalScoreRequestConsumer globalScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequestConsumer The globalScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2SearchScoreByGlobalWithHttpInfo(GlobalScoreRequestConsumer globalScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>() {};
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequestConsumer The globalScoreRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchScoreByGlobalWithResponseSpec(GlobalScoreRequestConsumer globalScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @return List&lt;LookupCachedConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchSuggestionsRequestCreation(String term, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'term' is set
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling oauth2SearchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "term", term));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LookupCachedConsumer> localVarReturnType = new ParameterizedTypeReference<LookupCachedConsumer>() {};
        return apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @return List&lt;LookupCachedConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LookupCachedConsumer> oauth2SearchSuggestions(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedConsumer> localVarReturnType = new ParameterizedTypeReference<LookupCachedConsumer>() {};
        return oauth2SearchSuggestionsRequestCreation(term, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;LookupCachedConsumer&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<LookupCachedConsumer>>> oauth2SearchSuggestionsWithHttpInfo(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedConsumer> localVarReturnType = new ParameterizedTypeReference<LookupCachedConsumer>() {};
        return oauth2SearchSuggestionsRequestCreation(term, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchSuggestionsWithResponseSpec(String term, String winkVersion) throws WebClientResponseException {
        return oauth2SearchSuggestionsRequestCreation(term, winkVersion);
    }
    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @return LookupConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowLookupRequestCreation(String urlName, String type, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'urlName' is set
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("urlName", urlName);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LookupConsumer> localVarReturnType = new ParameterizedTypeReference<LookupConsumer>() {};
        return apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @return LookupConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<LookupConsumer> oauth2ShowLookup(String urlName, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupConsumer> localVarReturnType = new ParameterizedTypeReference<LookupConsumer>() {};
        return oauth2ShowLookupRequestCreation(urlName, type, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;LookupConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<LookupConsumer>> oauth2ShowLookupWithHttpInfo(String urlName, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupConsumer> localVarReturnType = new ParameterizedTypeReference<LookupConsumer>() {};
        return oauth2ShowLookupRequestCreation(urlName, type, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowLookupWithResponseSpec(String urlName, String type, String winkVersion) throws WebClientResponseException {
        return oauth2ShowLookupRequestCreation(urlName, type, winkVersion);
    }
}
