/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Lookup API Welcome to the Lookup API - A programmer-friendly way to search for bespoke travel inventory across geographic regions. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.1.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.lookup.model.MoneysConsumer;
import travel.wink.sdk.lookup.model.QuoteConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Localized price
 */
@JsonPropertyOrder({
  LocalizedPriceConsumer.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  LocalizedPriceConsumer.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  LocalizedPriceConsumer.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL,
  LocalizedPriceConsumer.JSON_PROPERTY_SOURCE_BASE_TOTAL,
  LocalizedPriceConsumer.JSON_PROPERTY_INTERNAL_BASE_TOTAL,
  LocalizedPriceConsumer.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  LocalizedPriceConsumer.JSON_PROPERTY_QUANTITY,
  LocalizedPriceConsumer.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  LocalizedPriceConsumer.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  LocalizedPriceConsumer.JSON_PROPERTY_PREMIUM_PERCENT,
  LocalizedPriceConsumer.JSON_PROPERTY_SOURCE_TOTAL,
  LocalizedPriceConsumer.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  LocalizedPriceConsumer.JSON_PROPERTY_INTERNAL_TOTAL,
  LocalizedPriceConsumer.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT,
  LocalizedPriceConsumer.JSON_PROPERTY_HAS_CHANNEL_DISCOUNT,
  LocalizedPriceConsumer.JSON_PROPERTY_HAS_PREMIUM,
  LocalizedPriceConsumer.JSON_PROPERTY_HAS_PROMOTION
})
@JsonTypeName("LocalizedPrice_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-06T14:59:40.626118928+07:00[Asia/Bangkok]")
public class LocalizedPriceConsumer {
  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private QuoteConsumer sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private QuoteConsumer sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
  private MoneysConsumer userSpecifiedCurrencyBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
  private MoneysConsumer sourceBaseTotal;

  public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
  private MoneysConsumer internalBaseTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private Double userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private Double sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private Double internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private Double userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private Double sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private Double internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private Double userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private Double sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private Double internalChannelModifier;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity = 1;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private MoneysConsumer sourceTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private MoneysConsumer userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private MoneysConsumer internalTotal;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public static final String JSON_PROPERTY_HAS_CHANNEL_DISCOUNT = "hasChannelDiscount";
  private Boolean hasChannelDiscount;

  public static final String JSON_PROPERTY_HAS_PREMIUM = "hasPremium";
  private Boolean hasPremium;

  public static final String JSON_PROPERTY_HAS_PROMOTION = "hasPromotion";
  private Boolean hasPromotion;

  public LocalizedPriceConsumer() {
  }

  public LocalizedPriceConsumer sourceToUserCurrencyQuote(QuoteConsumer sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteConsumer getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToUserCurrencyQuote(QuoteConsumer sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public LocalizedPriceConsumer sourceToInternalCurrencyQuote(QuoteConsumer sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteConsumer getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToInternalCurrencyQuote(QuoteConsumer sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public LocalizedPriceConsumer userSpecifiedCurrencyBaseTotal(MoneysConsumer userSpecifiedCurrencyBaseTotal) {
    
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseTotal
   * @return userSpecifiedCurrencyBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysConsumer getUserSpecifiedCurrencyBaseTotal() {
    return userSpecifiedCurrencyBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSpecifiedCurrencyBaseTotal(MoneysConsumer userSpecifiedCurrencyBaseTotal) {
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
  }


  public LocalizedPriceConsumer sourceBaseTotal(MoneysConsumer sourceBaseTotal) {
    
    this.sourceBaseTotal = sourceBaseTotal;
    return this;
  }

   /**
   * Get sourceBaseTotal
   * @return sourceBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysConsumer getSourceBaseTotal() {
    return sourceBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceBaseTotal(MoneysConsumer sourceBaseTotal) {
    this.sourceBaseTotal = sourceBaseTotal;
  }


  public LocalizedPriceConsumer internalBaseTotal(MoneysConsumer internalBaseTotal) {
    
    this.internalBaseTotal = internalBaseTotal;
    return this;
  }

   /**
   * Get internalBaseTotal
   * @return internalBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysConsumer getInternalBaseTotal() {
    return internalBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalBaseTotal(MoneysConsumer internalBaseTotal) {
    this.internalBaseTotal = internalBaseTotal;
  }


  public LocalizedPriceConsumer userSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in user specified currency
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public LocalizedPriceConsumer sourcePromotionalModifier(Double sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in hotel currency
   * @return sourcePromotionalModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(Double sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public LocalizedPriceConsumer internalPromotionalModifier(Double internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in wink currency
   * @return internalPromotionalModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(Double internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public LocalizedPriceConsumer userSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in user specified currency
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public LocalizedPriceConsumer sourcePremiumModifier(Double sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in hotel currency
   * @return sourcePremiumModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(Double sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public LocalizedPriceConsumer internalPremiumModifier(Double internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in wink currency
   * @return internalPremiumModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(Double internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public LocalizedPriceConsumer userSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in user specified currency
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public LocalizedPriceConsumer sourceChannelModifier(Double sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in hotel currency
   * @return sourceChannelModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(Double sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public LocalizedPriceConsumer internalChannelModifier(Double internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in wink currency
   * @return internalChannelModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(Double internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public LocalizedPriceConsumer quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * How many of this item is included in this price
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public LocalizedPriceConsumer promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Promotional discount percent
   * @return promotionalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public LocalizedPriceConsumer channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Channel discount percent
   * @return channelDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public LocalizedPriceConsumer premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Premium percent
   * @return premiumPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public LocalizedPriceConsumer sourceTotal(MoneysConsumer sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysConsumer getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(MoneysConsumer sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public LocalizedPriceConsumer userSpecifiedCurrencyTotal(MoneysConsumer userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysConsumer getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(MoneysConsumer userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public LocalizedPriceConsumer internalTotal(MoneysConsumer internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysConsumer getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(MoneysConsumer internalTotal) {
    this.internalTotal = internalTotal;
  }


  public LocalizedPriceConsumer totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }


  public LocalizedPriceConsumer hasChannelDiscount(Boolean hasChannelDiscount) {
    
    this.hasChannelDiscount = hasChannelDiscount;
    return this;
  }

   /**
   * Get hasChannelDiscount
   * @return hasChannelDiscount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasChannelDiscount() {
    return hasChannelDiscount;
  }


  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasChannelDiscount(Boolean hasChannelDiscount) {
    this.hasChannelDiscount = hasChannelDiscount;
  }


  public LocalizedPriceConsumer hasPremium(Boolean hasPremium) {
    
    this.hasPremium = hasPremium;
    return this;
  }

   /**
   * Get hasPremium
   * @return hasPremium
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPremium() {
    return hasPremium;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPremium(Boolean hasPremium) {
    this.hasPremium = hasPremium;
  }


  public LocalizedPriceConsumer hasPromotion(Boolean hasPromotion) {
    
    this.hasPromotion = hasPromotion;
    return this;
  }

   /**
   * Get hasPromotion
   * @return hasPromotion
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPromotion() {
    return hasPromotion;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPromotion(Boolean hasPromotion) {
    this.hasPromotion = hasPromotion;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LocalizedPriceConsumer localizedPriceConsumer = (LocalizedPriceConsumer) o;
    return Objects.equals(this.sourceToUserCurrencyQuote, localizedPriceConsumer.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, localizedPriceConsumer.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.userSpecifiedCurrencyBaseTotal, localizedPriceConsumer.userSpecifiedCurrencyBaseTotal) &&
        Objects.equals(this.sourceBaseTotal, localizedPriceConsumer.sourceBaseTotal) &&
        Objects.equals(this.internalBaseTotal, localizedPriceConsumer.internalBaseTotal) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, localizedPriceConsumer.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePromotionalModifier, localizedPriceConsumer.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, localizedPriceConsumer.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, localizedPriceConsumer.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourcePremiumModifier, localizedPriceConsumer.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, localizedPriceConsumer.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, localizedPriceConsumer.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.sourceChannelModifier, localizedPriceConsumer.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, localizedPriceConsumer.internalChannelModifier) &&
        Objects.equals(this.quantity, localizedPriceConsumer.quantity) &&
        Objects.equals(this.promotionalDiscountPercent, localizedPriceConsumer.promotionalDiscountPercent) &&
        Objects.equals(this.channelDiscountPercent, localizedPriceConsumer.channelDiscountPercent) &&
        Objects.equals(this.premiumPercent, localizedPriceConsumer.premiumPercent) &&
        Objects.equals(this.sourceTotal, localizedPriceConsumer.sourceTotal) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, localizedPriceConsumer.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, localizedPriceConsumer.internalTotal) &&
        Objects.equals(this.totalDiscountPercent, localizedPriceConsumer.totalDiscountPercent) &&
        Objects.equals(this.hasChannelDiscount, localizedPriceConsumer.hasChannelDiscount) &&
        Objects.equals(this.hasPremium, localizedPriceConsumer.hasPremium) &&
        Objects.equals(this.hasPromotion, localizedPriceConsumer.hasPromotion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, userSpecifiedCurrencyBaseTotal, sourceBaseTotal, internalBaseTotal, userSpecifiedCurrencyPromotionalModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPremiumModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyChannelModifier, sourceChannelModifier, internalChannelModifier, quantity, promotionalDiscountPercent, channelDiscountPercent, premiumPercent, sourceTotal, userSpecifiedCurrencyTotal, internalTotal, totalDiscountPercent, hasChannelDiscount, hasPremium, hasPromotion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LocalizedPriceConsumer {\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    userSpecifiedCurrencyBaseTotal: ").append(toIndentedString(userSpecifiedCurrencyBaseTotal)).append("\n");
    sb.append("    sourceBaseTotal: ").append(toIndentedString(sourceBaseTotal)).append("\n");
    sb.append("    internalBaseTotal: ").append(toIndentedString(internalBaseTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("    hasChannelDiscount: ").append(toIndentedString(hasChannelDiscount)).append("\n");
    sb.append("    hasPremium: ").append(toIndentedString(hasPremium)).append("\n");
    sb.append("    hasPromotion: ").append(toIndentedString(hasPromotion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

