/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.lookup.model.LocalizedDescriptionConsumer;
import travel.wink.sdk.lookup.model.LocalizedPriceConsumer;
import travel.wink.sdk.lookup.model.SimpleDescriptionConsumer;
import travel.wink.sdk.lookup.model.SimpleMultimediaConsumer;

@JsonPropertyOrder(value={"identifier", "name", "descriptions", "pricingType", "price", "multimedias", "minPax", "maxPax", "offerDetails", "promotion"})
@JsonTypeName(value="LocalizedTransactionalTravelInventory_Consumer")
public class LocalizedTransactionalTravelInventoryConsumer {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionConsumer> descriptions = new ArrayList<SimpleDescriptionConsumer>();
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_PRICE = "price";
    private LocalizedPriceConsumer price;
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaConsumer> multimedias;
    public static final String JSON_PROPERTY_MIN_PAX = "minPax";
    private Integer minPax;
    public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
    private Integer maxPax;
    public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
    private List<LocalizedDescriptionConsumer> offerDetails;
    public static final String JSON_PROPERTY_PROMOTION = "promotion";
    private String promotion;

    public LocalizedTransactionalTravelInventoryConsumer identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public LocalizedTransactionalTravelInventoryConsumer name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public LocalizedTransactionalTravelInventoryConsumer descriptions(List<SimpleDescriptionConsumer> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public LocalizedTransactionalTravelInventoryConsumer addDescriptionsItem(SimpleDescriptionConsumer descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionConsumer>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescriptionConsumer> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionConsumer> descriptions) {
        this.descriptions = descriptions;
    }

    public LocalizedTransactionalTravelInventoryConsumer pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public LocalizedTransactionalTravelInventoryConsumer price(LocalizedPriceConsumer price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalizedPriceConsumer getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(LocalizedPriceConsumer price) {
        this.price = price;
    }

    public LocalizedTransactionalTravelInventoryConsumer multimedias(List<SimpleMultimediaConsumer> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public LocalizedTransactionalTravelInventoryConsumer addMultimediasItem(SimpleMultimediaConsumer multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaConsumer>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleMultimediaConsumer> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultimedias(List<SimpleMultimediaConsumer> multimedias) {
        this.multimedias = multimedias;
    }

    public LocalizedTransactionalTravelInventoryConsumer minPax(Integer minPax) {
        this.minPax = minPax;
        return this;
    }

    @Nullable
    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinPax() {
        return this.minPax;
    }

    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinPax(Integer minPax) {
        this.minPax = minPax;
    }

    public LocalizedTransactionalTravelInventoryConsumer maxPax(Integer maxPax) {
        this.maxPax = maxPax;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxPax() {
        return this.maxPax;
    }

    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxPax(Integer maxPax) {
        this.maxPax = maxPax;
    }

    public LocalizedTransactionalTravelInventoryConsumer offerDetails(List<LocalizedDescriptionConsumer> offerDetails) {
        this.offerDetails = offerDetails;
        return this;
    }

    public LocalizedTransactionalTravelInventoryConsumer addOfferDetailsItem(LocalizedDescriptionConsumer offerDetailsItem) {
        if (this.offerDetails == null) {
            this.offerDetails = new ArrayList<LocalizedDescriptionConsumer>();
        }
        this.offerDetails.add(offerDetailsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="offerDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalizedDescriptionConsumer> getOfferDetails() {
        return this.offerDetails;
    }

    @JsonProperty(value="offerDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOfferDetails(List<LocalizedDescriptionConsumer> offerDetails) {
        this.offerDetails = offerDetails;
    }

    public LocalizedTransactionalTravelInventoryConsumer promotion(String promotion) {
        this.promotion = promotion;
        return this;
    }

    @Nullable
    @JsonProperty(value="promotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPromotion() {
        return this.promotion;
    }

    @JsonProperty(value="promotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotion(String promotion) {
        this.promotion = promotion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedTransactionalTravelInventoryConsumer localizedTransactionalTravelInventoryConsumer = (LocalizedTransactionalTravelInventoryConsumer)o;
        return Objects.equals(this.identifier, localizedTransactionalTravelInventoryConsumer.identifier) && Objects.equals(this.name, localizedTransactionalTravelInventoryConsumer.name) && Objects.equals(this.descriptions, localizedTransactionalTravelInventoryConsumer.descriptions) && Objects.equals((Object)this.pricingType, (Object)localizedTransactionalTravelInventoryConsumer.pricingType) && Objects.equals(this.price, localizedTransactionalTravelInventoryConsumer.price) && Objects.equals(this.multimedias, localizedTransactionalTravelInventoryConsumer.multimedias) && Objects.equals(this.minPax, localizedTransactionalTravelInventoryConsumer.minPax) && Objects.equals(this.maxPax, localizedTransactionalTravelInventoryConsumer.maxPax) && Objects.equals(this.offerDetails, localizedTransactionalTravelInventoryConsumer.offerDetails) && Objects.equals(this.promotion, localizedTransactionalTravelInventoryConsumer.promotion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.descriptions, this.pricingType, this.price, this.multimedias, this.minPax, this.maxPax, this.offerDetails, this.promotion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocalizedTransactionalTravelInventoryConsumer {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    minPax: ").append(this.toIndentedString(this.minPax)).append("\n");
        sb.append("    maxPax: ").append(this.toIndentedString(this.maxPax)).append("\n");
        sb.append("    offerDetails: ").append(this.toIndentedString(this.offerDetails)).append("\n");
        sb.append("    promotion: ").append(this.toIndentedString(this.promotion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

