/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Lookup API Welcome to the Lookup API - A programmer-friendly way to search for bespoke travel inventory across geographic regions. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.lookup.model.AddOnLocalizedInventoryConsumer;
import travel.wink.sdk.lookup.model.CancellationPolicyConsumer;
import travel.wink.sdk.lookup.model.CustomMonetaryAmount;
import travel.wink.sdk.lookup.model.ExtraChargesConsumer;
import travel.wink.sdk.lookup.model.LocalizedTransactionalTravelInventoryConsumer;
import travel.wink.sdk.lookup.model.RatePlanConsumer;
import travel.wink.sdk.lookup.model.RoomConfigurationConsumer;
import travel.wink.sdk.lookup.model.StayRateConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RoomConfigurationPriceConsumer
 */
@JsonPropertyOrder({
  RoomConfigurationPriceConsumer.JSON_PROPERTY_ADULTS,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_CHILDREN,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_START_DATE,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_END_DATE,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_RATE_PLAN,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_PERK_TYPES,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_PRICE,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_EXTRA_CHARGES,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_CONFIGURATION,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_ADD_ON_OFFERS,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_PERK_VALUE,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_ROOM_NIGHTS,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_LIST,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_COMMISSIONABLE,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_COMMISSION,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_PRICE_LIST,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_RATE_SOURCE,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_AVAILABLE,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_SOURCE_TOTAL,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  RoomConfigurationPriceConsumer.JSON_PROPERTY_INTERNAL_TOTAL
})
@JsonTypeName("RoomConfigurationPrice_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:19:25.641313700+07:00[Asia/Bangkok]")
public class RoomConfigurationPriceConsumer {
  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private String roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  private RatePlanConsumer ratePlan;

  /**
   * Perks that accompany the master rate
   */
  public enum PerkTypesEnum {
    LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
    
    WINE("PERK_WINE"),
    
    FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
    
    FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
    
    FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
    
    TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
    
    TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
    
    GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
    
    EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
    
    ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
    
    LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
    
    AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
    
    AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
    
    BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
    
    BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
    
    BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

    private String value;

    PerkTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PerkTypesEnum fromValue(String value) {
      for (PerkTypesEnum b : PerkTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  private List<PerkTypesEnum> perkTypes;

  public static final String JSON_PROPERTY_PRICE = "price";
  private StayRateConsumer price;

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  private ExtraChargesConsumer extraCharges;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  private RoomConfigurationConsumer _configuration;

  public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
  private List<AddOnLocalizedInventoryConsumer> addOnOffers;

  public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
  private Integer perkValue;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  private CancellationPolicyConsumer activeCancellationPolicy;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  private Integer roomNights;

  public static final String JSON_PROPERTY_LIST = "list";
  private List<LocalizedTransactionalTravelInventoryConsumer> _list;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private String channelInventoryIdentifier;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
  private List<LocalizedTransactionalTravelInventoryConsumer> priceList;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private String rateSource;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private CustomMonetaryAmount internalTotal;

  public RoomConfigurationPriceConsumer() {
  }

  public RoomConfigurationPriceConsumer adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * The actual amount of adults as determined by the hotel&#39;s policy
   * @return adults
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public RoomConfigurationPriceConsumer children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * The actual amount of children as determined by the hotel&#39;s policy
   * @return children
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public RoomConfigurationPriceConsumer startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Itinerary startDate
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public RoomConfigurationPriceConsumer endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Itinerary endDate
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public RoomConfigurationPriceConsumer roomRateIdentifier(String roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Specified master rate identifier
   * @return roomRateIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(String roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public RoomConfigurationPriceConsumer roomRateInternalName(String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

   /**
   * Specified master rate internal name
   * @return roomRateInternalName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateInternalName(String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }


  public RoomConfigurationPriceConsumer ratePlan(RatePlanConsumer ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

   /**
   * Get ratePlan
   * @return ratePlan
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RatePlanConsumer getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlan(RatePlanConsumer ratePlan) {
    this.ratePlan = ratePlan;
  }


  public RoomConfigurationPriceConsumer perkTypes(List<PerkTypesEnum> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public RoomConfigurationPriceConsumer addPerkTypesItem(PerkTypesEnum perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

   /**
   * Get perkTypes
   * @return perkTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PerkTypesEnum> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
    this.perkTypes = perkTypes;
  }


  public RoomConfigurationPriceConsumer price(StayRateConsumer price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StayRateConsumer getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(StayRateConsumer price) {
    this.price = price;
  }


  public RoomConfigurationPriceConsumer extraCharges(ExtraChargesConsumer extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

   /**
   * Get extraCharges
   * @return extraCharges
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExtraChargesConsumer getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraCharges(ExtraChargesConsumer extraCharges) {
    this.extraCharges = extraCharges;
  }


  public RoomConfigurationPriceConsumer _configuration(RoomConfigurationConsumer _configuration) {
    
    this._configuration = _configuration;
    return this;
  }

   /**
   * Get _configuration
   * @return _configuration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationConsumer getConfiguration() {
    return _configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConfiguration(RoomConfigurationConsumer _configuration) {
    this._configuration = _configuration;
  }


  public RoomConfigurationPriceConsumer addOnOffers(List<AddOnLocalizedInventoryConsumer> addOnOffers) {
    
    this.addOnOffers = addOnOffers;
    return this;
  }

  public RoomConfigurationPriceConsumer addAddOnOffersItem(AddOnLocalizedInventoryConsumer addOnOffersItem) {
    if (this.addOnOffers == null) {
      this.addOnOffers = new ArrayList<>();
    }
    this.addOnOffers.add(addOnOffersItem);
    return this;
  }

   /**
   * Get addOnOffers
   * @return addOnOffers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AddOnLocalizedInventoryConsumer> getAddOnOffers() {
    return addOnOffers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnOffers(List<AddOnLocalizedInventoryConsumer> addOnOffers) {
    this.addOnOffers = addOnOffers;
  }


  public RoomConfigurationPriceConsumer perkValue(Integer perkValue) {
    
    this.perkValue = perkValue;
    return this;
  }

   /**
   * The combined value of these perks
   * @return perkValue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkValue() {
    return perkValue;
  }


  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkValue(Integer perkValue) {
    this.perkValue = perkValue;
  }


  public RoomConfigurationPriceConsumer activeCancellationPolicy(CancellationPolicyConsumer activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

   /**
   * Get activeCancellationPolicy
   * @return activeCancellationPolicy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellationPolicyConsumer getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActiveCancellationPolicy(CancellationPolicyConsumer activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }


  public RoomConfigurationPriceConsumer roomNights(Integer roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

   /**
   * Number of nights the guests will be staying
   * @return roomNights
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomNights(Integer roomNights) {
    this.roomNights = roomNights;
  }


  public RoomConfigurationPriceConsumer _list(List<LocalizedTransactionalTravelInventoryConsumer> _list) {
    
    this._list = _list;
    return this;
  }

  public RoomConfigurationPriceConsumer addListItem(LocalizedTransactionalTravelInventoryConsumer _listItem) {
    if (this._list == null) {
      this._list = new ArrayList<>();
    }
    this._list.add(_listItem);
    return this;
  }

   /**
   * Get _list
   * @return _list
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedTransactionalTravelInventoryConsumer> getList() {
    return _list;
  }


  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setList(List<LocalizedTransactionalTravelInventoryConsumer> _list) {
    this._list = _list;
  }


  public RoomConfigurationPriceConsumer channelInventoryIdentifier(String channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Sales channel inventory identifier
   * @return channelInventoryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(String channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public RoomConfigurationPriceConsumer commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Whether this package is commissionable based on the incoming sales channel.
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public RoomConfigurationPriceConsumer commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * The commission percentage.
   * @return commission
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  public RoomConfigurationPriceConsumer priceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
    
    this.priceList = priceList;
    return this;
  }

  public RoomConfigurationPriceConsumer addPriceListItem(LocalizedTransactionalTravelInventoryConsumer priceListItem) {
    if (this.priceList == null) {
      this.priceList = new ArrayList<>();
    }
    this.priceList.add(priceListItem);
    return this;
  }

   /**
   * Get priceList
   * @return priceList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedTransactionalTravelInventoryConsumer> getPriceList() {
    return priceList;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
    this.priceList = priceList;
  }


  public RoomConfigurationPriceConsumer rateSource(String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Get rateSource
   * @return rateSource
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(String rateSource) {
    this.rateSource = rateSource;
  }


  public RoomConfigurationPriceConsumer available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Get available
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public RoomConfigurationPriceConsumer sourceTotal(CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public RoomConfigurationPriceConsumer userSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public RoomConfigurationPriceConsumer internalTotal(CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomConfigurationPriceConsumer roomConfigurationPriceConsumer = (RoomConfigurationPriceConsumer) o;
    return Objects.equals(this.adults, roomConfigurationPriceConsumer.adults) &&
        Objects.equals(this.children, roomConfigurationPriceConsumer.children) &&
        Objects.equals(this.startDate, roomConfigurationPriceConsumer.startDate) &&
        Objects.equals(this.endDate, roomConfigurationPriceConsumer.endDate) &&
        Objects.equals(this.roomRateIdentifier, roomConfigurationPriceConsumer.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, roomConfigurationPriceConsumer.roomRateInternalName) &&
        Objects.equals(this.ratePlan, roomConfigurationPriceConsumer.ratePlan) &&
        Objects.equals(this.perkTypes, roomConfigurationPriceConsumer.perkTypes) &&
        Objects.equals(this.price, roomConfigurationPriceConsumer.price) &&
        Objects.equals(this.extraCharges, roomConfigurationPriceConsumer.extraCharges) &&
        Objects.equals(this._configuration, roomConfigurationPriceConsumer._configuration) &&
        Objects.equals(this.addOnOffers, roomConfigurationPriceConsumer.addOnOffers) &&
        Objects.equals(this.perkValue, roomConfigurationPriceConsumer.perkValue) &&
        Objects.equals(this.activeCancellationPolicy, roomConfigurationPriceConsumer.activeCancellationPolicy) &&
        Objects.equals(this.roomNights, roomConfigurationPriceConsumer.roomNights) &&
        Objects.equals(this._list, roomConfigurationPriceConsumer._list) &&
        Objects.equals(this.channelInventoryIdentifier, roomConfigurationPriceConsumer.channelInventoryIdentifier) &&
        Objects.equals(this.commissionable, roomConfigurationPriceConsumer.commissionable) &&
        Objects.equals(this.commission, roomConfigurationPriceConsumer.commission) &&
        Objects.equals(this.priceList, roomConfigurationPriceConsumer.priceList) &&
        Objects.equals(this.rateSource, roomConfigurationPriceConsumer.rateSource) &&
        Objects.equals(this.available, roomConfigurationPriceConsumer.available) &&
        Objects.equals(this.sourceTotal, roomConfigurationPriceConsumer.sourceTotal) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, roomConfigurationPriceConsumer.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, roomConfigurationPriceConsumer.internalTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adults, children, startDate, endDate, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, price, extraCharges, _configuration, addOnOffers, perkValue, activeCancellationPolicy, roomNights, _list, channelInventoryIdentifier, commissionable, commission, priceList, rateSource, available, sourceTotal, userSpecifiedCurrencyTotal, internalTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomConfigurationPriceConsumer {\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    addOnOffers: ").append(toIndentedString(addOnOffers)).append("\n");
    sb.append("    perkValue: ").append(toIndentedString(perkValue)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    _list: ").append(toIndentedString(_list)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    priceList: ").append(toIndentedString(priceList)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

