/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.lookup.model.UserSessionNonAuthenticatedEntity;

@JsonPropertyOrder(value={"userSession", "hotelIdentifiers", "page", "size"})
@JsonTypeName(value="MapRequest_Non_Authenticated_Entity")
public class MapRequestNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSessionNonAuthenticatedEntity userSession;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIERS = "hotelIdentifiers";
    private List<UUID> hotelIdentifiers;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size;

    public MapRequestNonAuthenticatedEntity userSession(UserSessionNonAuthenticatedEntity userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSessionNonAuthenticatedEntity getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSessionNonAuthenticatedEntity userSession) {
        this.userSession = userSession;
    }

    public MapRequestNonAuthenticatedEntity hotelIdentifiers(List<UUID> hotelIdentifiers) {
        this.hotelIdentifiers = hotelIdentifiers;
        return this;
    }

    public MapRequestNonAuthenticatedEntity addHotelIdentifiersItem(UUID hotelIdentifiersItem) {
        if (this.hotelIdentifiers == null) {
            this.hotelIdentifiers = new ArrayList<UUID>();
        }
        this.hotelIdentifiers.add(hotelIdentifiersItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="hotelIdentifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getHotelIdentifiers() {
        return this.hotelIdentifiers;
    }

    @JsonProperty(value="hotelIdentifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifiers(List<UUID> hotelIdentifiers) {
        this.hotelIdentifiers = hotelIdentifiers;
    }

    public MapRequestNonAuthenticatedEntity page(Integer page) {
        this.page = page;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public MapRequestNonAuthenticatedEntity size(Integer size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @Max(value=50L)
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=50L) Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity = (MapRequestNonAuthenticatedEntity)o;
        return Objects.equals(this.userSession, mapRequestNonAuthenticatedEntity.userSession) && Objects.equals(this.hotelIdentifiers, mapRequestNonAuthenticatedEntity.hotelIdentifiers) && Objects.equals(this.page, mapRequestNonAuthenticatedEntity.page) && Objects.equals(this.size, mapRequestNonAuthenticatedEntity.size);
    }

    public int hashCode() {
        return Objects.hash(this.userSession, this.hotelIdentifiers, this.page, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MapRequestNonAuthenticatedEntity {\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    hotelIdentifiers: ").append(this.toIndentedString(this.hotelIdentifiers)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

