/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.lookup.model.AddressNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.BedroomConfigurationNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.ContactNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.GeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.SimpleDescriptionNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.SimpleMultimediaNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.SocialNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.TravelInventoryRecognitionNonAuthenticatedEntity;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "maxOccupancy", "minOccupancy", "quantity", "nonSmoking", "bedroomConfigurationList", "size", "maxAdultOccupancy", "maxChildOccupancy", "bathroomCount", "livingRoomCount", "maxRollaways", "roomCategory", "floor", "roomLocationCode", "roomViewCode", "composite", "compositeCount", "roomClassificationCode", "roomArchitectureCode", "roomGender", "sharedRoomInd", "maxCribs", "amenities", "includedAdultOccupancy", "includedChildOccupancy"})
@JsonTypeName(value="GuestRoom_Non_Authenticated_Entity")
public class GuestRoomNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointNonAuthenticatedEntity location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaNonAuthenticatedEntity> multimedias = new ArrayList<SimpleMultimediaNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactNonAuthenticatedEntity contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressNonAuthenticatedEntity address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    private List<String> disabilityFeatures;
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    private List<String> securityFeatures;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<SocialNonAuthenticatedEntity> socials;
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    private List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList;
    public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
    private Integer maxOccupancy = 2;
    public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
    private Integer minOccupancy = 1;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity;
    public static final String JSON_PROPERTY_NON_SMOKING = "nonSmoking";
    private Boolean nonSmoking;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST = "bedroomConfigurationList";
    private List<BedroomConfigurationNonAuthenticatedEntity> bedroomConfigurationList = new ArrayList<BedroomConfigurationNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_SIZE = "size";
    private Float size;
    public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
    private Integer maxAdultOccupancy = 2;
    public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
    private Integer maxChildOccupancy = 0;
    public static final String JSON_PROPERTY_BATHROOM_COUNT = "bathroomCount";
    private Integer bathroomCount = 1;
    public static final String JSON_PROPERTY_LIVING_ROOM_COUNT = "livingRoomCount";
    private Integer livingRoomCount = 1;
    public static final String JSON_PROPERTY_MAX_ROLLAWAYS = "maxRollaways";
    private Integer maxRollaways = 0;
    public static final String JSON_PROPERTY_ROOM_CATEGORY = "roomCategory";
    private String roomCategory;
    public static final String JSON_PROPERTY_FLOOR = "floor";
    private String floor;
    public static final String JSON_PROPERTY_ROOM_LOCATION_CODE = "roomLocationCode";
    private String roomLocationCode;
    public static final String JSON_PROPERTY_ROOM_VIEW_CODE = "roomViewCode";
    private String roomViewCode;
    public static final String JSON_PROPERTY_COMPOSITE = "composite";
    private Boolean composite = false;
    public static final String JSON_PROPERTY_COMPOSITE_COUNT = "compositeCount";
    private Integer compositeCount = 0;
    public static final String JSON_PROPERTY_ROOM_CLASSIFICATION_CODE = "roomClassificationCode";
    private String roomClassificationCode;
    public static final String JSON_PROPERTY_ROOM_ARCHITECTURE_CODE = "roomArchitectureCode";
    private String roomArchitectureCode;
    public static final String JSON_PROPERTY_ROOM_GENDER = "roomGender";
    private RoomGenderEnum roomGender = RoomGenderEnum.UNKNOWN;
    public static final String JSON_PROPERTY_SHARED_ROOM_IND = "sharedRoomInd";
    private Boolean sharedRoomInd = false;
    public static final String JSON_PROPERTY_MAX_CRIBS = "maxCribs";
    private Integer maxCribs = 0;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    private List<String> amenities;
    public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
    private Integer includedAdultOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
    private Integer includedChildOccupancy = 0;

    public GuestRoomNonAuthenticatedEntity identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public GuestRoomNonAuthenticatedEntity hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public GuestRoomNonAuthenticatedEntity featuredInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public GuestRoomNonAuthenticatedEntity lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public GuestRoomNonAuthenticatedEntity location(GeoJsonPointNonAuthenticatedEntity location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointNonAuthenticatedEntity getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(GeoJsonPointNonAuthenticatedEntity location) {
        this.location = location;
    }

    public GuestRoomNonAuthenticatedEntity descriptions(List<SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public GuestRoomNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
    }

    public GuestRoomNonAuthenticatedEntity multimedias(List<SimpleMultimediaNonAuthenticatedEntity> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public GuestRoomNonAuthenticatedEntity addMultimediasItem(SimpleMultimediaNonAuthenticatedEntity multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaNonAuthenticatedEntity>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleMultimediaNonAuthenticatedEntity> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<SimpleMultimediaNonAuthenticatedEntity> multimedias) {
        this.multimedias = multimedias;
    }

    public GuestRoomNonAuthenticatedEntity contact(ContactNonAuthenticatedEntity contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactNonAuthenticatedEntity getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(ContactNonAuthenticatedEntity contact) {
        this.contact = contact;
    }

    public GuestRoomNonAuthenticatedEntity address(AddressNonAuthenticatedEntity address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressNonAuthenticatedEntity getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressNonAuthenticatedEntity address) {
        this.address = address;
    }

    public GuestRoomNonAuthenticatedEntity commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public GuestRoomNonAuthenticatedEntity name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public GuestRoomNonAuthenticatedEntity proximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public GuestRoomNonAuthenticatedEntity sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public GuestRoomNonAuthenticatedEntity minAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public GuestRoomNonAuthenticatedEntity bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public GuestRoomNonAuthenticatedEntity active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public GuestRoomNonAuthenticatedEntity disabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public GuestRoomNonAuthenticatedEntity addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public GuestRoomNonAuthenticatedEntity securityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public GuestRoomNonAuthenticatedEntity addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public GuestRoomNonAuthenticatedEntity socials(List<SocialNonAuthenticatedEntity> socials) {
        this.socials = socials;
        return this;
    }

    public GuestRoomNonAuthenticatedEntity addSocialsItem(SocialNonAuthenticatedEntity socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialNonAuthenticatedEntity>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SocialNonAuthenticatedEntity> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<SocialNonAuthenticatedEntity> socials) {
        this.socials = socials;
    }

    public GuestRoomNonAuthenticatedEntity pricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public GuestRoomNonAuthenticatedEntity recognitionList(List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public GuestRoomNonAuthenticatedEntity addRecognitionListItem(TravelInventoryRecognitionNonAuthenticatedEntity recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionNonAuthenticatedEntity>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TravelInventoryRecognitionNonAuthenticatedEntity> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public GuestRoomNonAuthenticatedEntity maxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxOccupancy() {
        return this.maxOccupancy;
    }

    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
    }

    public GuestRoomNonAuthenticatedEntity minOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMinOccupancy() {
        return this.minOccupancy;
    }

    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
    }

    public GuestRoomNonAuthenticatedEntity quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public GuestRoomNonAuthenticatedEntity nonSmoking(Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getNonSmoking() {
        return this.nonSmoking;
    }

    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNonSmoking(Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
    }

    public GuestRoomNonAuthenticatedEntity bedroomConfigurationList(List<BedroomConfigurationNonAuthenticatedEntity> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
        return this;
    }

    public GuestRoomNonAuthenticatedEntity addBedroomConfigurationListItem(BedroomConfigurationNonAuthenticatedEntity bedroomConfigurationListItem) {
        if (this.bedroomConfigurationList == null) {
            this.bedroomConfigurationList = new ArrayList<BedroomConfigurationNonAuthenticatedEntity>();
        }
        this.bedroomConfigurationList.add(bedroomConfigurationListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BedroomConfigurationNonAuthenticatedEntity> getBedroomConfigurationList() {
        return this.bedroomConfigurationList;
    }

    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedroomConfigurationList(List<BedroomConfigurationNonAuthenticatedEntity> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
    }

    public GuestRoomNonAuthenticatedEntity size(Float size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1") Float getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Float size) {
        this.size = size;
    }

    public GuestRoomNonAuthenticatedEntity maxAdultOccupancy(Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxAdultOccupancy() {
        return this.maxAdultOccupancy;
    }

    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxAdultOccupancy(Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
    }

    public GuestRoomNonAuthenticatedEntity maxChildOccupancy(Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxChildOccupancy() {
        return this.maxChildOccupancy;
    }

    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxChildOccupancy(Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
    }

    public GuestRoomNonAuthenticatedEntity bathroomCount(Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getBathroomCount() {
        return this.bathroomCount;
    }

    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBathroomCount(Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
    }

    public GuestRoomNonAuthenticatedEntity livingRoomCount(Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getLivingRoomCount() {
        return this.livingRoomCount;
    }

    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLivingRoomCount(Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
    }

    public GuestRoomNonAuthenticatedEntity maxRollaways(Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxRollaways() {
        return this.maxRollaways;
    }

    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxRollaways(Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
    }

    public GuestRoomNonAuthenticatedEntity roomCategory(String roomCategory) {
        this.roomCategory = roomCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomCategory() {
        return this.roomCategory;
    }

    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomCategory(String roomCategory) {
        this.roomCategory = roomCategory;
    }

    public GuestRoomNonAuthenticatedEntity floor(String floor) {
        this.floor = floor;
        return this;
    }

    @Nullable
    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFloor() {
        return this.floor;
    }

    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFloor(String floor) {
        this.floor = floor;
    }

    public GuestRoomNonAuthenticatedEntity roomLocationCode(String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomLocationCode() {
        return this.roomLocationCode;
    }

    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomLocationCode(String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
    }

    public GuestRoomNonAuthenticatedEntity roomViewCode(String roomViewCode) {
        this.roomViewCode = roomViewCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomViewCode() {
        return this.roomViewCode;
    }

    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomViewCode(String roomViewCode) {
        this.roomViewCode = roomViewCode;
    }

    public GuestRoomNonAuthenticatedEntity composite(Boolean composite) {
        this.composite = composite;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getComposite() {
        return this.composite;
    }

    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setComposite(Boolean composite) {
        this.composite = composite;
    }

    public GuestRoomNonAuthenticatedEntity compositeCount(Integer compositeCount) {
        this.compositeCount = compositeCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getCompositeCount() {
        return this.compositeCount;
    }

    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompositeCount(Integer compositeCount) {
        this.compositeCount = compositeCount;
    }

    public GuestRoomNonAuthenticatedEntity roomClassificationCode(String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomClassificationCode() {
        return this.roomClassificationCode;
    }

    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomClassificationCode(String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
    }

    public GuestRoomNonAuthenticatedEntity roomArchitectureCode(String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomArchitectureCode() {
        return this.roomArchitectureCode;
    }

    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomArchitectureCode(String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
    }

    public GuestRoomNonAuthenticatedEntity roomGender(RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
        return this;
    }

    @Nullable
    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomGenderEnum getRoomGender() {
        return this.roomGender;
    }

    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomGender(RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
    }

    public GuestRoomNonAuthenticatedEntity sharedRoomInd(Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSharedRoomInd() {
        return this.sharedRoomInd;
    }

    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSharedRoomInd(Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
    }

    public GuestRoomNonAuthenticatedEntity maxCribs(Integer maxCribs) {
        this.maxCribs = maxCribs;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxCribs() {
        return this.maxCribs;
    }

    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxCribs(Integer maxCribs) {
        this.maxCribs = maxCribs;
    }

    public GuestRoomNonAuthenticatedEntity amenities(List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public GuestRoomNonAuthenticatedEntity addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(List<String> amenities) {
        this.amenities = amenities;
    }

    public GuestRoomNonAuthenticatedEntity includedAdultOccupancy(Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedAdultOccupancy() {
        return this.includedAdultOccupancy;
    }

    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedAdultOccupancy(Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
    }

    public GuestRoomNonAuthenticatedEntity includedChildOccupancy(Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedChildOccupancy() {
        return this.includedChildOccupancy;
    }

    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedChildOccupancy(Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuestRoomNonAuthenticatedEntity guestRoomNonAuthenticatedEntity = (GuestRoomNonAuthenticatedEntity)o;
        return Objects.equals(this.identifier, guestRoomNonAuthenticatedEntity.identifier) && Objects.equals(this.hotelIdentifier, guestRoomNonAuthenticatedEntity.hotelIdentifier) && Objects.equals(this.featuredInd, guestRoomNonAuthenticatedEntity.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)guestRoomNonAuthenticatedEntity.lifestyleType) && Objects.equals(this.location, guestRoomNonAuthenticatedEntity.location) && Objects.equals(this.descriptions, guestRoomNonAuthenticatedEntity.descriptions) && Objects.equals(this.multimedias, guestRoomNonAuthenticatedEntity.multimedias) && Objects.equals(this.contact, guestRoomNonAuthenticatedEntity.contact) && Objects.equals(this.address, guestRoomNonAuthenticatedEntity.address) && Objects.equals(this.commissionable, guestRoomNonAuthenticatedEntity.commissionable) && Objects.equals(this.name, guestRoomNonAuthenticatedEntity.name) && Objects.equals(this.proximityCode, guestRoomNonAuthenticatedEntity.proximityCode) && Objects.equals(this.sort, guestRoomNonAuthenticatedEntity.sort) && Objects.equals(this.minAgeAppropriateCode, guestRoomNonAuthenticatedEntity.minAgeAppropriateCode) && Objects.equals(this.bookable, guestRoomNonAuthenticatedEntity.bookable) && Objects.equals(this.active, guestRoomNonAuthenticatedEntity.active) && Objects.equals(this.disabilityFeatures, guestRoomNonAuthenticatedEntity.disabilityFeatures) && Objects.equals(this.securityFeatures, guestRoomNonAuthenticatedEntity.securityFeatures) && Objects.equals(this.socials, guestRoomNonAuthenticatedEntity.socials) && Objects.equals((Object)this.pricePoint, (Object)guestRoomNonAuthenticatedEntity.pricePoint) && Objects.equals(this.recognitionList, guestRoomNonAuthenticatedEntity.recognitionList) && Objects.equals(this.maxOccupancy, guestRoomNonAuthenticatedEntity.maxOccupancy) && Objects.equals(this.minOccupancy, guestRoomNonAuthenticatedEntity.minOccupancy) && Objects.equals(this.quantity, guestRoomNonAuthenticatedEntity.quantity) && Objects.equals(this.nonSmoking, guestRoomNonAuthenticatedEntity.nonSmoking) && Objects.equals(this.bedroomConfigurationList, guestRoomNonAuthenticatedEntity.bedroomConfigurationList) && Objects.equals(this.size, guestRoomNonAuthenticatedEntity.size) && Objects.equals(this.maxAdultOccupancy, guestRoomNonAuthenticatedEntity.maxAdultOccupancy) && Objects.equals(this.maxChildOccupancy, guestRoomNonAuthenticatedEntity.maxChildOccupancy) && Objects.equals(this.bathroomCount, guestRoomNonAuthenticatedEntity.bathroomCount) && Objects.equals(this.livingRoomCount, guestRoomNonAuthenticatedEntity.livingRoomCount) && Objects.equals(this.maxRollaways, guestRoomNonAuthenticatedEntity.maxRollaways) && Objects.equals(this.roomCategory, guestRoomNonAuthenticatedEntity.roomCategory) && Objects.equals(this.floor, guestRoomNonAuthenticatedEntity.floor) && Objects.equals(this.roomLocationCode, guestRoomNonAuthenticatedEntity.roomLocationCode) && Objects.equals(this.roomViewCode, guestRoomNonAuthenticatedEntity.roomViewCode) && Objects.equals(this.composite, guestRoomNonAuthenticatedEntity.composite) && Objects.equals(this.compositeCount, guestRoomNonAuthenticatedEntity.compositeCount) && Objects.equals(this.roomClassificationCode, guestRoomNonAuthenticatedEntity.roomClassificationCode) && Objects.equals(this.roomArchitectureCode, guestRoomNonAuthenticatedEntity.roomArchitectureCode) && Objects.equals((Object)this.roomGender, (Object)guestRoomNonAuthenticatedEntity.roomGender) && Objects.equals(this.sharedRoomInd, guestRoomNonAuthenticatedEntity.sharedRoomInd) && Objects.equals(this.maxCribs, guestRoomNonAuthenticatedEntity.maxCribs) && Objects.equals(this.amenities, guestRoomNonAuthenticatedEntity.amenities) && Objects.equals(this.includedAdultOccupancy, guestRoomNonAuthenticatedEntity.includedAdultOccupancy) && Objects.equals(this.includedChildOccupancy, guestRoomNonAuthenticatedEntity.includedChildOccupancy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.maxOccupancy, this.minOccupancy, this.quantity, this.nonSmoking, this.bedroomConfigurationList, this.size, this.maxAdultOccupancy, this.maxChildOccupancy, this.bathroomCount, this.livingRoomCount, this.maxRollaways, this.roomCategory, this.floor, this.roomLocationCode, this.roomViewCode, this.composite, this.compositeCount, this.roomClassificationCode, this.roomArchitectureCode, this.roomGender, this.sharedRoomInd, this.maxCribs, this.amenities, this.includedAdultOccupancy, this.includedChildOccupancy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuestRoomNonAuthenticatedEntity {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    maxOccupancy: ").append(this.toIndentedString(this.maxOccupancy)).append("\n");
        sb.append("    minOccupancy: ").append(this.toIndentedString(this.minOccupancy)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    nonSmoking: ").append(this.toIndentedString(this.nonSmoking)).append("\n");
        sb.append("    bedroomConfigurationList: ").append(this.toIndentedString(this.bedroomConfigurationList)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    maxAdultOccupancy: ").append(this.toIndentedString(this.maxAdultOccupancy)).append("\n");
        sb.append("    maxChildOccupancy: ").append(this.toIndentedString(this.maxChildOccupancy)).append("\n");
        sb.append("    bathroomCount: ").append(this.toIndentedString(this.bathroomCount)).append("\n");
        sb.append("    livingRoomCount: ").append(this.toIndentedString(this.livingRoomCount)).append("\n");
        sb.append("    maxRollaways: ").append(this.toIndentedString(this.maxRollaways)).append("\n");
        sb.append("    roomCategory: ").append(this.toIndentedString(this.roomCategory)).append("\n");
        sb.append("    floor: ").append(this.toIndentedString(this.floor)).append("\n");
        sb.append("    roomLocationCode: ").append(this.toIndentedString(this.roomLocationCode)).append("\n");
        sb.append("    roomViewCode: ").append(this.toIndentedString(this.roomViewCode)).append("\n");
        sb.append("    composite: ").append(this.toIndentedString(this.composite)).append("\n");
        sb.append("    compositeCount: ").append(this.toIndentedString(this.compositeCount)).append("\n");
        sb.append("    roomClassificationCode: ").append(this.toIndentedString(this.roomClassificationCode)).append("\n");
        sb.append("    roomArchitectureCode: ").append(this.toIndentedString(this.roomArchitectureCode)).append("\n");
        sb.append("    roomGender: ").append(this.toIndentedString((Object)this.roomGender)).append("\n");
        sb.append("    sharedRoomInd: ").append(this.toIndentedString(this.sharedRoomInd)).append("\n");
        sb.append("    maxCribs: ").append(this.toIndentedString(this.maxCribs)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    includedAdultOccupancy: ").append(this.toIndentedString(this.includedAdultOccupancy)).append("\n");
        sb.append("    includedChildOccupancy: ").append(this.toIndentedString(this.includedChildOccupancy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF("HALF"),
        ONE("ONE"),
        ONE_HALF("ONE_HALF"),
        TWO("TWO"),
        TWO_HALF("TWO_HALF"),
        THREE("THREE"),
        THREE_HALF("THREE_HALF"),
        FOUR("FOUR"),
        FOUR_HALF("FOUR_HALF"),
        FIVE("FIVE");

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RoomGenderEnum {
        MALE("Male"),
        FEMALE("Female"),
        MALEANDFEMALE("MaleAndFemale"),
        UNKNOWN("Unknown");

        private String value;

        private RoomGenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoomGenderEnum fromValue(String value) {
            for (RoomGenderEnum b : RoomGenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

