package travel.wink.sdk.lookup.api;

import travel.wink.sdk.lookup.invoker.ApiClient;

import travel.wink.sdk.lookup.model.CityScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CitySearchRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CountryScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.GenericErrorMessage;
import travel.wink.sdk.lookup.model.GlobalScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LookupCachedNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LookupNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.MapRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.Oauth2SearchByGeoLocation400Response;
import travel.wink.sdk.lookup.model.PageHotelWithBestPriceNonAuthenticatedEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-12-21T14:58:38.369544814+07:00[Asia/Bangkok]")
public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequestNonAuthenticatedEntity The cityScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ScoreInventoryByCityRequestCreation(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = cityScoreRequestNonAuthenticatedEntity;
        // verify the required parameter 'cityScoreRequestNonAuthenticatedEntity' is set
        if (cityScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequestNonAuthenticatedEntity' when calling oauth2ScoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequestNonAuthenticatedEntity The cityScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2ScoreInventoryByCity(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequestNonAuthenticatedEntity The cityScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2ScoreInventoryByCityWithHttpInfo(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param cityScoreRequestNonAuthenticatedEntity The cityScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ScoreInventoryByCityWithResponseSpec(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequestNonAuthenticatedEntity The mapRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchByGeoLocationRequestCreation(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = mapRequestNonAuthenticatedEntity;
        // verify the required parameter 'mapRequestNonAuthenticatedEntity' is set
        if (mapRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequestNonAuthenticatedEntity' when calling oauth2SearchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequestNonAuthenticatedEntity The mapRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2SearchByGeoLocation(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2SearchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequestNonAuthenticatedEntity The mapRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2SearchByGeoLocationWithHttpInfo(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2SearchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param mapRequestNonAuthenticatedEntity The mapRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchByGeoLocationWithResponseSpec(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2SearchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequestNonAuthenticatedEntity The citySearchRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchInventoryByCityRequestCreation(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = citySearchRequestNonAuthenticatedEntity;
        // verify the required parameter 'citySearchRequestNonAuthenticatedEntity' is set
        if (citySearchRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequestNonAuthenticatedEntity' when calling oauth2SearchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequestNonAuthenticatedEntity The citySearchRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2SearchInventoryByCity(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequestNonAuthenticatedEntity The citySearchRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2SearchInventoryByCityWithHttpInfo(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param citySearchRequestNonAuthenticatedEntity The citySearchRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchInventoryByCityWithResponseSpec(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequestNonAuthenticatedEntity The countryScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchScoreByCountryRequestCreation(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = countryScoreRequestNonAuthenticatedEntity;
        // verify the required parameter 'countryScoreRequestNonAuthenticatedEntity' is set
        if (countryScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequestNonAuthenticatedEntity' when calling oauth2SearchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequestNonAuthenticatedEntity The countryScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2SearchScoreByCountry(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequestNonAuthenticatedEntity The countryScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2SearchScoreByCountryWithHttpInfo(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param countryScoreRequestNonAuthenticatedEntity The countryScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchScoreByCountryWithResponseSpec(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequestNonAuthenticatedEntity The globalScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchScoreByGlobalRequestCreation(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = globalScoreRequestNonAuthenticatedEntity;
        // verify the required parameter 'globalScoreRequestNonAuthenticatedEntity' is set
        if (globalScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequestNonAuthenticatedEntity' when calling oauth2SearchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequestNonAuthenticatedEntity The globalScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return PageHotelWithBestPriceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2SearchScoreByGlobal(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequestNonAuthenticatedEntity The globalScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelWithBestPriceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2SearchScoreByGlobalWithHttpInfo(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>() {};
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param globalScoreRequestNonAuthenticatedEntity The globalScoreRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchScoreByGlobalWithResponseSpec(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @return List&lt;LookupCachedNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchSuggestionsRequestCreation(String term, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'term' is set
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling oauth2SearchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "term", term));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @return List&lt;LookupCachedNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LookupCachedNonAuthenticatedEntity> oauth2SearchSuggestions(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>() {};
        return oauth2SearchSuggestionsRequestCreation(term, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;LookupCachedNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<LookupCachedNonAuthenticatedEntity>>> oauth2SearchSuggestionsWithHttpInfo(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>() {};
        return oauth2SearchSuggestionsRequestCreation(term, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2SearchSuggestionsWithResponseSpec(String term, String winkVersion) throws WebClientResponseException {
        return oauth2SearchSuggestionsRequestCreation(term, winkVersion);
    }
    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @return LookupNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowLookupRequestCreation(String urlName, String type, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'urlName' is set
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("urlName", urlName);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @return LookupNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<LookupNonAuthenticatedEntity> oauth2ShowLookup(String urlName, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>() {};
        return oauth2ShowLookupRequestCreation(urlName, type, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;LookupNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<LookupNonAuthenticatedEntity>> oauth2ShowLookupWithHttpInfo(String urlName, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>() {};
        return oauth2ShowLookupRequestCreation(urlName, type, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowLookupWithResponseSpec(String urlName, String type, String winkVersion) throws WebClientResponseException {
        return oauth2ShowLookupRequestCreation(urlName, type, winkVersion);
    }
}
