/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.lookup.model.RoomConfigurationNonAuthenticatedEntity;

@JsonPropertyOrder(value={"startDate", "endDate", "items", "hours", "valid", "children", "nights", "rooms", "guests"})
@JsonTypeName(value="Itinerary_Non_Authenticated_Entity")
public class ItineraryNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<RoomConfigurationNonAuthenticatedEntity> items = new ArrayList<RoomConfigurationNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_HOURS = "hours";
    private Long hours;
    public static final String JSON_PROPERTY_VALID = "valid";
    private Boolean valid;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private Integer children;
    public static final String JSON_PROPERTY_NIGHTS = "nights";
    private Integer nights;
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    private Integer rooms;
    public static final String JSON_PROPERTY_GUESTS = "guests";
    private Integer guests;

    public ItineraryNonAuthenticatedEntity() {
    }

    @JsonCreator
    public ItineraryNonAuthenticatedEntity(@JsonProperty(value="hours") Long hours) {
        this();
        this.hours = hours;
    }

    public ItineraryNonAuthenticatedEntity startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public ItineraryNonAuthenticatedEntity endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public ItineraryNonAuthenticatedEntity items(List<RoomConfigurationNonAuthenticatedEntity> items) {
        this.items = items;
        return this;
    }

    public ItineraryNonAuthenticatedEntity addItemsItem(RoomConfigurationNonAuthenticatedEntity itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<RoomConfigurationNonAuthenticatedEntity>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RoomConfigurationNonAuthenticatedEntity> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItems(List<RoomConfigurationNonAuthenticatedEntity> items) {
        this.items = items;
    }

    @Nullable
    @JsonProperty(value="hours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHours() {
        return this.hours;
    }

    public ItineraryNonAuthenticatedEntity valid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    @Nullable
    @JsonProperty(value="valid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValid() {
        return this.valid;
    }

    @JsonProperty(value="valid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public ItineraryNonAuthenticatedEntity children(Integer children) {
        this.children = children;
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(Integer children) {
        this.children = children;
    }

    public ItineraryNonAuthenticatedEntity nights(Integer nights) {
        this.nights = nights;
        return this;
    }

    @Nullable
    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNights() {
        return this.nights;
    }

    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNights(Integer nights) {
        this.nights = nights;
    }

    public ItineraryNonAuthenticatedEntity rooms(Integer rooms) {
        this.rooms = rooms;
        return this;
    }

    @Nullable
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRooms(Integer rooms) {
        this.rooms = rooms;
    }

    public ItineraryNonAuthenticatedEntity guests(Integer guests) {
        this.guests = guests;
        return this;
    }

    @Nullable
    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGuests() {
        return this.guests;
    }

    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuests(Integer guests) {
        this.guests = guests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItineraryNonAuthenticatedEntity itineraryNonAuthenticatedEntity = (ItineraryNonAuthenticatedEntity)o;
        return Objects.equals(this.startDate, itineraryNonAuthenticatedEntity.startDate) && Objects.equals(this.endDate, itineraryNonAuthenticatedEntity.endDate) && Objects.equals(this.items, itineraryNonAuthenticatedEntity.items) && Objects.equals(this.hours, itineraryNonAuthenticatedEntity.hours) && Objects.equals(this.valid, itineraryNonAuthenticatedEntity.valid) && Objects.equals(this.children, itineraryNonAuthenticatedEntity.children) && Objects.equals(this.nights, itineraryNonAuthenticatedEntity.nights) && Objects.equals(this.rooms, itineraryNonAuthenticatedEntity.rooms) && Objects.equals(this.guests, itineraryNonAuthenticatedEntity.guests);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.items, this.hours, this.valid, this.children, this.nights, this.rooms, this.guests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItineraryNonAuthenticatedEntity {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("    valid: ").append(this.toIndentedString(this.valid)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    nights: ").append(this.toIndentedString(this.nights)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    guests: ").append(this.toIndentedString(this.guests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

