/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.lookup.invoker.ApiClient;
import travel.wink.sdk.lookup.model.CityScoreRequestConsumer;
import travel.wink.sdk.lookup.model.CitySearchRequestConsumer;
import travel.wink.sdk.lookup.model.CountryScoreRequestConsumer;
import travel.wink.sdk.lookup.model.GlobalScoreRequestConsumer;
import travel.wink.sdk.lookup.model.LookupCachedConsumer;
import travel.wink.sdk.lookup.model.LookupConsumer;
import travel.wink.sdk.lookup.model.MapRequestConsumer;
import travel.wink.sdk.lookup.model.PageHotelWithBestPriceConsumer;

public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec oauth2ScoreInventoryByCityRequestCreation(CityScoreRequestConsumer cityScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        CityScoreRequestConsumer postBody = cityScoreRequestConsumer;
        if (cityScoreRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequestConsumer' when calling oauth2ScoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceConsumer> oauth2ScoreInventoryByCity(CityScoreRequestConsumer cityScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2ScoreInventoryByCityWithHttpInfo(CityScoreRequestConsumer cityScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2ScoreInventoryByCityWithResponseSpec(CityScoreRequestConsumer cityScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return this.oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec oauth2SearchByGeoLocationRequestCreation(MapRequestConsumer mapRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        MapRequestConsumer postBody = mapRequestConsumer;
        if (mapRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequestConsumer' when calling oauth2SearchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceConsumer> oauth2SearchByGeoLocation(MapRequestConsumer mapRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2SearchByGeoLocationRequestCreation(mapRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2SearchByGeoLocationWithHttpInfo(MapRequestConsumer mapRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2SearchByGeoLocationRequestCreation(mapRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchByGeoLocationWithResponseSpec(MapRequestConsumer mapRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return this.oauth2SearchByGeoLocationRequestCreation(mapRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec oauth2SearchInventoryByCityRequestCreation(CitySearchRequestConsumer citySearchRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        CitySearchRequestConsumer postBody = citySearchRequestConsumer;
        if (citySearchRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequestConsumer' when calling oauth2SearchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceConsumer> oauth2SearchInventoryByCity(CitySearchRequestConsumer citySearchRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2SearchInventoryByCityRequestCreation(citySearchRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2SearchInventoryByCityWithHttpInfo(CitySearchRequestConsumer citySearchRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2SearchInventoryByCityRequestCreation(citySearchRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchInventoryByCityWithResponseSpec(CitySearchRequestConsumer citySearchRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return this.oauth2SearchInventoryByCityRequestCreation(citySearchRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec oauth2SearchScoreByCountryRequestCreation(CountryScoreRequestConsumer countryScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        CountryScoreRequestConsumer postBody = countryScoreRequestConsumer;
        if (countryScoreRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequestConsumer' when calling oauth2SearchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceConsumer> oauth2SearchScoreByCountry(CountryScoreRequestConsumer countryScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2SearchScoreByCountryRequestCreation(countryScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2SearchScoreByCountryWithHttpInfo(CountryScoreRequestConsumer countryScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2SearchScoreByCountryRequestCreation(countryScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchScoreByCountryWithResponseSpec(CountryScoreRequestConsumer countryScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return this.oauth2SearchScoreByCountryRequestCreation(countryScoreRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec oauth2SearchScoreByGlobalRequestCreation(GlobalScoreRequestConsumer globalScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        GlobalScoreRequestConsumer postBody = globalScoreRequestConsumer;
        if (globalScoreRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequestConsumer' when calling oauth2SearchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceConsumer> oauth2SearchScoreByGlobal(GlobalScoreRequestConsumer globalScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceConsumer>> oauth2SearchScoreByGlobalWithHttpInfo(GlobalScoreRequestConsumer globalScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceConsumer> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceConsumer>(){};
        return this.oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchScoreByGlobalWithResponseSpec(GlobalScoreRequestConsumer globalScoreRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return this.oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec oauth2SearchSuggestionsRequestCreation(String term, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling oauth2SearchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "term", term));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LookupCachedConsumer> localVarReturnType = new ParameterizedTypeReference<LookupCachedConsumer>(){};
        return this.apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<LookupCachedConsumer> oauth2SearchSuggestions(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedConsumer> localVarReturnType = new ParameterizedTypeReference<LookupCachedConsumer>(){};
        return this.oauth2SearchSuggestionsRequestCreation(term, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<LookupCachedConsumer>>> oauth2SearchSuggestionsWithHttpInfo(String term, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedConsumer> localVarReturnType = new ParameterizedTypeReference<LookupCachedConsumer>(){};
        return this.oauth2SearchSuggestionsRequestCreation(term, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchSuggestionsWithResponseSpec(String term, String winkVersion) throws WebClientResponseException {
        return this.oauth2SearchSuggestionsRequestCreation(term, winkVersion);
    }

    private WebClient.ResponseSpec oauth2ShowLookupRequestCreation(String urlName, String type, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("urlName", urlName);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LookupConsumer> localVarReturnType = new ParameterizedTypeReference<LookupConsumer>(){};
        return this.apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<LookupConsumer> oauth2ShowLookup(String urlName, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupConsumer> localVarReturnType = new ParameterizedTypeReference<LookupConsumer>(){};
        return this.oauth2ShowLookupRequestCreation(urlName, type, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<LookupConsumer>> oauth2ShowLookupWithHttpInfo(String urlName, String type, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LookupConsumer> localVarReturnType = new ParameterizedTypeReference<LookupConsumer>(){};
        return this.oauth2ShowLookupRequestCreation(urlName, type, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2ShowLookupWithResponseSpec(String urlName, String type, String winkVersion) throws WebClientResponseException {
        return this.oauth2ShowLookupRequestCreation(urlName, type, winkVersion);
    }
}

