/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Lookup API Welcome to the Lookup API - A programmer-friendly way to search for bespoke travel inventory across geographic regions. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.lookup.model.SearchFiltersNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.UserSessionNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CountryScoreRequestNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  CountryScoreRequestNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY_CODE,
  CountryScoreRequestNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  CountryScoreRequestNonAuthenticatedEntity.JSON_PROPERTY_USER_SESSION,
  CountryScoreRequestNonAuthenticatedEntity.JSON_PROPERTY_SEARCH_FILTERS,
  CountryScoreRequestNonAuthenticatedEntity.JSON_PROPERTY_PAGE,
  CountryScoreRequestNonAuthenticatedEntity.JSON_PROPERTY_SIZE
})
@JsonTypeName("CountryScoreRequest_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:17:29.005877348+07:00[Asia/Bangkok]")
public class CountryScoreRequestNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  /**
   * Choose the criteria you want the results sorted on.
   */
  public enum SortEnum {
    MEMBER("MEMBER"),
    
    PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
    
    PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
    
    PRICE("PRICE"),
    
    POPULARITY("POPULARITY"),
    
    ECO("ECO"),
    
    EXPERIENCE("EXPERIENCE"),
    
    PERK("PERK"),
    
    LOYALTY("LOYALTY"),
    
    PACKAGE("PACKAGE");

    private String value;

    SortEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortEnum fromValue(String value) {
      for (SortEnum b : SortEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SORT = "sort";
  private SortEnum sort;

  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  private UserSessionNonAuthenticatedEntity userSession;

  public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
  private SearchFiltersNonAuthenticatedEntity searchFilters;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 0;

  public static final String JSON_PROPERTY_SIZE = "size";
  private Integer size = 6;

  public CountryScoreRequestNonAuthenticatedEntity() {
  }

  public CountryScoreRequestNonAuthenticatedEntity countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Unique country code you want to search in as it was given to you in the lookup entry or by using standard country codes as defined here [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
   * @return countryCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public CountryScoreRequestNonAuthenticatedEntity sort(SortEnum sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Choose the criteria you want the results sorted on.
   * @return sort
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SortEnum getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSort(SortEnum sort) {
    this.sort = sort;
  }


  public CountryScoreRequestNonAuthenticatedEntity userSession(UserSessionNonAuthenticatedEntity userSession) {
    
    this.userSession = userSession;
    return this;
  }

   /**
   * Get userSession
   * @return userSession
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UserSessionNonAuthenticatedEntity getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSession(UserSessionNonAuthenticatedEntity userSession) {
    this.userSession = userSession;
  }


  public CountryScoreRequestNonAuthenticatedEntity searchFilters(SearchFiltersNonAuthenticatedEntity searchFilters) {
    
    this.searchFilters = searchFilters;
    return this;
  }

   /**
   * Get searchFilters
   * @return searchFilters
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SEARCH_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SearchFiltersNonAuthenticatedEntity getSearchFilters() {
    return searchFilters;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchFilters(SearchFiltersNonAuthenticatedEntity searchFilters) {
    this.searchFilters = searchFilters;
  }


  public CountryScoreRequestNonAuthenticatedEntity page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * The page to paginate to. Note: Page uses a 0-based index.
   * minimum: 0
   * @return page
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public CountryScoreRequestNonAuthenticatedEntity size(Integer size) {
    
    this.size = size;
    return this;
  }

   /**
   * The result size to return.
   * minimum: 1
   * maximum: 50
   * @return size
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1) @Max(50)
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSize(Integer size) {
    this.size = size;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity = (CountryScoreRequestNonAuthenticatedEntity) o;
    return Objects.equals(this.countryCode, countryScoreRequestNonAuthenticatedEntity.countryCode) &&
        Objects.equals(this.sort, countryScoreRequestNonAuthenticatedEntity.sort) &&
        Objects.equals(this.userSession, countryScoreRequestNonAuthenticatedEntity.userSession) &&
        Objects.equals(this.searchFilters, countryScoreRequestNonAuthenticatedEntity.searchFilters) &&
        Objects.equals(this.page, countryScoreRequestNonAuthenticatedEntity.page) &&
        Objects.equals(this.size, countryScoreRequestNonAuthenticatedEntity.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(countryCode, sort, userSession, searchFilters, page, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CountryScoreRequestNonAuthenticatedEntity {\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("    searchFilters: ").append(toIndentedString(searchFilters)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

