/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Lookup API Welcome to the Lookup API - A programmer-friendly way to search for bespoke travel inventory across geographic regions. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.lookup.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.lookup.model.ItineraryNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * User session information containing itinerary and other user related data.
 */
@JsonPropertyOrder({
  UserSessionNonAuthenticatedEntity.JSON_PROPERTY_ITINERARY,
  UserSessionNonAuthenticatedEntity.JSON_PROPERTY_LANGUAGE,
  UserSessionNonAuthenticatedEntity.JSON_PROPERTY_CURRENCY,
  UserSessionNonAuthenticatedEntity.JSON_PROPERTY_PROMOTIONAL_CODES,
  UserSessionNonAuthenticatedEntity.JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX,
  UserSessionNonAuthenticatedEntity.JSON_PROPERTY_LIFESTYLE
})
@JsonTypeName("UserSession_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:17:29.005877348+07:00[Asia/Bangkok]")
public class UserSessionNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private ItineraryNonAuthenticatedEntity itinerary;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes;

  public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX = "selectedRoomConfigurationIndex";
  private Integer selectedRoomConfigurationIndex;

  /**
   * The preferred user lifestyle.
   */
  public enum LifestyleEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleEnum fromValue(String value) {
      for (LifestyleEnum b : LifestyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE = "lifestyle";
  private LifestyleEnum lifestyle;

  public UserSessionNonAuthenticatedEntity() {
  }

  public UserSessionNonAuthenticatedEntity itinerary(ItineraryNonAuthenticatedEntity itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ItineraryNonAuthenticatedEntity getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(ItineraryNonAuthenticatedEntity itinerary) {
    this.itinerary = itinerary;
  }


  public UserSessionNonAuthenticatedEntity language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * User&#39;s language preference
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public UserSessionNonAuthenticatedEntity currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * User&#39;s currency preference
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public UserSessionNonAuthenticatedEntity promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public UserSessionNonAuthenticatedEntity addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Get promotionalCodes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public UserSessionNonAuthenticatedEntity selectedRoomConfigurationIndex(Integer selectedRoomConfigurationIndex) {
    
    this.selectedRoomConfigurationIndex = selectedRoomConfigurationIndex;
    return this;
  }

   /**
   * User can pass the current room configuration index to retrieve rates specifically for that room configuration.
   * @return selectedRoomConfigurationIndex
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSelectedRoomConfigurationIndex() {
    return selectedRoomConfigurationIndex;
  }


  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectedRoomConfigurationIndex(Integer selectedRoomConfigurationIndex) {
    this.selectedRoomConfigurationIndex = selectedRoomConfigurationIndex;
  }


  public UserSessionNonAuthenticatedEntity lifestyle(LifestyleEnum lifestyle) {
    
    this.lifestyle = lifestyle;
    return this;
  }

   /**
   * The preferred user lifestyle.
   * @return lifestyle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleEnum getLifestyle() {
    return lifestyle;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyle(LifestyleEnum lifestyle) {
    this.lifestyle = lifestyle;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity = (UserSessionNonAuthenticatedEntity) o;
    return Objects.equals(this.itinerary, userSessionNonAuthenticatedEntity.itinerary) &&
        Objects.equals(this.language, userSessionNonAuthenticatedEntity.language) &&
        Objects.equals(this.currency, userSessionNonAuthenticatedEntity.currency) &&
        Objects.equals(this.promotionalCodes, userSessionNonAuthenticatedEntity.promotionalCodes) &&
        Objects.equals(this.selectedRoomConfigurationIndex, userSessionNonAuthenticatedEntity.selectedRoomConfigurationIndex) &&
        Objects.equals(this.lifestyle, userSessionNonAuthenticatedEntity.lifestyle);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itinerary, language, currency, promotionalCodes, selectedRoomConfigurationIndex, lifestyle);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserSessionNonAuthenticatedEntity {\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    selectedRoomConfigurationIndex: ").append(toIndentedString(selectedRoomConfigurationIndex)).append("\n");
    sb.append("    lifestyle: ").append(toIndentedString(lifestyle)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

