/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.lookup.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.lookup.invoker.ApiClient;
import travel.wink.sdk.lookup.model.CityScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CitySearchRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.CountryScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.GlobalScoreRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LookupCachedNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.LookupNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.MapRequestNonAuthenticatedEntity;
import travel.wink.sdk.lookup.model.PageHotelWithBestPriceNonAuthenticatedEntity;

public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec oauth2ScoreInventoryByCityRequestCreation(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        CityScoreRequestNonAuthenticatedEntity postBody = cityScoreRequestNonAuthenticatedEntity;
        if (cityScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequestNonAuthenticatedEntity' when calling oauth2ScoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2ScoreInventoryByCity(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2ScoreInventoryByCityWithHttpInfo(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2ScoreInventoryByCityWithResponseSpec(CityScoreRequestNonAuthenticatedEntity cityScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2ScoreInventoryByCityRequestCreation(cityScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2SearchByGeoLocationRequestCreation(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        MapRequestNonAuthenticatedEntity postBody = mapRequestNonAuthenticatedEntity;
        if (mapRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequestNonAuthenticatedEntity' when calling oauth2SearchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2SearchByGeoLocation(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2SearchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2SearchByGeoLocationWithHttpInfo(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2SearchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchByGeoLocationWithResponseSpec(MapRequestNonAuthenticatedEntity mapRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2SearchByGeoLocationRequestCreation(mapRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2SearchInventoryByCityRequestCreation(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        CitySearchRequestNonAuthenticatedEntity postBody = citySearchRequestNonAuthenticatedEntity;
        if (citySearchRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequestNonAuthenticatedEntity' when calling oauth2SearchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2SearchInventoryByCity(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2SearchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2SearchInventoryByCityWithHttpInfo(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2SearchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchInventoryByCityWithResponseSpec(CitySearchRequestNonAuthenticatedEntity citySearchRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2SearchInventoryByCityRequestCreation(citySearchRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2SearchScoreByCountryRequestCreation(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        CountryScoreRequestNonAuthenticatedEntity postBody = countryScoreRequestNonAuthenticatedEntity;
        if (countryScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequestNonAuthenticatedEntity' when calling oauth2SearchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2SearchScoreByCountry(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2SearchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2SearchScoreByCountryWithHttpInfo(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2SearchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchScoreByCountryWithResponseSpec(CountryScoreRequestNonAuthenticatedEntity countryScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2SearchScoreByCountryRequestCreation(countryScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2SearchScoreByGlobalRequestCreation(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        GlobalScoreRequestNonAuthenticatedEntity postBody = globalScoreRequestNonAuthenticatedEntity;
        if (globalScoreRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequestNonAuthenticatedEntity' when calling oauth2SearchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPriceNonAuthenticatedEntity> oauth2SearchScoreByGlobal(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPriceNonAuthenticatedEntity>> oauth2SearchScoreByGlobalWithHttpInfo(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPriceNonAuthenticatedEntity>(this){};
        return this.oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchScoreByGlobalWithResponseSpec(GlobalScoreRequestNonAuthenticatedEntity globalScoreRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2SearchScoreByGlobalRequestCreation(globalScoreRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2SearchSuggestionsRequestCreation(String term, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling oauth2SearchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "term", term));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<LookupCachedNonAuthenticatedEntity> oauth2SearchSuggestions(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>(this){};
        return this.oauth2SearchSuggestionsRequestCreation(term, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<LookupCachedNonAuthenticatedEntity>>> oauth2SearchSuggestionsWithHttpInfo(String term, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupCachedNonAuthenticatedEntity>(this){};
        return this.oauth2SearchSuggestionsRequestCreation(term, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2SearchSuggestionsWithResponseSpec(String term, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2SearchSuggestionsRequestCreation(term, winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2ShowLookupRequestCreation(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("urlName", urlName);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<LookupNonAuthenticatedEntity> oauth2ShowLookup(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>(this){};
        return this.oauth2ShowLookupRequestCreation(urlName, type, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<LookupNonAuthenticatedEntity>> oauth2ShowLookupWithHttpInfo(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LookupNonAuthenticatedEntity>(this){};
        return this.oauth2ShowLookupRequestCreation(urlName, type, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2ShowLookupWithResponseSpec(String urlName, String type, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2ShowLookupRequestCreation(urlName, type, winkVersion, accept);
    }
}

