package travel.wink.sdk.notification.api;

import travel.wink.sdk.notification.invoker.ApiClient;

import travel.wink.sdk.notification.model.CountResponseAffiliate;
import travel.wink.sdk.notification.model.GenericErrorMessage;
import travel.wink.sdk.notification.model.NotificationViewAffiliate;
import travel.wink.sdk.notification.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.notification.model.ShowNotifications400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-28T11:55:11.080015973+07:00[Asia/Bangkok]")
public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(new ApiClient());
    }

    @Autowired
    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Mark As Read
     * Mark notification as read.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Mark message as read that belongs to this company identifier
     * @param messageIdentifier Message identifier to be marked as read
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return NotificationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec markAsReadRequestCreation(String companyIdentifier, String messageIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling markAsRead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'messageIdentifier' is set
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling markAsRead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling markAsRead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/{messageIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Mark As Read
     * Mark notification as read.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Mark message as read that belongs to this company identifier
     * @param messageIdentifier Message identifier to be marked as read
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return NotificationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<NotificationViewAffiliate> markAsRead(String companyIdentifier, String messageIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return markAsReadRequestCreation(companyIdentifier, messageIdentifier, body, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Mark As Read
     * Mark notification as read.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Mark message as read that belongs to this company identifier
     * @param messageIdentifier Message identifier to be marked as read
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;NotificationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<NotificationViewAffiliate>> markAsReadWithHttpInfo(String companyIdentifier, String messageIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return markAsReadRequestCreation(companyIdentifier, messageIdentifier, body, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Mark As Read
     * Mark notification as read.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Mark message as read that belongs to this company identifier
     * @param messageIdentifier Message identifier to be marked as read
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec markAsReadWithResponseSpec(String companyIdentifier, String messageIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        return markAsReadRequestCreation(companyIdentifier, messageIdentifier, body, winkVersion);
    }
    /**
     * Delete Notification
     * Remove notification specified by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeNotificationRequestCreation(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'messageIdentifier' is set
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/{messageIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove notification specified by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeNotification(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove notification specified by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeNotificationWithHttpInfo(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove notification specified by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeNotificationWithResponseSpec(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept);
    }
    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return NotificationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showNotificationsRequestCreation(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'messageIdentifier' is set
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/{messageIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return NotificationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<NotificationViewAffiliate> showNotifications(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return showNotificationsRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;NotificationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<NotificationViewAffiliate>> showNotificationsWithHttpInfo(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return showNotificationsRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showNotificationsWithResponseSpec(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showNotificationsRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept);
    }
    /**
     * Show Notifications
     * Retrieve all the messages for this company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all messages for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;NotificationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showNotifications1RequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showNotifications1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all messages for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;NotificationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<NotificationViewAffiliate> showNotifications1(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return showNotifications1RequestCreation(companyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all messages for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;NotificationViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<NotificationViewAffiliate>>> showNotifications1WithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return showNotifications1RequestCreation(companyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all messages for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showNotifications1WithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showNotifications1RequestCreation(companyIdentifier, winkVersion, accept);
    }
    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CountResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUnreadMessageCountRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUnreadMessageCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/count", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CountResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CountResponseAffiliate> showUnreadMessageCount(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;CountResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CountResponseAffiliate>> showUnreadMessageCountWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUnreadMessageCountWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept);
    }
}
