package travel.wink.sdk.notification.api;

import travel.wink.sdk.notification.invoker.ApiClient;

import travel.wink.sdk.notification.model.CountResponseAffiliate;
import travel.wink.sdk.notification.model.GenericErrorMessage;
import travel.wink.sdk.notification.model.NotificationAffiliate;
import travel.wink.sdk.notification.model.ShowNotification400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:21:25.585784289+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(new ApiClient());
    }

    @Autowired
    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Delete Notification
     * Remove announcement specified by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return NotificationAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeNotificationRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'messageIdentifier' is set
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/{messageIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove announcement specified by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return NotificationAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<NotificationAffiliate> removeNotification(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove announcement specified by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;NotificationAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<NotificationAffiliate>> removeNotificationWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Notification
     * Remove announcement specified by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove a message that belongs to this company identifier
     * @param messageIdentifier Message identifier to be removed
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeNotificationWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return NotificationAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showNotificationRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'messageIdentifier' is set
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling showNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/{messageIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return NotificationAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<NotificationAffiliate> showNotification(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return showNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;NotificationAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<NotificationAffiliate>> showNotificationWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return showNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Notification
     * Retrieve messages for a specific company by ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Retrieve a message for this company identifier
     * @param messageIdentifier Message identifier to be retrieved
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showNotificationWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String messageIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all messages for this company identifier
     * @param app Show all messages for this application
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;NotificationAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showNotificationsRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String app, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "app", app));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all messages for this company identifier
     * @param app Show all messages for this application
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;NotificationAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<NotificationAffiliate> showNotifications(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String app, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return showNotificationsRequestCreation(companyIdentifier, app, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all messages for this company identifier
     * @param app Show all messages for this application
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;NotificationAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<NotificationAffiliate>>> showNotificationsWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String app, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationAffiliate>() {};
        return showNotificationsRequestCreation(companyIdentifier, app, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Notifications
     * Retrieve all the messages for this company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show all messages for this company identifier
     * @param app Show all messages for this application
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showNotificationsWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String app, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showNotificationsRequestCreation(companyIdentifier, app, winkVersion, accept);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CountResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUnreadMessageCountRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUnreadMessageCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/message/count", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CountResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CountResponseAffiliate> showUnreadMessageCount(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;CountResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CountResponseAffiliate>> showUnreadMessageCountWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Unread Count
     * Retrieve count of unread messages
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show unread message count for this company identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUnreadMessageCountWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept);
    }
}
