/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.support;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class OAuth2WebClientConfiguration {
    @Value(value="${wink.travel.token-uri:https://iam.wink.travel/oauth/token}")
    private String tokenUri;
    @Value(value="${wink.travel.client.id}")
    private String clientId;
    @Value(value="${wink.travel.client.secret}")
    private String clientSecret;
    @Value(value="${wink.travel.scopes:inventory.read,inventory.write,inventory.remove,payment.read,payment.write,payment.remove}")
    private String scope;

    @Bean(name={"oauth2WebClient"})
    WebClient webClient() {
        ServerOAuth2AuthorizedClientExchangeFilterFunction oauth = new ServerOAuth2AuthorizedClientExchangeFilterFunction((ReactiveOAuth2AuthorizedClientManager)new AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(this.reactiveClientRegistrationRepository(), this.reactiveOAuth2AuthorizedClientService()));
        oauth.setDefaultClientRegistrationId("wink-travel");
        return WebClient.builder().filter((ExchangeFilterFunction)oauth).build();
    }

    @Bean
    ReactiveOAuth2AuthorizedClientService reactiveOAuth2AuthorizedClientService() {
        return new InMemoryReactiveOAuth2AuthorizedClientService(this.reactiveClientRegistrationRepository());
    }

    @Bean
    ReactiveClientRegistrationRepository reactiveClientRegistrationRepository() {
        return new InMemoryReactiveClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    ClientRegistration clientRegistration() {
        return ClientRegistration.withRegistrationId((String)"wink-travel").tokenUri(this.tokenUri).clientId(this.clientId).clientSecret(this.clientSecret).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).scope(new String[]{this.scope}).build();
    }
}

