package travel.wink.sdk.payment.acquiring.api;

import travel.wink.sdk.payment.acquiring.invoker.ApiClient;

import travel.wink.sdk.payment.acquiring.model.PriceBookingContractRequest;
import travel.wink.sdk.payment.acquiring.model.PriceBookingContractResponse;
import travel.wink.sdk.payment.acquiring.model.PriceSupplierContractWithAcquirerRequest;
import travel.wink.sdk.payment.acquiring.model.PriceSupplierContractWithAcquirerResponse;
import travel.wink.sdk.payment.acquiring.model.ValidateBookingContractRequest;
import travel.wink.sdk.payment.acquiring.model.ValidateBookingContractResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:58:02.186983+07:00[Asia/Bangkok]")
public class ContractApi {
    private ApiClient apiClient;

    public ContractApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContractApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Price acquirer contract
     * Displays booking contract in requested display quote as well as the selected acquirer&#39;s currency
     * <p><b>200</b> - OK
     * @param priceSupplierContractWithAcquirerRequest The priceSupplierContractWithAcquirerRequest parameter
     * @return PriceSupplierContractWithAcquirerResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec priceRequestCreation(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest) throws WebClientResponseException {
        Object postBody = priceSupplierContractWithAcquirerRequest;
        // verify the required parameter 'priceSupplierContractWithAcquirerRequest' is set
        if (priceSupplierContractWithAcquirerRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'priceSupplierContractWithAcquirerRequest' when calling price", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>() {};
        return apiClient.invokeAPI("/contract/price/acquirer", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Price acquirer contract
     * Displays booking contract in requested display quote as well as the selected acquirer&#39;s currency
     * <p><b>200</b> - OK
     * @param priceSupplierContractWithAcquirerRequest The priceSupplierContractWithAcquirerRequest parameter
     * @return PriceSupplierContractWithAcquirerResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PriceSupplierContractWithAcquirerResponse> price(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>() {};
        return priceRequestCreation(priceSupplierContractWithAcquirerRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PriceSupplierContractWithAcquirerResponse>> priceWithHttpInfo(PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse> localVarReturnType = new ParameterizedTypeReference<PriceSupplierContractWithAcquirerResponse>() {};
        return priceRequestCreation(priceSupplierContractWithAcquirerRequest).toEntity(localVarReturnType);
    }
    /**
     * Price contract
     * Displays booking contract in requested display quote
     * <p><b>200</b> - OK
     * @param priceBookingContractRequest The priceBookingContractRequest parameter
     * @return PriceBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec price1RequestCreation(PriceBookingContractRequest priceBookingContractRequest) throws WebClientResponseException {
        Object postBody = priceBookingContractRequest;
        // verify the required parameter 'priceBookingContractRequest' is set
        if (priceBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'priceBookingContractRequest' when calling price1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>() {};
        return apiClient.invokeAPI("/contract/price", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Price contract
     * Displays booking contract in requested display quote
     * <p><b>200</b> - OK
     * @param priceBookingContractRequest The priceBookingContractRequest parameter
     * @return PriceBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PriceBookingContractResponse> price1(PriceBookingContractRequest priceBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>() {};
        return price1RequestCreation(priceBookingContractRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PriceBookingContractResponse>> price1WithHttpInfo(PriceBookingContractRequest priceBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PriceBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<PriceBookingContractResponse>() {};
        return price1RequestCreation(priceBookingContractRequest).toEntity(localVarReturnType);
    }
    /**
     * Validate contract
     * Validates an incoming raw booking contract request for syntax, price and more.
     * <p><b>200</b> - OK
     * @param validateBookingContractRequest The validateBookingContractRequest parameter
     * @return ValidateBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec validateRequestCreation(ValidateBookingContractRequest validateBookingContractRequest) throws WebClientResponseException {
        Object postBody = validateBookingContractRequest;
        // verify the required parameter 'validateBookingContractRequest' is set
        if (validateBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateBookingContractRequest' when calling validate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>() {};
        return apiClient.invokeAPI("/contract/validate", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Validate contract
     * Validates an incoming raw booking contract request for syntax, price and more.
     * <p><b>200</b> - OK
     * @param validateBookingContractRequest The validateBookingContractRequest parameter
     * @return ValidateBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ValidateBookingContractResponse> validate(ValidateBookingContractRequest validateBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>() {};
        return validateRequestCreation(validateBookingContractRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ValidateBookingContractResponse>> validateWithHttpInfo(ValidateBookingContractRequest validateBookingContractRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ValidateBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<ValidateBookingContractResponse>() {};
        return validateRequestCreation(validateBookingContractRequest).toEntity(localVarReturnType);
    }
}
