/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Affiliate details response contains details about the affiliate facilitating the sale.")
@JsonPropertyOrder(value={"affiliateIdentifier", "affiliateName", "affiliateUrl"})
public class AffiliateDetailsResponse {
    public static final String JSON_PROPERTY_AFFILIATE_IDENTIFIER = "affiliateIdentifier";
    private String affiliateIdentifier;
    public static final String JSON_PROPERTY_AFFILIATE_NAME = "affiliateName";
    private String affiliateName;
    public static final String JSON_PROPERTY_AFFILIATE_URL = "affiliateUrl";
    private String affiliateUrl;

    public AffiliateDetailsResponse() {
    }

    @JsonCreator
    public AffiliateDetailsResponse(@JsonProperty(value="affiliateIdentifier") String affiliateIdentifier, @JsonProperty(value="affiliateName") String affiliateName, @JsonProperty(value="affiliateUrl") String affiliateUrl) {
        this();
        this.affiliateIdentifier = affiliateIdentifier;
        this.affiliateName = affiliateName;
        this.affiliateUrl = affiliateUrl;
    }

    @Nullable
    @ApiModelProperty(example="affiliate-1", value="Affiliate identifier of entity making the same")
    @JsonProperty(value="affiliateIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAffiliateIdentifier() {
        return this.affiliateIdentifier;
    }

    @Nullable
    @ApiModelProperty(example="My Affiliate", value="Affiliate name of entity making the same")
    @JsonProperty(value="affiliateName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAffiliateName() {
        return this.affiliateName;
    }

    @Nullable
    @ApiModelProperty(example="https://www.my-affiliate.com", value="Affiliate url of entity making the same")
    @JsonProperty(value="affiliateUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAffiliateUrl() {
        return this.affiliateUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffiliateDetailsResponse affiliateDetailsResponse = (AffiliateDetailsResponse)o;
        return Objects.equals(this.affiliateIdentifier, affiliateDetailsResponse.affiliateIdentifier) && Objects.equals(this.affiliateName, affiliateDetailsResponse.affiliateName) && Objects.equals(this.affiliateUrl, affiliateDetailsResponse.affiliateUrl);
    }

    public int hashCode() {
        return Objects.hash(this.affiliateIdentifier, this.affiliateName, this.affiliateUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AffiliateDetailsResponse {\n");
        sb.append("    affiliateIdentifier: ").append(this.toIndentedString(this.affiliateIdentifier)).append("\n");
        sb.append("    affiliateName: ").append(this.toIndentedString(this.affiliateName)).append("\n");
        sb.append("    affiliateUrl: ").append(this.toIndentedString(this.affiliateUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

