/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.payment.acquiring.model.RawSupplierContract;

@JsonPropertyOrder(value={"apiKey", "displayCurrency", "sourceUrl", "traceId", "contract", "acquirerIdentifier"})
public class PriceSupplierContractWithAcquirerRequest {
    public static final String JSON_PROPERTY_API_KEY = "apiKey";
    private String apiKey;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_CONTRACT = "contract";
    private RawSupplierContract contract;
    public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
    private String acquirerIdentifier;

    public PriceSupplierContractWithAcquirerRequest() {
    }

    @JsonCreator
    public PriceSupplierContractWithAcquirerRequest(@JsonProperty(value="acquirerIdentifier") String acquirerIdentifier) {
        this();
        this.acquirerIdentifier = acquirerIdentifier;
    }

    public PriceSupplierContractWithAcquirerRequest apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="API key for the integrating account making the call")
    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public PriceSupplierContractWithAcquirerRequest displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="The desired quote")
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public PriceSupplierContractWithAcquirerRequest sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public PriceSupplierContractWithAcquirerRequest traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="integrator-booking-code-1", value="Integrator can choose to include a unique identifier to help identify the collection of bookings")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public PriceSupplierContractWithAcquirerRequest contract(RawSupplierContract contract) {
        this.contract = contract;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RawSupplierContract getContract() {
        return this.contract;
    }

    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContract(RawSupplierContract contract) {
        this.contract = contract;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Selected acquirer")
    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAcquirerIdentifier() {
        return this.acquirerIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceSupplierContractWithAcquirerRequest priceSupplierContractWithAcquirerRequest = (PriceSupplierContractWithAcquirerRequest)o;
        return Objects.equals(this.apiKey, priceSupplierContractWithAcquirerRequest.apiKey) && Objects.equals(this.displayCurrency, priceSupplierContractWithAcquirerRequest.displayCurrency) && Objects.equals(this.sourceUrl, priceSupplierContractWithAcquirerRequest.sourceUrl) && Objects.equals(this.traceId, priceSupplierContractWithAcquirerRequest.traceId) && Objects.equals(this.contract, priceSupplierContractWithAcquirerRequest.contract) && Objects.equals(this.acquirerIdentifier, priceSupplierContractWithAcquirerRequest.acquirerIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.displayCurrency, this.sourceUrl, this.traceId, this.contract, this.acquirerIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PriceSupplierContractWithAcquirerRequest {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("    acquirerIdentifier: ").append(this.toIndentedString(this.acquirerIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

