/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.payment.acquiring.model.Acquirer;
import travel.wink.sdk.payment.acquiring.model.Moneys;
import travel.wink.sdk.payment.acquiring.model.PricedSupplierContractItem;
import travel.wink.sdk.payment.acquiring.model.QuoteData;

@ApiModel(description="Details of the booking entries that went in for one particular supplier directly.")
@JsonPropertyOrder(value={"identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "itemList", "acquirerList", "externalSupplierIdentifier", "externalSupplierBookingCode", "externalTransactionIdentifier", "totalSupplierPrice", "totalDisplayPrice", "totalInternalPrice", "totalPrice"})
public class PricedSupplierContract {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private String supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private QuoteData displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private QuoteData supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private QuoteData internalPriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<PricedSupplierContractItem> itemList = new ArrayList<PricedSupplierContractItem>();
    public static final String JSON_PROPERTY_ACQUIRER_LIST = "acquirerList";
    private List<Acquirer> acquirerList = new ArrayList<Acquirer>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
    private String externalTransactionIdentifier;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private Moneys totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private Moneys totalInternalPrice;
    public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
    private Moneys totalPrice;

    public PricedSupplierContract() {
    }

    @JsonCreator
    public PricedSupplierContract(@JsonProperty(value="identifier") String identifier, @JsonProperty(value="supplierIdentifier") String supplierIdentifier, @JsonProperty(value="supplierName") String supplierName, @JsonProperty(value="itemList") List<PricedSupplierContractItem> itemList, @JsonProperty(value="acquirerList") List<Acquirer> acquirerList, @JsonProperty(value="externalSupplierIdentifier") String externalSupplierIdentifier, @JsonProperty(value="externalSupplierBookingCode") String externalSupplierBookingCode) {
        this();
        this.identifier = identifier;
        this.supplierIdentifier = supplierIdentifier;
        this.supplierName = supplierName;
        this.itemList = itemList;
        this.acquirerList = acquirerList;
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    @Nonnull
    @ApiModelProperty(example="unique-supplier-booking-contract-1", required=true, value="Unique identifier used to track the contract. Create a UUID for this purpose.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    @ApiModelProperty(example="supplier-1", required=true, value="Supplier identifier")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="Supplier One", required=true, value="Supplier name")
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    public PricedSupplierContract displayPriceQuote(QuoteData displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(QuoteData displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public PricedSupplierContract supplierPriceQuote(QuoteData supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(QuoteData supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public PricedSupplierContract internalPriceQuote(QuoteData internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(QuoteData internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    @Nonnull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @Valid @Size(min=1, max=0x7FFFFFFF) List<PricedSupplierContractItem> getItemList() {
        return this.itemList;
    }

    @Nonnull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="acquirerList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @Valid @Size(min=1, max=0x7FFFFFFF) List<Acquirer> getAcquirerList() {
        return this.acquirerList;
    }

    @Nonnull
    @ApiModelProperty(example="external-supplier-a", required=true, value="Track supplier with its external supplier identifier")
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="external-booking-code-1", required=true, value="External booking code generated by the affiliate")
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    public PricedSupplierContract externalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="external-transaction-1", value="External transaction identifier populated when agent responsible for acquiring")
    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalTransactionIdentifier() {
        return this.externalTransactionIdentifier;
    }

    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
    }

    public PricedSupplierContract totalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public PricedSupplierContract totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public PricedSupplierContract totalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public PricedSupplierContract totalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalPrice(Moneys totalPrice) {
        this.totalPrice = totalPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricedSupplierContract pricedSupplierContract = (PricedSupplierContract)o;
        return Objects.equals(this.identifier, pricedSupplierContract.identifier) && Objects.equals(this.supplierIdentifier, pricedSupplierContract.supplierIdentifier) && Objects.equals(this.supplierName, pricedSupplierContract.supplierName) && Objects.equals(this.displayPriceQuote, pricedSupplierContract.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, pricedSupplierContract.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, pricedSupplierContract.internalPriceQuote) && Objects.equals(this.itemList, pricedSupplierContract.itemList) && Objects.equals(this.acquirerList, pricedSupplierContract.acquirerList) && Objects.equals(this.externalSupplierIdentifier, pricedSupplierContract.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, pricedSupplierContract.externalSupplierBookingCode) && Objects.equals(this.externalTransactionIdentifier, pricedSupplierContract.externalTransactionIdentifier) && Objects.equals(this.totalSupplierPrice, pricedSupplierContract.totalSupplierPrice) && Objects.equals(this.totalDisplayPrice, pricedSupplierContract.totalDisplayPrice) && Objects.equals(this.totalInternalPrice, pricedSupplierContract.totalInternalPrice) && Objects.equals(this.totalPrice, pricedSupplierContract.totalPrice);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.itemList, this.acquirerList, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.externalTransactionIdentifier, this.totalSupplierPrice, this.totalDisplayPrice, this.totalInternalPrice, this.totalPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricedSupplierContract {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    acquirerList: ").append(this.toIndentedString(this.acquirerList)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    externalTransactionIdentifier: ").append(this.toIndentedString(this.externalTransactionIdentifier)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

