/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.payment.acquiring.model.PricedSupplierContractWithAcquirer;

@JsonPropertyOrder(value={"apiKey", "displayCurrency", "sourceUrl", "traceId", "contract"})
public class PriceSupplierContractWithAcquirerResponse {
    public static final String JSON_PROPERTY_API_KEY = "apiKey";
    private String apiKey;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_CONTRACT = "contract";
    private PricedSupplierContractWithAcquirer contract;

    public PriceSupplierContractWithAcquirerResponse() {
    }

    @JsonCreator
    public PriceSupplierContractWithAcquirerResponse(@JsonProperty(value="apiKey") String apiKey, @JsonProperty(value="displayCurrency") String displayCurrency, @JsonProperty(value="sourceUrl") String sourceUrl, @JsonProperty(value="traceId") String traceId) {
        this();
        this.apiKey = apiKey;
        this.displayCurrency = displayCurrency;
        this.sourceUrl = sourceUrl;
        this.traceId = traceId;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="API key for the integrating account making the call")
    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    @Nonnull
    @ApiModelProperty(example="USD", required=true, value="The desired quote")
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @Nonnull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @Nonnull
    @ApiModelProperty(example="integrator-booking-code-1", required=true, value="Integrator can choose to include a unique identifier to help identify the collection of bookings")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    public PriceSupplierContractWithAcquirerResponse contract(PricedSupplierContractWithAcquirer contract) {
        this.contract = contract;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricedSupplierContractWithAcquirer getContract() {
        return this.contract;
    }

    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContract(PricedSupplierContractWithAcquirer contract) {
        this.contract = contract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceSupplierContractWithAcquirerResponse priceSupplierContractWithAcquirerResponse = (PriceSupplierContractWithAcquirerResponse)o;
        return Objects.equals(this.apiKey, priceSupplierContractWithAcquirerResponse.apiKey) && Objects.equals(this.displayCurrency, priceSupplierContractWithAcquirerResponse.displayCurrency) && Objects.equals(this.sourceUrl, priceSupplierContractWithAcquirerResponse.sourceUrl) && Objects.equals(this.traceId, priceSupplierContractWithAcquirerResponse.traceId) && Objects.equals(this.contract, priceSupplierContractWithAcquirerResponse.contract);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.displayCurrency, this.sourceUrl, this.traceId, this.contract);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PriceSupplierContractWithAcquirerResponse {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

