/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.payment.acquiring.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.payment.acquiring.model.Moneys;
import travel.wink.sdk.payment.acquiring.model.PricedSupplierContract;

@ApiModel(description="Validated and priced contract")
@JsonPropertyOrder(value={"apiKey", "displayCurrency", "sourceUrl", "contractList", "totalDisplayPrice"})
public class PricedBookingContract {
    public static final String JSON_PROPERTY_API_KEY = "apiKey";
    private String apiKey;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_CONTRACT_LIST = "contractList";
    private List<PricedSupplierContract> contractList = new ArrayList<PricedSupplierContract>();
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;

    public PricedBookingContract apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="API key for the integrating account making the call")
    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public PricedBookingContract displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="The desired quote")
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public PricedBookingContract sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public PricedBookingContract contractList(List<PricedSupplierContract> contractList) {
        this.contractList = contractList;
        return this;
    }

    public PricedBookingContract addContractListItem(PricedSupplierContract contractListItem) {
        this.contractList.add(contractListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<PricedSupplierContract> getContractList() {
        return this.contractList;
    }

    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractList(List<PricedSupplierContract> contractList) {
        this.contractList = contractList;
    }

    public PricedBookingContract totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricedBookingContract pricedBookingContract = (PricedBookingContract)o;
        return Objects.equals(this.apiKey, pricedBookingContract.apiKey) && Objects.equals(this.displayCurrency, pricedBookingContract.displayCurrency) && Objects.equals(this.sourceUrl, pricedBookingContract.sourceUrl) && Objects.equals(this.contractList, pricedBookingContract.contractList) && Objects.equals(this.totalDisplayPrice, pricedBookingContract.totalDisplayPrice);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.displayCurrency, this.sourceUrl, this.contractList, this.totalDisplayPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricedBookingContract {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    contractList: ").append(this.toIndentedString(this.contractList)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

