package travel.wink.sdk.payment.acquiring.api;

import travel.wink.sdk.payment.acquiring.invoker.ApiClient;

import travel.wink.sdk.payment.acquiring.model.AffiliateDetailsRequest;
import travel.wink.sdk.payment.acquiring.model.AffiliateDetailsResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-03T12:25:58.038168+07:00[Asia/Bangkok]")
public class AffiliateApi {
    private ApiClient apiClient;

    public AffiliateApi() {
        this(new ApiClient());
    }

    @Autowired
    public AffiliateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Affiliate Details
     * Returns basic affiliate details.
     * <p><b>200</b> - OK
     * @param affiliateDetailsRequest The affiliateDetailsRequest parameter
     * @return AffiliateDetailsResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAffiliateDetailsRequestCreation(AffiliateDetailsRequest affiliateDetailsRequest) throws WebClientResponseException {
        Object postBody = affiliateDetailsRequest;
        // verify the required parameter 'affiliateDetailsRequest' is set
        if (affiliateDetailsRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'affiliateDetailsRequest' when calling showAffiliateDetails", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<AffiliateDetailsResponse> localVarReturnType = new ParameterizedTypeReference<AffiliateDetailsResponse>() {};
        return apiClient.invokeAPI("/contract/affiliate/details", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Affiliate Details
     * Returns basic affiliate details.
     * <p><b>200</b> - OK
     * @param affiliateDetailsRequest The affiliateDetailsRequest parameter
     * @return AffiliateDetailsResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateDetailsResponse> showAffiliateDetails(AffiliateDetailsRequest affiliateDetailsRequest) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateDetailsResponse> localVarReturnType = new ParameterizedTypeReference<AffiliateDetailsResponse>() {};
        return showAffiliateDetailsRequestCreation(affiliateDetailsRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateDetailsResponse>> showAffiliateDetailsWithHttpInfo(AffiliateDetailsRequest affiliateDetailsRequest) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateDetailsResponse> localVarReturnType = new ParameterizedTypeReference<AffiliateDetailsResponse>() {};
        return showAffiliateDetailsRequestCreation(affiliateDetailsRequest).toEntity(localVarReturnType);
    }
}
