/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Web Component](/docs?api=wc): All APIs related to how our Web Components work. - [Account](/docs?api=contract): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 20.0.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.payment.acquiring.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.payment.acquiring.model.Acquirer;
import travel.wink.sdk.payment.acquiring.model.Moneys;
import travel.wink.sdk.payment.acquiring.model.PricedSupplierContractItemWithAcquirer;
import travel.wink.sdk.payment.acquiring.model.QuoteData;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Details of the booking entries that went in for one particular supplier directly.
 */
@ApiModel(description = "Details of the booking entries that went in for one particular supplier directly.")
@JsonPropertyOrder({
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_IDENTIFIER,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_SUPPLIER_NAME,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_ITEM_LIST,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_ACQUIRER,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_TOTAL_DISPLAY_PRICE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_TOTAL_INTERNAL_PRICE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_TOTAL_CAPTURE_PRICE,
  PricedSupplierContractWithAcquirer.JSON_PROPERTY_TOTAL_PRICE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-03T12:25:58.038168+07:00[Asia/Bangkok]")
public class PricedSupplierContractWithAcquirer {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private String supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  private QuoteData displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  private QuoteData supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  private QuoteData internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  private QuoteData capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  private List<PricedSupplierContractItemWithAcquirer> itemList = new ArrayList<>();

  public static final String JSON_PROPERTY_ACQUIRER = "acquirer";
  private List<Acquirer> acquirer = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
  private String externalTransactionIdentifier;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
  private Moneys totalSupplierPrice;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
  private Moneys totalDisplayPrice;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
  private Moneys totalInternalPrice;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
  private Moneys totalCapturePrice;

  public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
  private Moneys totalPrice;

  public PricedSupplierContractWithAcquirer() { 
  }

  @JsonCreator
  public PricedSupplierContractWithAcquirer(
    @JsonProperty(JSON_PROPERTY_IDENTIFIER) String identifier, 
    @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER) String supplierIdentifier, 
    @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME) String supplierName, 
    @JsonProperty(JSON_PROPERTY_ITEM_LIST) List<PricedSupplierContractItemWithAcquirer> itemList, 
    @JsonProperty(JSON_PROPERTY_ACQUIRER) List<Acquirer> acquirer, 
    @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER) String externalSupplierIdentifier, 
    @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE) String externalSupplierBookingCode
  ) {
    this();
    this.identifier = identifier;
    this.supplierIdentifier = supplierIdentifier;
    this.supplierName = supplierName;
    this.itemList = itemList;
    this.acquirer = acquirer;
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }

   /**
   * Unique identifier used to track the contract. Create a UUID for this purpose.
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "unique-supplier-booking-contract-1", required = true, value = "Unique identifier used to track the contract. Create a UUID for this purpose.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }




   /**
   * Supplier identifier
   * @return supplierIdentifier
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "supplier-1", required = true, value = "Supplier identifier")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierIdentifier() {
    return supplierIdentifier;
  }




   /**
   * Supplier name
   * @return supplierName
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "Supplier One", required = true, value = "Supplier name")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }




  public PricedSupplierContractWithAcquirer displayPriceQuote(QuoteData displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

   /**
   * Get displayPriceQuote
   * @return displayPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteData getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPriceQuote(QuoteData displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }


  public PricedSupplierContractWithAcquirer supplierPriceQuote(QuoteData supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

   /**
   * Get supplierPriceQuote
   * @return supplierPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteData getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPriceQuote(QuoteData supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }


  public PricedSupplierContractWithAcquirer internalPriceQuote(QuoteData internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

   /**
   * Get internalPriceQuote
   * @return internalPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteData getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPriceQuote(QuoteData internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }


  public PricedSupplierContractWithAcquirer capturePriceQuote(QuoteData capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

   /**
   * Get capturePriceQuote
   * @return capturePriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteData getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePriceQuote(QuoteData capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }


   /**
   * Get itemList
   * @return itemList
  **/
  @javax.annotation.Nonnull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<PricedSupplierContractItemWithAcquirer> getItemList() {
    return itemList;
  }




   /**
   * Get acquirer
   * @return acquirer
  **/
  @javax.annotation.Nonnull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ACQUIRER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Acquirer> getAcquirer() {
    return acquirer;
  }




   /**
   * Track supplier with its external supplier identifier
   * @return externalSupplierIdentifier
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "external-supplier-a", required = true, value = "Track supplier with its external supplier identifier")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }




   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "external-booking-code-1", required = true, value = "External booking code generated by the affiliate")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }




  public PricedSupplierContractWithAcquirer externalTransactionIdentifier(String externalTransactionIdentifier) {
    
    this.externalTransactionIdentifier = externalTransactionIdentifier;
    return this;
  }

   /**
   * External transaction identifier populated when agent responsible for acquiring
   * @return externalTransactionIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "external-transaction-1", required = true, value = "External transaction identifier populated when agent responsible for acquiring")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalTransactionIdentifier() {
    return externalTransactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
    this.externalTransactionIdentifier = externalTransactionIdentifier;
  }


  public PricedSupplierContractWithAcquirer totalSupplierPrice(Moneys totalSupplierPrice) {
    
    this.totalSupplierPrice = totalSupplierPrice;
    return this;
  }

   /**
   * Get totalSupplierPrice
   * @return totalSupplierPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSupplierPrice() {
    return totalSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
    this.totalSupplierPrice = totalSupplierPrice;
  }


  public PricedSupplierContractWithAcquirer totalDisplayPrice(Moneys totalDisplayPrice) {
    
    this.totalDisplayPrice = totalDisplayPrice;
    return this;
  }

   /**
   * Get totalDisplayPrice
   * @return totalDisplayPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalDisplayPrice() {
    return totalDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
    this.totalDisplayPrice = totalDisplayPrice;
  }


  public PricedSupplierContractWithAcquirer totalInternalPrice(Moneys totalInternalPrice) {
    
    this.totalInternalPrice = totalInternalPrice;
    return this;
  }

   /**
   * Get totalInternalPrice
   * @return totalInternalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalInternalPrice() {
    return totalInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPrice(Moneys totalInternalPrice) {
    this.totalInternalPrice = totalInternalPrice;
  }


  public PricedSupplierContractWithAcquirer totalCapturePrice(Moneys totalCapturePrice) {
    
    this.totalCapturePrice = totalCapturePrice;
    return this;
  }

   /**
   * Get totalCapturePrice
   * @return totalCapturePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalCapturePrice() {
    return totalCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePrice(Moneys totalCapturePrice) {
    this.totalCapturePrice = totalCapturePrice;
  }


  public PricedSupplierContractWithAcquirer totalPrice(Moneys totalPrice) {
    
    this.totalPrice = totalPrice;
    return this;
  }

   /**
   * Get totalPrice
   * @return totalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalPrice() {
    return totalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalPrice(Moneys totalPrice) {
    this.totalPrice = totalPrice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PricedSupplierContractWithAcquirer pricedSupplierContractWithAcquirer = (PricedSupplierContractWithAcquirer) o;
    return Objects.equals(this.identifier, pricedSupplierContractWithAcquirer.identifier) &&
        Objects.equals(this.supplierIdentifier, pricedSupplierContractWithAcquirer.supplierIdentifier) &&
        Objects.equals(this.supplierName, pricedSupplierContractWithAcquirer.supplierName) &&
        Objects.equals(this.displayPriceQuote, pricedSupplierContractWithAcquirer.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, pricedSupplierContractWithAcquirer.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, pricedSupplierContractWithAcquirer.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, pricedSupplierContractWithAcquirer.capturePriceQuote) &&
        Objects.equals(this.itemList, pricedSupplierContractWithAcquirer.itemList) &&
        Objects.equals(this.acquirer, pricedSupplierContractWithAcquirer.acquirer) &&
        Objects.equals(this.externalSupplierIdentifier, pricedSupplierContractWithAcquirer.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, pricedSupplierContractWithAcquirer.externalSupplierBookingCode) &&
        Objects.equals(this.externalTransactionIdentifier, pricedSupplierContractWithAcquirer.externalTransactionIdentifier) &&
        Objects.equals(this.totalSupplierPrice, pricedSupplierContractWithAcquirer.totalSupplierPrice) &&
        Objects.equals(this.totalDisplayPrice, pricedSupplierContractWithAcquirer.totalDisplayPrice) &&
        Objects.equals(this.totalInternalPrice, pricedSupplierContractWithAcquirer.totalInternalPrice) &&
        Objects.equals(this.totalCapturePrice, pricedSupplierContractWithAcquirer.totalCapturePrice) &&
        Objects.equals(this.totalPrice, pricedSupplierContractWithAcquirer.totalPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, acquirer, externalSupplierIdentifier, externalSupplierBookingCode, externalTransactionIdentifier, totalSupplierPrice, totalDisplayPrice, totalInternalPrice, totalCapturePrice, totalPrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PricedSupplierContractWithAcquirer {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    acquirer: ").append(toIndentedString(acquirer)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    externalTransactionIdentifier: ").append(toIndentedString(externalTransactionIdentifier)).append("\n");
    sb.append("    totalSupplierPrice: ").append(toIndentedString(totalSupplierPrice)).append("\n");
    sb.append("    totalDisplayPrice: ").append(toIndentedString(totalDisplayPrice)).append("\n");
    sb.append("    totalInternalPrice: ").append(toIndentedString(totalInternalPrice)).append("\n");
    sb.append("    totalCapturePrice: ").append(toIndentedString(totalCapturePrice)).append("\n");
    sb.append("    totalPrice: ").append(toIndentedString(totalPrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

